/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.fluid;

import dev.architectury.fluid.FluidStack;
import java.util.function.Predicate;
import net.creeperhost.polylib.Serializable;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.creeperhost.polylib.inventory.fluid.PolyFluidStorage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolyTank
implements PolyFluidStorage,
PolyFluidHandler,
Serializable {
    protected Predicate<FluidStack> validator;
    protected Runnable dirtyListener;
    @NotNull
    protected FluidStack fluid = FluidStack.empty();
    protected long capacity;

    public PolyTank(long capacity) {
        this(capacity, e -> true, null);
    }

    public PolyTank(long capacity, Predicate<FluidStack> validator) {
        this(capacity, validator, null);
    }

    public PolyTank(long capacity, Predicate<FluidStack> validator, @Nullable Runnable dirtyListener) {
        this.capacity = capacity;
        this.validator = validator;
        this.dirtyListener = dirtyListener;
    }

    public PolyTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public PolyTank setValidator(@Nullable Predicate<FluidStack> validator) {
        this.validator = validator == null ? e -> true : validator;
        return this;
    }

    public PolyTank setDirtyListener(Runnable dirtyListener) {
        this.dirtyListener = dirtyListener;
        return this;
    }

    @Override
    @NotNull
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public long getFluidAmount() {
        return this.fluid.getAmount();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.getCapacity();
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    @Override
    public long fill(FluidStack resource, boolean simulate) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        if (simulate) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0L;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = FluidStack.create((FluidStack)resource, (long)Math.min(this.capacity, resource.getAmount()));
            this.markDirty();
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0L;
        }
        long space = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < space) {
            this.fluid.grow(resource.getAmount());
            space = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (space > 0L) {
            this.markDirty();
        }
        return space;
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        long drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = FluidStack.create((FluidStack)this.fluid, (long)drained);
        if (!simulate && drained > 0L) {
            this.fluid.shrink(drained);
            this.markDirty();
        }
        return stack;
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.empty();
        }
        return this.drain(resource.getAmount(), simulate);
    }

    @Override
    public void _setFluidInTank(int tank, FluidStack fluidStack) {
        this.fluid = fluidStack;
    }

    public void markDirty() {
        if (this.dirtyListener != null) {
            this.dirtyListener.run();
        }
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    @Override
    public void deserialize(class_11368 input) {
        this.fluid = input.method_71426("poly_tank", FluidStack.CODEC).orElse(FluidStack.empty());
    }

    @Override
    public void serialize(class_11372 output) {
        output.method_71468("poly_tank", FluidStack.CODEC, (Object)this.fluid);
    }

    public void readFromBuf(class_9129 buf) {
        this.fluid = buf.readBoolean() ? FluidStack.read((class_9129)buf) : FluidStack.empty();
    }

    public void writeToBuf(class_9129 buf) {
        buf.method_52964(!this.fluid.isEmpty());
        if (!this.fluid.isEmpty()) {
            this.fluid.write(buf);
        }
    }
}

