/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.mulitblock.rectangular;

import net.creeperhost.polylib.mulitblock.MultiblockBlockEntityBase;
import net.creeperhost.polylib.mulitblock.MultiblockControllerBase;
import net.creeperhost.polylib.mulitblock.MultiblockValidationException;
import net.creeperhost.polylib.mulitblock.rectangular.PartPosition;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class RectangularMultiblockTileEntityBase
extends MultiblockBlockEntityBase {
    PartPosition position = PartPosition.Unknown;
    class_2350 outwards = null;

    public RectangularMultiblockTileEntityBase(class_2591<?> tileEntityTypeIn, class_2338 blockPos, class_2680 blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public class_2350 getOutwardsDir() {
        return this.outwards;
    }

    public PartPosition getPartPosition() {
        return this.position;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        class_2338 maxCoord = controller.getMaximumCoord();
        class_2338 minCoord = controller.getMinimumCoord();
        this.recalculateOutwardsDirection(minCoord, maxCoord);
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwards = null;
    }

    public void recalculateOutwardsDirection(class_2338 minCoord, class_2338 maxCoord) {
        this.outwards = null;
        this.position = PartPosition.Unknown;
        int facesMatching = 0;
        if (maxCoord.method_10263() == this.method_11016().method_10263() || minCoord.method_10263() == this.method_11016().method_10263()) {
            ++facesMatching;
        }
        if (maxCoord.method_10264() == this.method_11016().method_10264() || minCoord.method_10264() == this.method_11016().method_10264()) {
            ++facesMatching;
        }
        if (maxCoord.method_10260() == this.method_11016().method_10260() || minCoord.method_10260() == this.method_11016().method_10260()) {
            ++facesMatching;
        }
        if (facesMatching <= 0) {
            this.position = PartPosition.Interior;
        } else if (facesMatching >= 3) {
            this.position = PartPosition.FrameCorner;
        } else if (facesMatching == 2) {
            this.position = PartPosition.Frame;
        } else if (maxCoord.method_10263() == this.method_11016().method_10263()) {
            this.position = PartPosition.EastFace;
            this.outwards = class_2350.field_11034;
        } else if (minCoord.method_10263() == this.method_11016().method_10263()) {
            this.position = PartPosition.WestFace;
            this.outwards = class_2350.field_11039;
        } else if (maxCoord.method_10260() == this.method_11016().method_10260()) {
            this.position = PartPosition.SouthFace;
            this.outwards = class_2350.field_11035;
        } else if (minCoord.method_10260() == this.method_11016().method_10260()) {
            this.position = PartPosition.NorthFace;
            this.outwards = class_2350.field_11043;
        } else if (maxCoord.method_10264() == this.method_11016().method_10264()) {
            this.position = PartPosition.TopFace;
            this.outwards = class_2350.field_11036;
        } else {
            this.position = PartPosition.BottomFace;
            this.outwards = class_2350.field_11033;
        }
    }

    public abstract void isGoodForFrame() throws MultiblockValidationException;

    public abstract void isGoodForSides() throws MultiblockValidationException;

    public abstract void isGoodForTop() throws MultiblockValidationException;

    public abstract void isGoodForBottom() throws MultiblockValidationException;

    public abstract void isGoodForInterior() throws MultiblockValidationException;
}

