/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.ForegroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class GuiTextList
extends GuiElement<GuiTextList>
implements ForegroundRender {
    private Supplier<List<? extends class_2561>> text;
    private Supplier<Boolean> shadow = () -> true;
    private Supplier<Integer> textColour = () -> -1;
    private boolean scroll = true;
    private Align horizontalAlign = Align.CENTER;
    private Align verticalAlign = Align.TOP;
    private int lineSpacing = 0;

    public GuiTextList(@NotNull GuiParent<?> parent) {
        this(parent, () -> null);
    }

    public GuiTextList(@NotNull GuiParent<?> parent, List<? extends class_2561> text) {
        this(parent, () -> text);
    }

    public GuiTextList(@NotNull GuiParent<?> parent, @NotNull Supplier<List<? extends class_2561>> text) {
        super(parent);
        this.text = text;
    }

    public GuiTextList autoHeight() {
        this.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> {
            Objects.requireNonNull(this.font());
            return (double)((9 + this.lineSpacing) * this.getText().size()) - 1.0;
        }));
        return this;
    }

    public GuiTextList setTextSupplier(@NotNull Supplier<List<? extends class_2561>> textSupplier) {
        this.text = textSupplier;
        return this;
    }

    public GuiTextList setText(List<? extends class_2561> text) {
        this.text = () -> text;
        return this;
    }

    public List<? extends class_2561> getText() {
        return this.text.get();
    }

    public GuiTextList setHorizontalAlign(Align horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
        return this;
    }

    public GuiTextList setVerticalAlign(Align verticalAlign) {
        this.verticalAlign = verticalAlign;
        return this;
    }

    public Align getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public Align getVerticalAlign() {
        return this.verticalAlign;
    }

    public GuiTextList setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public GuiTextList setScroll(boolean scroll) {
        this.scroll = scroll;
        return this;
    }

    public boolean getScroll() {
        return this.scroll;
    }

    public GuiTextList setShadow(@NotNull Supplier<Boolean> shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiTextList setShadow(boolean shadow) {
        this.shadow = () -> shadow;
        return this;
    }

    public boolean getShadow() {
        return this.shadow.get();
    }

    public GuiTextList setTextColour(Supplier<Integer> textColour) {
        this.textColour = textColour;
        return this;
    }

    public GuiTextList setTextColour(int textColour) {
        this.textColour = () -> textColour;
        return this;
    }

    public int getTextColour() {
        return this.textColour.get();
    }

    @Override
    public void renderInFront(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        List<? extends class_2561> list = this.getText();
        if (list.isEmpty()) {
            return;
        }
        class_327 font = render.font();
        int n = list.size();
        Objects.requireNonNull(font);
        double height = n * (9 + this.lineSpacing) - this.lineSpacing;
        double yPos = this.verticalAlign == Align.MIN ? this.yMin() : (this.verticalAlign == Align.MAX ? this.yMax() - height : this.yCenter() - height / 2.0 + 1.0);
        for (class_2561 class_25612 : list) {
            boolean tooLong;
            int textWidth = font.method_27525((class_5348)class_25612);
            boolean bl = tooLong = (double)textWidth > this.xSize();
            if (tooLong && this.scroll) {
                render.pushScissorRect(this.getRectangle());
                render.drawScrollingString(class_25612, this.xMin(), yPos, this.xMax(), this.getTextColour(), this.getShadow(), false);
                render.popScissor();
            } else {
                double xPos = this.horizontalAlign == Align.MIN ? this.xMin() : (this.horizontalAlign == Align.MAX ? this.xMax() - (double)textWidth : this.xMin() + this.xSize() / 2.0 - (double)textWidth / 2.0);
                render.drawString(class_25612, xPos, yPos, this.getTextColour(), this.getShadow());
            }
            Objects.requireNonNull(font);
            yPos += (double)(9 + this.lineSpacing);
        }
    }
}

