/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.creeperhost.polylib.PolyLibClient;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Borders;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4668;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7764;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2ic;

public class GuiRender {
    private final class_332 wrapped;
    private class_327 fontOverride;
    private class_1799 tooltipStack = class_1799.field_8037;
    private static final Function<class_2960, class_1921> GUI_TEXTURED = class_156.method_34866(arg -> GuiRender.create("gui_textured", 786432, class_10799.field_56883, class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(arg, false)).method_23617(false)));

    public GuiRender(class_332 wrapped) {
        this.wrapped = wrapped;
    }

    public class_332 graphics() {
        return this.wrapped;
    }

    public Matrix3x2fStack pose() {
        return this.wrapped.method_51448();
    }

    public class_310 mc() {
        return this.wrapped.field_44656;
    }

    public class_327 font() {
        return this.fontOverride == null ? this.mc().field_1772 : this.fontOverride;
    }

    public int guiWidth() {
        return this.mc().method_22683().method_4486();
    }

    public int guiHeight() {
        return this.mc().method_22683().method_4502();
    }

    public void overrideFont(@Nullable class_327 font) {
        this.fontOverride = font;
    }

    public void rect(Rectangle rectangle, int colour) {
        this.rect(class_10799.field_56879, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(RenderPipeline type, Rectangle rectangle, int colour) {
        this.rect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(double x, double y, double width, double height, int colour) {
        this.fill(class_10799.field_56879, x, y, x + width, y + height, colour);
    }

    public void rect(RenderPipeline type, double x, double y, double width, double height, int colour) {
        this.fill(type, x, y, x + width, y + height, colour);
    }

    public void fill(double xMin, double yMin, double xMax, double yMax, int colour) {
        this.fill(class_10799.field_56879, xMin, yMin, xMax, yMax, colour);
    }

    public void fill(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, int colour) {
        this.wrapped.method_48196(type, (int)xMin, (int)yMin, (int)xMax, (int)yMax, colour);
    }

    public void gradientFillV(double xMin, double yMin, double xMax, double yMax, int topColour, int bottomColour) {
        this.wrapped.method_25296((int)xMin, (int)yMin, (int)xMax, (int)yMax, topColour, bottomColour);
    }

    public void borderRect(Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderRect(RenderPipeline type, Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(RenderPipeline type, double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(class_10799.field_56879, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
    }

    public void borderFill(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.borderFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
    }

    private void borderFillInternal(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.fill(type, xMin, yMin, xMax, yMin + borderWidth, borderColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, borderColour);
        this.fill(type, xMin, yMax - borderWidth, xMax, yMax, borderColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, borderColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(class_10799.field_56879, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(class_10799.field_56879, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(class_10799.field_56879, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(class_10799.field_56879, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(RenderPipeline type, double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(type, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(class_10799.field_56879, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(class_10799.field_56879, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFillInternal(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.fill(type, xMin, yMin, xMax - borderWidth, yMin + borderWidth, topLeftColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, topLeftColour);
        this.fill(type, xMin + borderWidth, yMax - borderWidth, xMax, yMax, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin, xMax, yMin + borderWidth, cornerMixColour);
        this.fill(type, xMin, yMax - borderWidth, xMin + borderWidth, yMax, cornerMixColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void toolTipBackground(double x, double y, double width, double height) {
        this.toolTipBackground(x, y, width, height, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColour, int borderColourTop, int borderColourBottom) {
        this.toolTipBackground(x, y, width, height, backgroundColour, backgroundColour, borderColourTop, borderColourBottom, false);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        this.toolTipBackgroundInternal(x, y, x + width, y + height, backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false);
    }

    private void toolTipBackgroundInternal(double xMin, double yMin, double xMax, double yMax, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        this.fill(xMin + 1.0, yMin, xMax - 1.0, yMin + 1.0, backgroundColourTop);
        this.fill(xMin + 1.0, yMax - 1.0, xMax - 1.0, yMax, backgroundColourBottom);
        this.gradientFillV(xMin, yMin + 1.0, xMin + 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        this.gradientFillV(xMax - 1.0, yMin + 1.0, xMax, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        if (!empty) {
            this.gradientFillV(xMin + 1.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        }
        this.gradientFillV(xMin + 1.0, yMin + 1.0, xMin + 2.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.gradientFillV(xMax - 2.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.fill(xMin + 2.0, yMin + 1.0, xMax - 2.0, yMin + 2.0, borderColourTop);
        this.fill(xMin + 2.0, yMax - 2.0, xMax - 2.0, yMax - 1.0, borderColourBottom);
    }

    public void spriteRect(RenderPipeline type, Rectangle rectangle, class_1058 sprite) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderPipeline type, Rectangle rectangle, class_1058 sprite, int argb) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderPipeline type, Rectangle rectangle, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, red, green, blue, alpha);
    }

    public void spriteRect(RenderPipeline type, double x, double y, double width, double height, class_1058 sprite) {
        this.spriteRect(type, x, y, width, height, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderPipeline type, double x, double y, double width, double height, class_1058 sprite, int argb) {
        this.spriteRect(type, x, y, width, height, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderPipeline type, double x, double y, double width, double height, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.sprite(type, x, y, x + width, y + height, sprite, red, green, blue, alpha);
    }

    public void sprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void sprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int argb) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void sprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.wrapped.method_25295(type, sprite.method_45852(), (int)xMin, (int)xMax, (int)yMin, (int)yMax, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public void partialSpriteTex(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, double texXMin, double texYMin, double texXMax, double texYMax, int argb) {
        this.partialSpriteTex(type, xMin, yMin, xMax, yMax, sprite, texXMin, texYMin, texXMax, texYMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSpriteTex(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, double texXMin, double texYMin, double texXMax, double texYMax, float red, float green, float blue, float alpha) {
        int width = sprite.method_45851().method_45807();
        int height = sprite.method_45851().method_45815();
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, (float)texXMin / (float)width, (float)texYMin / (float)height, (float)texXMax / (float)width, (float)texYMax / (float)height, red, green, blue, alpha);
    }

    public void partialSprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float uMin, float vMin, float uMax, float vMax, int argb) {
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, uMin, vMin, uMax, vMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float uMin, float vMin, float uMax, float vMax, float red, float green, float blue, float alpha) {
        float u0 = sprite.method_4594();
        float v0 = sprite.method_4593();
        float u1 = sprite.method_4577();
        float v1 = sprite.method_4575();
        float ul = u1 - u0;
        float vl = v1 - v0;
        this.wrapped.method_25295(type, sprite.method_45852(), (int)xMin, (int)xMax, (int)yMin, (int)yMax, u0 + uMin * ul, u0 + uMax * ul, v0 + vMin * vl, v0 + vMax * vl, class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public void tileSprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.method_45851().method_45807(), sprite.method_45851().method_45815(), argb);
    }

    public void tileSprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int textureWidth, int textureHeight, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, textureWidth, textureHeight, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tileSprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.method_45851().method_45807(), sprite.method_45851().method_45815(), red, green, blue, alpha);
    }

    public void tileSprite(RenderPipeline type, double xMin, double yMin, double xMax, double yMax, class_1058 sprite, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        double width = xMax - xMin;
        double height = yMax - yMin;
        if (width <= (double)textureWidth && height <= (double)textureHeight) {
            this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, 0.0f, 0.0f, (float)width / (float)textureWidth, (float)height / (float)textureHeight, red, green, blue, alpha);
        } else {
            double xPos = xMin;
            do {
                double sectionWidth = Math.min((double)textureWidth, xMax - xPos);
                double uWidth = sectionWidth / (double)textureWidth;
                double yPos = yMin;
                do {
                    double sectionHeight = Math.min((double)textureHeight, yMax - yPos);
                    double vWidth = sectionHeight / (double)textureHeight;
                    this.partialSprite(type, xPos, yPos, xPos + sectionWidth, yPos + sectionHeight, sprite, 0.0f, 0.0f, (float)uWidth, (float)vWidth, red, green, blue, alpha);
                } while ((yPos += (double)textureHeight) < yMax);
            } while ((xPos += (double)textureWidth) < xMax);
        }
    }

    public void texRect(Material material, Rectangle rectangle) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, Rectangle rectangle, int argb) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, Rectangle rectangle, float red, float green, float blue, float alpha) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), red, green, blue, alpha);
    }

    public void texRect(Material material, double x, double y, double width, double height) {
        this.texRect(material, x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, double x, double y, double width, double height, int argb) {
        this.texRect(material, x, y, width, height, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, double x, double y, double width, double height, float red, float green, float blue, float alpha) {
        this.tex(material, x, y, x + width, y + height, red, green, blue, alpha);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax) {
        this.tex(material, xMin, yMin, xMax, yMax, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int argb) {
        this.tex(material, xMin, yMin, xMax, yMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, float red, float green, float blue, float alpha) {
        class_1058 sprite = material.sprite();
        this.sprite(GuiRender.guiTexPipe(), xMin, yMin, xMax, yMax, sprite, red, green, blue, alpha);
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right(), argb);
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder, argb);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right());
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        this.dynamicTexInternal(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, red, green, blue, alpha);
    }

    private void dynamicTexInternal(Material material, int xPos, int yPos, int xSize, int ySize, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        class_1058 sprite = material.sprite();
        class_7764 contents = sprite.method_45851();
        int texWidth = contents.method_45807();
        int texHeight = contents.method_45815();
        int trimWidth = texWidth - leftBorder - rightBorder;
        int trimHeight = texHeight - topBorder - bottomBorder;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightBorder);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = 0;
            if (x != 0) {
                trimU = x + leftBorder + trimWidth <= xSize ? leftBorder : texWidth - (xSize - x);
            }
            this.dynamicPart(sprite, xPos + x, yPos, trimU, 0.0f, rWidth, topBorder, red, green, blue, alpha);
            this.dynamicPart(sprite, xPos + x, yPos + ySize - bottomBorder, trimU, texHeight - bottomBorder, rWidth, bottomBorder, red, green, blue, alpha);
            rWidth = Math.min(xSize - x - leftBorder - rightBorder, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int rHeight = Math.min(ySize - y - topBorder - bottomBorder, trimHeight);
                int trimV = y + (texHeight - topBorder - bottomBorder) <= ySize ? topBorder : texHeight - (ySize - y);
                if (x == 0 && y + topBorder < ySize - bottomBorder) {
                    this.dynamicPart(sprite, xPos, yPos + y + topBorder, 0.0f, trimV, leftBorder, rHeight, red, green, blue, alpha);
                    this.dynamicPart(sprite, xPos + xSize - rightBorder, yPos + y + topBorder, trimU + texWidth - rightBorder, trimV, rightBorder, rHeight, red, green, blue, alpha);
                }
                if (y + topBorder >= ySize - bottomBorder || x + leftBorder >= xSize - rightBorder) continue;
                this.dynamicPart(sprite, xPos + x + leftBorder, yPos + y + topBorder, leftBorder, topBorder, rWidth, rHeight, red, green, blue, alpha);
            }
        }
    }

    private void dynamicPart(class_1058 tex, int x, int y, float textureX, float textureY, int width, int height, float red, float green, float blue, float alpha) {
        int w = tex.method_45851().method_45807();
        int h = tex.method_45851().method_45815();
        this.wrapped.method_25295(GuiRender.guiTexPipe(), tex.method_45852(), x, x + width, y, y + height, tex.method_4580(textureX / (float)w), tex.method_4580((textureX + (float)width) / (float)w), tex.method_4570(textureY / (float)h), tex.method_4570((textureY + (float)height) / (float)h), class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public int drawString(@Nullable String message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(@Nullable String message, double x, double y, int colour, boolean shadow) {
        if (message == null) {
            return 0;
        }
        class_5250 component = class_2561.method_43470((String)message);
        this.wrapped.method_51439(this.font(), (class_2561)component, (int)x, (int)y, colour, shadow);
        return (int)x + this.font().method_27525((class_5348)component);
    }

    public int drawString(class_5481 message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(class_5481 message, double x, double y, int colour, boolean shadow) {
        this.wrapped.method_51430(this.font(), message, (int)x, (int)y, colour, shadow);
        return (int)x + this.font().method_30880(message);
    }

    public int drawString(class_2561 message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(class_2561 message, double x, double y, int colour, boolean shadow) {
        return this.drawString(message.method_30937(), x, y, colour, shadow);
    }

    public void drawWordWrap(class_5348 message, double x, double y, int width, int colour) {
        this.drawWordWrap(message, x, y, width, colour, false);
    }

    public void drawWordWrap(class_5348 message, double x, double y, int width, int colour, boolean shadow) {
        Objects.requireNonNull(this.font());
        this.drawWordWrap(message, x, y, width, colour, shadow, 9.0);
    }

    public void drawWordWrap(class_5348 message, double x, double y, int width, int colour, boolean shadow, double spacing) {
        for (class_5481 formattedcharsequence : this.font().method_1728(message, width)) {
            this.drawString(formattedcharsequence, x, y, colour, shadow);
            y += spacing;
        }
    }

    public void drawCenteredString(String message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(String message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().method_1727(message) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(class_2561 message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(class_2561 message, double x, double y, int colour, boolean shadow) {
        class_5481 formattedcharsequence = message.method_30937();
        this.drawString(formattedcharsequence, x - (double)this.font().method_30880(formattedcharsequence) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(class_5481 message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(class_5481 message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().method_30880(message) / 2.0, y, colour, shadow);
    }

    public void drawScrollingString(class_2561 component, double x, double y, double xMax, int colour, boolean shadow) {
        this.drawScrollingString(component, x, y, xMax, colour, shadow, true);
    }

    public void drawScrollingString(class_2561 component, double x, double y, double xMax, int colour, boolean shadow, boolean doScissor) {
        double width;
        int textWidth = this.font().method_27525((class_5348)component);
        if ((double)textWidth > (width = xMax - x)) {
            double outside = (double)textWidth - width;
            double anim = (double)class_156.method_658() / 1000.0;
            double e = Math.max(outside * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * anim / e)) / 2.0 + 0.5;
            double offset = class_3532.method_16436((double)f, (double)0.0, (double)outside);
            if (doScissor) {
                Objects.requireNonNull(this.font());
                this.pushScissor(x, y - 1.0, xMax, y + 9.0 + 1.0);
            }
            this.drawString(component, x - offset, y, colour, shadow);
            if (doScissor) {
                this.popScissor();
            }
        } else {
            this.drawCenteredString(component, (x + xMax) / 2.0, y, colour, shadow);
        }
    }

    public void renderTooltip(class_1799 stack, double mouseX, double mouseY) {
        this.renderTooltip(stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(class_1799 stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        this.toolTipWithImage(class_437.method_25408((class_310)this.mc(), (class_1799)stack), stack.method_32347(), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = class_1799.field_8037;
    }

    public void toolTipWithImage(List<class_2561> tooltips, Optional<class_5632> tooltipImage, class_1799 stack, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltips, tooltipImage, stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<class_2561> tooltips, Optional<class_5632> tooltipImage, class_1799 stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        this.toolTipWithImage(tooltips, tooltipImage, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = class_1799.field_8037;
    }

    public void toolTipWithImage(List<class_2561> tooltip, Optional<class_5632> tooltipImage, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltip, tooltipImage, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<class_2561> tooltip, Optional<class_5632> tooltipImage, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<class_5684> list = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltip, tooltipImage, (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(list, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
    }

    public void renderTooltip(class_2561 message, double mouseX, double mouseY) {
        this.renderTooltip(message, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(class_2561 message, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<class_5684> list = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, List.of(message), Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(list, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
    }

    public void componentTooltip(List<class_2561> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<class_5684> components = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
    }

    public void componentTooltip(List<? extends class_5348> tooltips, double mouseX, double mouseY, class_1799 stack) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847, stack);
    }

    public void componentTooltip(List<? extends class_5348> tooltips, double mouseX, double mouseY) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847, class_1799.field_8037);
    }

    public void componentTooltip(List<? extends class_5348> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom, class_1799 stack) {
        this.tooltipStack = stack;
        List<class_5684> components = PolyLibClient.postGatherTooltipComponents(stack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
        this.tooltipStack = class_1799.field_8037;
    }

    public void renderTooltip(List<? extends class_5481> tooltips, double mouseX, double mouseY) {
        this.renderTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(List<? extends class_5481> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltipInternal(tooltips.stream().map(class_5684::method_32662).collect(Collectors.toList()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, class_8001.field_41687);
    }

    public void renderTooltip(List<class_5481> tooltips, class_8000 positioner, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltipInternal(tooltips.stream().map(class_5684::method_32662).collect(Collectors.toList()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, positioner);
    }

    private void renderTooltipInternal(List<class_5684> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom, class_8000 positioner) {
        if (!tooltips.isEmpty()) {
            class_5684 component;
            int i;
            PolyLibClient.ToolTipResult event = PolyLibClient.postRenderTooltipPre(this.tooltipStack, this.wrapped, (int)mouseX, (int)mouseY, this.guiWidth(), this.guiHeight(), tooltips, this.font(), positioner);
            if (event.canceled()) {
                return;
            }
            int width = 0;
            int height = tooltips.size() == 1 ? -2 : 0;
            for (class_5684 line : tooltips) {
                width = Math.max(width, line.method_32664(event.getFont()));
                height += line.method_32661(this.font());
            }
            Vector2ic position = positioner.method_47944(this.guiWidth(), this.guiHeight(), event.getX(), event.getY(), width, height);
            int xPos = position.x();
            int yPos = Math.max(position.y(), 3);
            this.wrapped.method_51448().pushMatrix();
            PolyLibClient.ToolTipColour colour = PolyLibClient.postTooltipColour(this.tooltipStack, this.wrapped, xPos, yPos, backgroundTop, backgroundBottom, borderTop, borderBottom, event.getFont(), tooltips);
            this.toolTipBackground(xPos - 3, yPos - 3, width + 6, height + 6, colour.getBackgroundStart(), colour.getBackgroundEnd(), colour.getBorderStart(), colour.getBorderEnd(), true);
            int linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.method_32665(this.wrapped, event.getFont(), xPos, linePos);
                linePos += component.method_32661(this.font()) + (i == 0 ? 2 : 0);
            }
            linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.method_32666(event.getFont(), xPos, linePos, width, height, this.wrapped);
                linePos += component.method_32661(this.font()) + (i == 0 ? 2 : 0);
            }
            this.wrapped.method_51448().popMatrix();
        }
    }

    public void renderComponentHoverEffect(@Nullable class_2583 style, int mouseX, int mouseY) {
        block7: {
            if (style == null || style.method_10969() == null) {
                return;
            }
            class_2568 event = style.method_10969();
            if (event instanceof class_2568.class_10612) {
                class_1799 class_17992;
                class_2568.class_10612 class_106122 = (class_2568.class_10612)event;
                class_1799 item = class_17992 = class_106122.comp_3509();
                this.renderTooltip(item, (double)mouseX, (double)mouseY);
            }
            if (event instanceof class_2568.class_10611) {
                class_2568.class_5248 class_52482;
                class_2568.class_10611 class_106112 = (class_2568.class_10611)event;
                class_2568.class_5248 entity = class_52482 = class_106112.comp_3508();
                this.componentTooltip(entity.method_27682(), mouseX, mouseY);
            }
            if (!(event instanceof class_2568.class_10613)) break block7;
            class_2568.class_10613 class_106132 = (class_2568.class_10613)event;
            try {
                class_2561 class_25612;
                class_2561 value = class_25612 = class_106132.comp_3510();
                this.renderTooltip(this.font().method_1728((class_5348)value, Math.max(this.guiWidth() / 2, 200)), (double)mouseX, (double)mouseY);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    public void renderItem(class_1799 stack, double x, double y) {
        this.renderItem(stack, x, y, 16.0);
    }

    public void renderItem(class_1799 stack, double x, double y, double size) {
        this.renderItem((class_1309)this.mc().field_1724, (class_1937)this.mc().field_1687, stack, x, y, size, 0);
    }

    public void renderItem(class_1799 stack, double x, double y, double size, int modelRand) {
        this.renderItem((class_1309)this.mc().field_1724, (class_1937)this.mc().field_1687, stack, x, y, size, modelRand);
    }

    public void renderFakeItem(class_1799 stack, double x, double y) {
        this.renderFakeItem(stack, x, y, 16.0);
    }

    public void renderFakeItem(class_1799 stack, double x, double y, double size) {
        this.renderItem(null, (class_1937)this.mc().field_1687, stack, x, y, size, 0);
    }

    public void renderItem(class_1309 entity, class_1799 stack, double x, double y, int modelRand) {
        this.renderItem(entity, stack, x, y, 16.0, modelRand);
    }

    public void renderItem(class_1309 entity, class_1799 stack, double x, double y, double size, int modelRand) {
        this.renderItem(entity, entity.method_37908(), stack, x, y, size, modelRand);
    }

    public void renderItem(@Nullable class_1309 entity, @Nullable class_1937 level, class_1799 stack, double x, double y, double size, int modelRand) {
        if (stack.method_7960()) {
            return;
        }
        this.wrapped.method_51448().pushMatrix();
        this.wrapped.method_51448().translate((float)x, (float)y);
        this.wrapped.method_51448().scale((float)size / 16.0f, (float)size / 16.0f);
        this.wrapped.method_51423(entity, stack, 0, 0, modelRand);
        this.wrapped.method_51448().popMatrix();
    }

    public void renderItemDecorations(class_1799 stack, double x, double y) {
        this.renderItemDecorations(stack, x, y, 16.0);
    }

    public void renderItemDecorations(class_1799 stack, double x, double y, double size) {
        this.renderItemDecorations(stack, x, y, size, null);
    }

    public void renderItemDecorations(class_1799 stack, double x, double y, @Nullable String text) {
        this.renderItemDecorations(stack, x, y, 16.0, text);
    }

    public void renderItemDecorations(class_1799 stack, double x, double y, double size, @Nullable String text) {
        if (stack.method_7960()) {
            return;
        }
        this.wrapped.method_51448().pushMatrix();
        this.wrapped.method_51448().translate((float)x, (float)y);
        this.wrapped.method_51448().scale((float)size / 16.0f, (float)size / 16.0f);
        this.wrapped.method_51432(this.font(), stack, 0, 0, text);
        this.wrapped.method_51448().popMatrix();
    }

    public void pushScissorRect(Rectangle rectangle) {
        this.pushScissorRect(rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height());
    }

    public void pushScissorRect(double x, double y, double width, double height) {
        this.wrapped.method_44379((int)x, (int)y, (int)(x + width), (int)(y + height));
    }

    public void pushScissor(double xMin, double yMin, double xMax, double yMax) {
        this.wrapped.method_44379((int)xMin, (int)yMin, (int)xMax, (int)yMax);
    }

    public void popScissor() {
        this.wrapped.method_44380();
    }

    public Matrix3x2f translate(double x, double y) {
        return this.wrapped.method_51448().translate((float)x, (float)y);
    }

    public static boolean isInRect(double minX, double minY, double width, double height, double testX, double testY) {
        return testX >= minX && testX < minX + width && testY >= minY && testY < minY + height;
    }

    public static boolean isInRect(int minX, int minY, int width, int height, double testX, double testY) {
        return testX >= (double)minX && testX < (double)(minX + width) && testY >= (double)minY && testY < (double)(minY + height);
    }

    public static int mixColours(int colour1, int colour2) {
        return GuiRender.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = class_3532.method_15340((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = class_3532.method_15340((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = class_3532.method_15340((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = class_3532.method_15340((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int midColour(int colour1, int colour2) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        return (alpha2 + (alpha1 - alpha2) / 2 & 0xFF) << 24 | (red2 + (red1 - red2) / 2 & 0xFF) << 16 | (green2 + (green1 - green2) / 2 & 0xFF) << 8 | blue2 + (blue1 - blue2) / 2 & 0xFF;
    }

    private static float r(int argb) {
        return (float)class_9848.method_61327((int)argb) / 255.0f;
    }

    private static float g(int argb) {
        return (float)class_9848.method_61329((int)argb) / 255.0f;
    }

    private static float b(int argb) {
        return (float)class_9848.method_61331((int)argb) / 255.0f;
    }

    private static float a(int argb) {
        return (float)class_9848.method_61320((int)argb) / 255.0f;
    }

    public static RenderPipeline guiSolidPipe() {
        return class_10799.field_56879;
    }

    public static RenderPipeline guiTexPipe() {
        return class_10799.field_56883;
    }

    public static class_1921 texColType(class_2960 location) {
        return GUI_TEXTURED.apply(location);
    }

    private static class_1921.class_4687 create(String string, int i, RenderPipeline renderPipeline, class_1921.class_4688 arg) {
        return GuiRender.create(string, i, false, false, renderPipeline, arg);
    }

    private static class_1921.class_4687 create(String string, int i, boolean bl, boolean bl2, RenderPipeline renderPipeline, class_1921.class_4688 arg) {
        return new class_1921.class_4687(string, i, bl, bl2, renderPipeline, arg);
    }
}

