/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.inventory.power;

import net.creeperhost.polylib.fabric.inventory.power.PolyFabricEnergyWrapper;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public class PolyFabricEnergyItemWrapper
extends PolyFabricEnergyWrapper {
    private final IPolyEnergyStorageItem storage;
    private final ContainerItemContext itemContext;

    public PolyFabricEnergyItemWrapper(IPolyEnergyStorageItem storage, ContainerItemContext itemContext) {
        super(storage);
        this.storage = storage;
        this.itemContext = itemContext;
    }

    @Override
    public long insert(long maxAmount, TransactionContext transaction) {
        long insertedAmount = this.storage.receiveEnergy(maxAmount, true);
        if (insertedAmount > 0L) {
            this.updateSnapshots(transaction);
            long last = this.storage.getEnergyStored();
            long transferred = this.storage.receiveEnergy(maxAmount, false);
            if (this.tryUpdateItem(this.storage.getContainer(), transaction)) {
                return transferred;
            }
            this.storage.modifyEnergyStored(last - this.storage.getEnergyStored());
        }
        return 0L;
    }

    @Override
    public long extract(long maxAmount, TransactionContext transaction) {
        long extractedAmount = this.storage.extractEnergy(maxAmount, true);
        if (extractedAmount > 0L) {
            this.updateSnapshots(transaction);
            long last = this.storage.getEnergyStored();
            long transferred = this.storage.extractEnergy(maxAmount, false);
            if (this.tryUpdateItem(this.storage.getContainer(), transaction)) {
                return transferred;
            }
            this.storage.modifyEnergyStored(last - this.storage.getEnergyStored());
        }
        return 0L;
    }

    private boolean tryUpdateItem(class_1799 newStack, TransactionContext transaction) {
        ItemVariant newVariant = ItemVariant.of((class_1799)newStack);
        long count = this.itemContext.getAmount();
        try (Transaction nested = transaction.openNested();){
            if (this.itemContext.extract(this.itemContext.getItemVariant(), count, (TransactionContext)nested) == count && this.itemContext.insert(newVariant, (long)newStack.method_7947(), (TransactionContext)nested) == (long)newStack.method_7947()) {
                nested.commit();
                boolean bl = true;
                return bl;
            }
        }
        return true;
    }

    @Override
    public boolean supportsInsertion() {
        return this.storage.canReceive();
    }

    @Override
    public boolean supportsExtraction() {
        return this.storage.canExtract();
    }

    @Override
    public long getAmount() {
        return this.storage.getEnergyStored();
    }

    @Override
    public long getCapacity() {
        return this.storage.getMaxEnergyStored();
    }
}

