/*
 * Decompiled with CFR 0.152.
 */
package gaia.capability.friended;

import gaia.capability.CapabilityHandler;
import gaia.capability.friended.IFriended;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FriendedCapability
implements IFriended,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    private boolean friended = false;
    private UUID friendedBy = null;
    private boolean changed = false;

    @Override
    public boolean isFriendly() {
        return this.friended;
    }

    @Override
    public UUID getFriendedBy() {
        return this.friendedBy;
    }

    @Override
    public void setFriendedBy(UUID friendedBy) {
        this.friendedBy = friendedBy;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setFriendly(boolean value) {
        this.friended = value;
        this.setChanged(true);
    }

    @Override
    public void setChanged(boolean value) {
        this.changed = value;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("friended", this.isFriendly());
        if (this.getFriendedBy() != null) {
            tag.m_128362_("friendedBy", this.getFriendedBy());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setFriendly(tag.m_128471_("friended"));
        if (tag.m_128441_("friendedBy")) {
            this.setFriendedBy(tag.m_128342_("friendedBy"));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.CAPABILITY_FRIENDED.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public final Capability<IFriended> getCapability() {
        return CapabilityHandler.CAPABILITY_FRIENDED;
    }
}

