/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Centaur;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.phys.Vec3;

public class CentaurModel
extends EntityModel<Centaur>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart tail;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart leftlegupper;
    private final ModelPart rightlegupper;
    private final ModelPart leftlegback1;
    private final ModelPart rightlegback1;
    private final ModelPart leftlegback2;
    private final ModelPart rightlegback2;
    private final ModelPart leftlegback3;
    private final ModelPart rightlegback3;

    public CentaurModel(ModelPart root) {
        this.root = root.m_171324_("centaur");
        ModelPart bodybottom = this.root.m_171324_("bodybottom");
        this.bodytop = bodybottom.m_171324_("bodymiddle").m_171324_("bodytop");
        ModelPart neck = this.bodytop.m_171324_("neck");
        this.head = neck.m_171324_("head");
        this.headeyes = this.head.m_171324_("headeyes");
        this.chest = this.bodytop.m_171324_("chest");
        this.leftarm = this.bodytop.m_171324_("leftarm");
        this.rightarm = this.bodytop.m_171324_("rightarm");
        this.body1 = this.root.m_171324_("body1");
        this.leftlegupper = this.body1.m_171324_("leftlegupper");
        this.rightlegupper = this.body1.m_171324_("rightlegupper");
        this.body2 = this.body1.m_171324_("body2");
        this.tail = this.body2.m_171324_("tail");
        this.leftlegback1 = this.body2.m_171324_("leftlegback1");
        this.rightlegback1 = this.body2.m_171324_("rightlegback1");
        this.leftlegback2 = this.leftlegback1.m_171324_("leftlegback2");
        this.rightlegback2 = this.rightlegback1.m_171324_("rightlegback2");
        this.leftlegback3 = this.leftlegback2.m_171324_("leftlegback3");
        this.rightlegback3 = this.rightlegback2.m_171324_("rightlegback3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition centaur = partdefinition.m_171599_("centaur", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = centaur.m_171599_("bodybottom", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-18.5f, (float)-6.0f));
        PartDefinition waist = bodybottom.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-3.5f, 0.0f, -2.0f, 7.0f, 8.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)-1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.m_171599_("bodymiddle", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition bonemiddleFemale = bodymiddle.m_171599_("bonemiddleFemale", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, -0.5f, -2.5f, 4.0f, 3.0f, 2.0f).m_171514_(0, 25).m_171481_(-0.5f, 0.0f, -2.6f, 1.0f, 2.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        PartDefinition bodymidMale = bodymiddle.m_171599_("bodymidMale", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171481_(-2.5f, -2.5f, -1.5f, 5.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.m_171599_("bodytop", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).m_171514_(36, 0).m_171481_(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.m_171599_("headeyes", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.m_171599_("rightear", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 4.0f), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition leftear = head.m_171599_("leftear", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-3.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition hair1 = neck.m_171599_("hair1", CubeListBuilder.m_171558_().m_171514_(36, 14).m_171481_(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hair2 = hair1.m_171599_("hair2", CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(-4.5f, 0.0f, -2.5f, 9.0f, 9.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)4.0f));
        PartDefinition chest = bodytop.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171481_(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171514_(0, 36).m_171481_(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bonetopFemale = bodytop.m_171599_("bonetopFemale", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.5f, -6.0f, -3.0f, 5.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition bodytopmale = bodytop.m_171599_("bodytopmale", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition rightarm = bodytop.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171481_(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-2.5f, (float)-5.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition rightpauldron = rightarm.m_171599_("rightpauldron", CubeListBuilder.m_171558_().m_171514_(36, 41).m_171481_(-2.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bodytop.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)2.5f, (float)-5.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171481_(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftpauldron = leftarm.m_171599_("leftpauldron", CubeListBuilder.m_171558_().m_171514_(36, 41).m_171481_(-0.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body1 = centaur.m_171599_("body1", CubeListBuilder.m_171558_().m_171514_(64, 11).m_171481_(-4.0f, -1.0f, -1.0f, 8.0f, 9.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)-18.5f, (float)-8.5f));
        PartDefinition body2 = body1.m_171599_("body2", CubeListBuilder.m_171558_().m_171514_(64, 29).m_171481_(-3.5f, -0.5f, -2.0f, 7.0f, 8.0f, 12.0f), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)8.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body2.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(106, 51).m_171481_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)9.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegback1 = body2.m_171599_("rightlegback1", CubeListBuilder.m_171558_().m_171514_(106, 26).m_171481_(-1.0f, -2.5f, -2.5f, 3.0f, 8.0f, 6.0f), PartPose.m_171423_((float)-3.5f, (float)3.5f, (float)7.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegback2 = rightlegback1.m_171599_("rightlegback2", CubeListBuilder.m_171558_().m_171514_(106, 40).m_171481_(-1.505f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.m_171423_((float)0.5f, (float)5.5f, (float)-2.5f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegback3 = rightlegback2.m_171599_("rightlegback3", CubeListBuilder.m_171558_().m_171514_(106, 49).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegback1 = body2.m_171599_("leftlegback1", CubeListBuilder.m_171558_().m_171514_(106, 26).m_171481_(-2.0f, -2.5f, -2.5f, 3.0f, 8.0f, 6.0f), PartPose.m_171423_((float)3.5f, (float)3.5f, (float)7.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegback2 = leftlegback1.m_171599_("leftlegback2", CubeListBuilder.m_171558_().m_171514_(106, 40).m_171481_(-1.395f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.m_171423_((float)-0.6f, (float)5.5f, (float)-2.5f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegback3 = leftlegback2.m_171599_("leftlegback3", CubeListBuilder.m_171558_().m_171514_(106, 49).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171423_((float)0.1f, (float)6.0f, (float)3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegupper = body1.m_171599_("rightlegupper", CubeListBuilder.m_171558_().m_171514_(106, 0).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.m_171423_((float)-4.0f, (float)4.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightleglower = rightlegupper.m_171599_("rightleglower", CubeListBuilder.m_171558_().m_171514_(106, 16).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)6.5f, (float)-1.5f));
        PartDefinition rightlegbracelet = rightleglower.m_171599_("rightlegbracelet", CubeListBuilder.m_171558_().m_171514_(106, 11).m_171481_(-1.5f, 0.0f, -3.0f, 3.0f, 2.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)2.5f));
        PartDefinition leftlegupper = body1.m_171599_("leftlegupper", CubeListBuilder.m_171558_().m_171514_(106, 0).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.m_171423_((float)4.0f, (float)4.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition leftleglower = leftlegupper.m_171599_("leftleglower", CubeListBuilder.m_171558_().m_171514_(106, 16).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)6.5f, (float)-1.5f));
        PartDefinition leftlegbracelet = leftleglower.m_171599_("leftlegbracelet", CubeListBuilder.m_171558_().m_171514_(106, 11).m_171481_(-1.5f, 0.0f, -3.0f, 3.0f, 2.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)2.6f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Centaur centaur, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)centaur, limbSwing, limbSwingAmount, partialTick);
        this.chest.f_104207_ = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !centaur.m_6162_();
    }

    public void setupAnim(Centaur centaur, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.f_104207_ = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        if (centaur.isMale()) {
            this.rightarm.f_104200_ = -3.0f;
            this.leftarm.f_104200_ = 3.0f;
        }
        this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount * 0.5f;
        this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount * 0.5f;
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104205_ = 0.0f;
        if (centaur.m_5912_() && centaur.m_21205_().m_41720_() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.f_102608_ > 0.0f) {
            this.holdingMelee();
        }
        if (centaur.isFleeing()) {
            Vec3 movement = centaur.m_20184_();
            if (movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_ > 2.500000277905201E-7) {
                this.animationFlee();
            }
        }
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.body1.f_104203_ = -0.08726646f;
        this.body2.f_104203_ = 0.17453292f;
        this.tail.f_104204_ = Mth.m_14089_((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.17453292f;
        this.tail.f_104203_ = -0.7853982f;
        this.rightlegupper.f_104205_ = -0.08726646f;
        this.rightlegupper.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.7862f)) * 0.8f * limbSwingAmount;
        this.leftlegupper.f_104205_ = 0.08726646f;
        this.leftlegupper.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightlegback1.f_104205_ = -0.08726646f;
        this.rightlegback1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.7662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightlegback1.f_104203_ -= 0.296706f;
        this.leftlegback1.f_104205_ = 0.08726646f;
        this.leftlegback1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leftlegback1.f_104203_ -= 0.296706f;
        this.leftlegback2.f_104203_ = this.rightlegback2.f_104203_ = 0.5235988f;
        this.leftlegback3.f_104203_ = this.rightlegback3.f_104203_ = -0.31415927f;
        if (this.f_102609_) {
            this.body1.f_104203_ = -0.34906584f;
            this.body2.f_104203_ = -0.7853982f;
            this.tail.f_104203_ = 1.134464f;
            this.rightlegback1.f_104205_ = 0.43633232f;
            this.leftlegback1.f_104205_ = -this.rightlegback1.f_104205_;
            this.leftlegupper.f_104203_ = this.rightlegupper.f_104203_ = -0.43633232f;
            this.leftlegback1.f_104203_ = this.rightlegback1.f_104203_ = -0.34906584f;
        }
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
        float f1 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104205_ = 0.0f;
        this.rightarm.f_104204_ = -(0.1f - f * 0.6f);
        this.leftarm.f_104204_ = 0.1f - f * 0.6f;
        this.rightarm.f_104203_ = -1.5707964f;
        this.leftarm.f_104203_ = -1.5707964f;
        this.rightarm.f_104203_ -= f * 1.2f - f1 * 0.4f;
        this.leftarm.f_104203_ -= f * 1.2f - f1 * 0.4f;
        AnimationUtils.m_102082_((ModelPart)this.rightarm, (ModelPart)this.leftarm, (float)ageInTicks);
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.bodytop.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    private void animationFlee() {
        this.leftarm.f_104203_ += 1.0472f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(-0.0625, 0.0, -0.375);
        this.getArm(arm).m_104299_(poseStack);
    }
}

