/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.GelatinousSlime;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class GelatinousSlimeModel
extends EntityModel<GelatinousSlime>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodyupper;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart bodylower;
    private final ModelPart leftleg;

    public GelatinousSlimeModel(ModelPart root) {
        this.root = root.m_171324_("gelatinous_slime");
        this.bodyupper = this.root.m_171324_("bodyupper");
        this.head = this.bodyupper.m_171324_("head");
        this.rightarm = this.bodyupper.m_171324_("rightarm");
        this.leftarm = this.root.m_171324_("invisiblearm");
        this.bodylower = this.bodyupper.m_171324_("bodylower");
        this.leftleg = this.root.m_171324_("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition gelatinous_slime = partdefinition.m_171599_("gelatinous_slime", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodyupper = gelatinous_slime.m_171599_("bodyupper", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-6.0f, (float)-21.0f, (float)-4.0f, (float)0.6109f, (float)-0.3491f, (float)0.0f));
        bodyupper.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -7.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.4363f, (float)0.4363f, (float)0.0f));
        bodyupper.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171481_(-2.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171423_((float)-4.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition leftarm = bodyupper.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)4.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(40, 22).m_171481_(-2.0f, 0.0f, -1.005f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)2.3562f));
        PartDefinition bodylower = bodyupper.m_171599_("bodylower", CubeListBuilder.m_171558_().m_171514_(16, 28).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        bodylower.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)4.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)-0.5236f));
        gelatinous_slime.m_171599_("invisiblearm", CubeListBuilder.m_171558_().m_171514_(0, 114).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)-20.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leftleg = gelatinous_slime.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)4.0f, (float)-12.0f, (float)0.0f, (float)-0.7854f, (float)-0.4363f, (float)0.5236f));
        leftleg.m_171599_("leftleglower", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-1.095f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.1f, (float)6.0f, (float)-1.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition mainbody1 = gelatinous_slime.m_171599_("mainbody1", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).m_171514_(64, 0).m_171481_(-18.0f, -11.0f, 4.0f, 2.0f, 2.0f, 2.0f).m_171514_(64, 4).m_171481_(16.0f, -3.0f, -6.0f, 3.0f, 3.0f, 3.0f).m_171514_(64, 4).m_171481_(-19.0f, -8.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        mainbody1.m_171599_("mainbody2", CubeListBuilder.m_171558_().m_171514_(64, 64).m_171481_(-12.0f, -12.0f, -12.0f, 24.0f, 24.0f, 24.0f).m_171514_(160, 64).m_171481_(-12.0f, -12.0f, -12.0f, 24.0f, 24.0f, 24.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.m_171599_("slimesoutheast", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171481_(14.0f, 12.0f, -18.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.m_171599_("slimenortheast", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171481_(14.0f, 12.0f, 14.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.m_171599_("slimenorthwest", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171481_(-18.0f, 12.0f, 14.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.m_171599_("slimesouthwest", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171481_(-18.0f, 12.0f, -18.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void setupAnim(GelatinousSlime entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float floatSpeed = 0.2f;
        float floatRange = 0.2f;
        this.root.f_104201_ = 24.0f - Mth.m_14089_((float)((ageInTicks + 1.5f) * floatSpeed)) * floatRange;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        float rightarmDefaultAngleZ = 1.047198f;
        this.rightarm.f_104205_ = Mth.m_14089_((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.rightarm.f_104205_ += rightarmDefaultAngleZ;
        float bodyupperDefaultAngleX = 0.6108652f;
        this.bodyupper.f_104203_ = Mth.m_14089_((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.bodyupper.f_104203_ += bodyupperDefaultAngleX;
        float bodylowerDefaultAngleX = 1.047198f;
        this.bodylower.f_104203_ = Mth.m_14089_((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.bodylower.f_104203_ += bodylowerDefaultAngleX;
        float leftlegDefaultAngleX = 0.7853982f;
        this.leftleg.f_104203_ = Mth.m_14089_((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.leftleg.f_104203_ -= leftlegDefaultAngleX;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        this.getArm(arm).m_104299_(poseStack);
    }
}

