/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Mermaid;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class MermaidModel
extends EntityModel<Mermaid>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart[] fins = new ModelPart[6];
    private final ModelPart fintail;

    public MermaidModel(ModelPart root) {
        this.root = root.m_171324_("mermaid");
        ModelPart bodybottom = this.root.m_171324_("bodybottom");
        this.bodytop = bodybottom.m_171324_("bodymiddle").m_171324_("bodytop");
        ModelPart neck = this.bodytop.m_171324_("neck");
        this.head = neck.m_171324_("head");
        this.headeyes = this.head.m_171324_("headeyes");
        this.hair1 = neck.m_171324_("hair1");
        this.hair2 = this.hair1.m_171324_("hair2");
        this.chest = this.bodytop.m_171324_("chest");
        this.leftarm = this.bodytop.m_171324_("leftarm");
        this.rightarm = this.bodytop.m_171324_("rightarm");
        for (int i = 0; i < this.fins.length; ++i) {
            int index = i + 1;
            this.fins[i] = index == 1 ? this.root.m_171324_("fin" + index) : this.fins[i - 1].m_171324_("fin" + index);
        }
        this.fintail = this.fins[5].m_171324_("fintail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition mermaid = partdefinition.m_171599_("mermaid", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition bodybottom = mermaid.m_171599_("bodybottom", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f).m_171514_(68, 7).m_171481_(-4.0f, -1.5f, -2.5f, 8.0f, 8.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)-13.5f, (float)0.5f));
        PartDefinition bodymiddle = bodybottom.m_171599_("bodymiddle", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).m_171514_(0, 25).m_171481_(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)1.0f));
        PartDefinition bodytop = bodymiddle.m_171599_("bodytop", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition neck = bodytop.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).m_171514_(36, 0).m_171481_(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f).m_171514_(36, 37).m_171481_(-1.5f, -6.0f, 3.6f, 3.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("finright", CubeListBuilder.m_171558_().m_171514_(36, 36).m_171481_(0.0f, -4.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.m_171423_((float)-3.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        head.m_171599_("finleft", CubeListBuilder.m_171558_().m_171514_(36, 36).m_171481_(0.0f, -4.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.m_171423_((float)3.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        head.m_171599_("headeyes", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("headhelmet", CubeListBuilder.m_171558_().m_171514_(36, 46).m_171481_(-4.0f, -6.0f, -3.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)-1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition hair1 = neck.m_171599_("hair1", CubeListBuilder.m_171558_().m_171514_(36, 14).m_171481_(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        hair1.m_171599_("hair2", CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(-4.5f, -1.0f, 1.5f, 9.0f, 9.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        bodytop.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171481_(-2.6f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171514_(0, 36).m_171480_().m_171481_(0.0f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)0.3f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)-2.5f, (float)-4.5f, (float)-0.5f));
        rightarm.m_171599_("rightpauldron_r1", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171488_(-3.0f, -1.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)2.5f, (float)-4.5f, (float)-0.5f));
        leftarm.m_171599_("leftpauldron_r1", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171480_().m_171488_(-1.0f, -1.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition fin1 = mermaid.m_171599_("fin1", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171481_(-3.5f, -1.0f, -2.0f, 7.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.5f));
        PartDefinition fin2 = fin1.m_171599_("fin2", CubeListBuilder.m_171558_().m_171514_(100, 8).m_171481_(-3.0f, 0.0f, 0.0f, 6.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-2.0f));
        PartDefinition fin3 = fin2.m_171599_("fin3", CubeListBuilder.m_171558_().m_171514_(100, 16).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition fin4 = fin3.m_171599_("fin4", CubeListBuilder.m_171558_().m_171514_(100, 24).m_171481_(-2.0f, 0.0f, 0.5f, 4.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition fin5 = fin4.m_171599_("fin5", CubeListBuilder.m_171558_().m_171514_(100, 31).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition fin6 = fin5.m_171599_("fin6", CubeListBuilder.m_171558_().m_171514_(100, 37).m_171481_(-1.0f, 0.0f, 0.5f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        fin6.m_171599_("fintail", CubeListBuilder.m_171558_().m_171514_(100, 41).m_171481_(-3.5f, -1.0f, 0.0f, 7.0f, 7.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)1.5f));
        fin2.m_171599_("fin2right", CubeListBuilder.m_171558_().m_171514_(120, 5).m_171481_(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 3.0f), PartPose.m_171423_((float)3.0f, (float)2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        fin2.m_171599_("fin2left", CubeListBuilder.m_171558_().m_171514_(120, 5).m_171481_(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 3.0f), PartPose.m_171423_((float)-3.0f, (float)2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Mermaid mermaid, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)mermaid, limbSwing, limbSwingAmount, partialTick);
        this.chest.f_104207_ = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !mermaid.m_6162_();
    }

    public void setupAnim(Mermaid mermaid, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.f_104207_ = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.hair1.f_104204_ = this.head.f_104204_;
        this.hair1.f_104203_ = this.head.f_104203_;
        this.hair2.f_104203_ = this.head.f_104203_ * 0.75f;
        this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104205_ = 0.0f;
        if (this.f_102608_ > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.fins[0].f_104203_ = -0.1308997f;
        this.fins[1].f_104203_ = 0.3926991f;
        this.fins[2].f_104203_ = 0.3926991f;
        this.fins[3].f_104203_ = 0.785398f;
        this.fintail.f_104203_ = 0.3926991f;
        float usedValue = mermaid.m_20069_() ? ageInTicks : limbSwing;
        this.fins[0].f_104205_ = -0.1f * Mth.m_14089_((float)(usedValue * 0.3f));
        this.fins[1].f_104205_ = -0.1f * Mth.m_14089_((float)(usedValue * 0.3f));
        this.fins[2].f_104205_ = -0.1f * Mth.m_14089_((float)(usedValue * 0.3f));
        this.fins[3].f_104205_ = -0.1f * Mth.m_14089_((float)(usedValue * 0.3f));
        this.fins[4].f_104205_ = -0.1f * Mth.m_14089_((float)(usedValue * 0.3f));
        this.fins[5].f_104205_ = -0.1f * Mth.m_14089_((float)(usedValue * 0.3f));
        this.fintail.f_104205_ = -0.2f * Mth.m_14089_((float)(usedValue * 0.3f));
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.bodytop.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(0.0, 0.5, 0.0625);
        this.getArm(arm).m_104299_(poseStack);
    }
}

