/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Orc;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class OrcModel
extends EntityModel<Orc>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public OrcModel(ModelPart root) {
        this.root = root.m_171324_("orc");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leftarm = this.body.m_171324_("leftarm");
        this.rightarm = this.body.m_171324_("rightarm");
        this.leftleg = this.root.m_171324_("leftleg");
        this.rightleg = this.root.m_171324_("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition orc = partdefinition.m_171599_("orc", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = orc.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-5.0f, 0.0f, -2.0f, 10.0f, 14.0f, 4.0f).m_171514_(0, 34).m_171488_(-5.0f, 0.0f, -2.0f, 10.0f, 14.0f, 4.0f, new CubeDeformation(0.5f)).m_171514_(64, 39).m_171481_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-26.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f).m_171514_(64, 0).m_171481_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftear_r1 = head.m_171599_("leftear_r1", CubeListBuilder.m_171558_().m_171514_(64, -5).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 5.0f), PartPose.m_171423_((float)4.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition rightear_r1 = head.m_171599_("rightear_r1", CubeListBuilder.m_171558_().m_171514_(64, -5).m_171481_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 5.0f), PartPose.m_171423_((float)-4.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition headjaw = head.m_171599_("headjaw", CubeListBuilder.m_171558_().m_171514_(64, 18).m_171481_(-4.5f, -0.5f, -4.0f, 9.0f, 3.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-0.5f));
        PartDefinition righthorn = head.m_171599_("righthorn", CubeListBuilder.m_171558_().m_171514_(64, 25).m_171481_(-5.5f, -8.5f, -2.5f, 2.0f, 2.0f, 2.0f).m_171514_(64, 29).m_171481_(-6.5f, -10.5f, -1.5f, 3.0f, 3.0f, 3.0f).m_171514_(64, 35).m_171481_(-4.5f, -11.5f, -2.5f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lefthorn = head.m_171599_("lefthorn", CubeListBuilder.m_171558_().m_171514_(64, 25).m_171481_(3.5f, -8.5f, -2.5f, 2.0f, 2.0f, 2.0f).m_171514_(64, 29).m_171481_(3.5f, -10.5f, -1.5f, 3.0f, 3.0f, 3.0f).m_171514_(64, 35).m_171481_(2.5f, -11.5f, -2.5f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(28, 16).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f).m_171514_(100, 26).m_171481_(-4.5f, -3.5f, -1.5f, 3.0f, 3.0f, 3.0f).m_171514_(100, 10).m_171481_(-3.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f).m_171514_(100, 32).m_171481_(-3.5f, 7.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftarm = body.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(28, 16).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f).m_171555_(false).m_171514_(100, 0).m_171480_().m_171481_(-1.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false).m_171514_(100, 20).m_171480_().m_171481_(1.5f, -3.5f, -1.5f, 3.0f, 3.0f, 3.0f).m_171555_(false).m_171514_(100, 32).m_171480_().m_171481_(-1.5f, 7.5f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightleg = orc.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(44, 16).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171514_(100, 42).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f).m_171514_(100, 52).m_171481_(-2.5f, 7.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftleg = orc.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(44, 16).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171555_(false).m_171514_(100, 42).m_171480_().m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false).m_171514_(100, 52).m_171480_().m_171481_(-2.5f, 7.0f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Orc orc, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        int animationState = orc.getAnimationState();
        if (animationState == 0) {
            this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104205_ = 0.0f;
            if (this.f_102608_ > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        } else if (animationState == 1) {
            this.animationThrow();
        } else if (animationState == 2) {
            this.animationBuff();
        }
        this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightleg.f_104204_ = 0.0f;
        this.leftleg.f_104204_ = 0.0f;
        this.rightleg.f_104205_ = 0.0f;
        this.leftleg.f_104205_ = 0.0f;
        if (this.f_102609_) {
            this.rightarm.f_104203_ -= 0.62831855f;
            this.leftarm.f_104203_ -= 0.62831855f;
            this.rightleg.f_104203_ = -1.4137167f;
            this.rightleg.f_104204_ = 0.31415927f;
            this.rightleg.f_104205_ = 0.07853982f;
            this.leftleg.f_104203_ = -1.4137167f;
            this.leftleg.f_104204_ = -0.31415927f;
            this.leftleg.f_104205_ = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.body.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.rightarm.f_104203_ = -1.0472f;
    }

    private void animationBuff() {
        this.rightarm.f_104203_ = 0.0f;
        this.leftarm.f_104203_ = 0.0f;
        this.rightarm.f_104205_ = 0.785398f;
        this.leftarm.f_104205_ = -0.785398f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).m_104299_(poseStack);
    }
}

