/*
 * Decompiled with CFR 0.152.
 */
package gaia.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GaiaConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue genderNeutral;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.genderNeutral = builder.comment("When enabled makes the mobs look more gender neutral (default: false)").define("genderNeutral", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue disableInvisibility;
        public final ForgeConfigSpec.BooleanValue allPassiveMobsHostile;
        public final ForgeConfigSpec.BooleanValue passiveHostileMobs;
        public final ForgeConfigSpec.BooleanValue friendlyPersistence;
        public final ForgeConfigSpec.IntValue tier1maxHealth;
        public final ForgeConfigSpec.IntValue tier1attackDamage;
        public final ForgeConfigSpec.IntValue tier1baseDefense;
        public final ForgeConfigSpec.IntValue tier2maxHealth;
        public final ForgeConfigSpec.IntValue tier2attackDamage;
        public final ForgeConfigSpec.IntValue tier2baseDefense;
        public final ForgeConfigSpec.IntValue tier3maxHealth;
        public final ForgeConfigSpec.IntValue tier3attackDamage;
        public final ForgeConfigSpec.IntValue tier3baseDefense;
        public final ForgeConfigSpec.BooleanValue baseDamage;
        public final ForgeConfigSpec.BooleanValue shieldsBlockPiercing;
        public final ForgeConfigSpec.BooleanValue baseDamageArchers;
        public final ForgeConfigSpec.BooleanValue spawnDaysPassed;
        public final ForgeConfigSpec.IntValue spawnDaysSet;
        public final ForgeConfigSpec.BooleanValue spawnLevel3Rain;
        public final ForgeConfigSpec.BooleanValue disableYRestriction;
        public final ForgeConfigSpec.BooleanValue spawnWeather;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General Settings").push("General");
            this.disableInvisibility = builder.comment("Disable mobs that use the Invisibility status effect when far from a player [Default: false]").define("disableInvisibility", false);
            this.allPassiveMobsHostile = builder.comment("All mobs are now hostile [Default: false]").define("allPassiveMobsHostile", false);
            this.passiveHostileMobs = builder.comment("Hostile day mobs will no longer attack players on sight [default: false]").define("passiveHostileMobs", false);
            this.friendlyPersistence = builder.comment("Stop befriended mobs from despawning [Default: false]").define("friendlyPersistence", false);
            builder.pop();
            builder.comment("Attribute settings").push("Attributes");
            builder.comment("Tier 1").push("Tier1");
            this.tier1maxHealth = builder.comment("Defines the health of Tier 1 Gaia mobs [40 = 20 Hearts]").defineInRange("tier1maxHealth", 40, 1, Integer.MAX_VALUE);
            this.tier1attackDamage = builder.comment("Defines the attack damage of Tier 1 Gaia mobs [4 = 2 Hearts]").defineInRange("tier1attackDamage", 4, 1, Integer.MAX_VALUE);
            this.tier1baseDefense = builder.comment("Defines the maximum amount of hits required to defeat Tier 1 Gaia mobs (0 = disable)").defineInRange("tier1baseDefense", 2, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Tier 2").push("Tier2");
            this.tier2maxHealth = builder.comment("Defines the health of Tier 2 Gaia mobs [80 = 40 Hearts]").defineInRange("tier2maxHealth", 80, 1, Integer.MAX_VALUE);
            this.tier2attackDamage = builder.comment("Defines the attack damage of Tier 2 Gaia mobs [8 = 4 Hearts]").defineInRange("tier2attackDamage", 8, 1, Integer.MAX_VALUE);
            this.tier2baseDefense = builder.comment("Defines the maximum amount of hits required to defeat Tier 2 Gaia mobs (0 = disable)").defineInRange("tier2baseDefense", 4, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Tier 3").push("Tier3");
            this.tier3maxHealth = builder.comment("Defines the health of Tier 3 Gaia mobs [160 = 80 Hearts]").defineInRange("tier3maxHealth", 160, 1, Integer.MAX_VALUE);
            this.tier3attackDamage = builder.comment("Defines the attack damage of Tier 3 Gaia mobs [12 = 6 Hearts]").defineInRange("tier3attackDamage", 12, 1, Integer.MAX_VALUE);
            this.tier3baseDefense = builder.comment("Defines the maximum amount of hits required to defeat Tier 3 Gaia mobs (0 = disable)").defineInRange("tier3baseDefense", 8, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.comment("Damage settings").push("Damage");
            this.baseDamage = builder.comment("Melee attacks deal an additional 2.0 (1 heart) of damage [Default: true]").define("baseDamage", true);
            this.shieldsBlockPiercing = builder.comment("Archers arrows deal an additional 1 (0.5 heart) of damage. [Default: true]").define("baseDamage", true);
            this.baseDamageArchers = builder.comment("Base Damage (melee) won't penetrate Shields. [Default: true]").define("shieldsBlockPiercing", true);
            builder.pop();
            builder.comment("Spawn settings").push("Spawn");
            this.spawnDaysPassed = builder.comment("Mobs only spawn after a certain amount of days have passed [Default: false]").define("spawnDaysPassed", false);
            this.spawnDaysSet = builder.comment("Amount of days required to have passed before they can start spawning [Default: 3]").defineInRange("spawnDaysSet", 3, 1, Integer.MAX_VALUE);
            this.spawnLevel3Rain = builder.comment("Level 3 mobs only spawn when it is raining/snowing [Default: false]").define("spawnLevel3Rain", false);
            this.disableYRestriction = builder.comment("Remove spawn conditions related to height (Y-axis) [Default: false]").define("disableYRestriction", false);
            this.spawnWeather = builder.comment("Remove spawn conditions related to weather [Default: false]").define("spawnWeather", false);
            builder.pop();
        }
    }
}

