/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen;

import gaia.datagen.client.GaiaBlockModels;
import gaia.datagen.client.GaiaBlockstates;
import gaia.datagen.client.GaiaItemModels;
import gaia.datagen.client.GaiaLanguage;
import gaia.datagen.client.GaiaSoundProvider;
import gaia.datagen.client.compat.GaiaPatchouliProvider;
import gaia.datagen.server.GaiaAdvancementProvider;
import gaia.datagen.server.GaiaBiomeModifiers;
import gaia.datagen.server.GaiaBlockTags;
import gaia.datagen.server.GaiaEntityTags;
import gaia.datagen.server.GaiaItemTags;
import gaia.datagen.server.GaiaLoot;
import gaia.datagen.server.GaiaRecipes;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GaiaDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(GaiaDatagen::getProvider);
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new GaiaAdvancementProvider(packOutput, lookupProvider, helper));
            generator.addProvider(true, (DataProvider)new GaiaRecipes(packOutput));
            generator.addProvider(true, (DataProvider)new GaiaLoot(packOutput));
            GaiaBlockTags blockTagsProvider = new GaiaBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(true, (DataProvider)blockTagsProvider);
            generator.addProvider(true, (DataProvider)new GaiaItemTags(packOutput, lookupProvider, blockTagsProvider, helper));
            generator.addProvider(true, (DataProvider)new GaiaEntityTags(packOutput, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, Set.of("grimoireofgaia")));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new GaiaLanguage(packOutput));
            generator.addProvider(true, (DataProvider)new GaiaSoundProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new GaiaBlockModels(packOutput, helper));
            generator.addProvider(true, (DataProvider)new GaiaItemModels(packOutput, helper));
            generator.addProvider(true, (DataProvider)new GaiaBlockstates(packOutput, helper));
            if (ModList.get().isLoaded("patchouli")) {
                generator.addProvider(true, (DataProvider)new GaiaPatchouliProvider(packOutput));
            }
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_256911_, context -> {});
        registryBuilder.m_254916_(Registries.f_256988_, context -> {});
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, GaiaBiomeModifiers::bootstrap);
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }
}

