/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.server;

import gaia.registry.GaiaRegistry;
import gaia.registry.helper.MobReg;
import gaia.registry.helper.PropReg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import org.jetbrains.annotations.Nullable;

public class GaiaAdvancementProvider
extends ForgeAdvancementProvider {
    public static final Map<EntityType<?>, Advancement> entityTypeAdvancementMap = new HashMap();

    public GaiaAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new GaiaAdvancementGenerator()));
    }

    public static class GaiaAdvancementGenerator
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider provider, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
            Advancement root = Advancement.Builder.m_138353_().m_138358_(GaiaAdvancementGenerator.rootDisplay((ItemLike)GaiaRegistry.DOLL_DRYAD.get(), GaiaAdvancementGenerator.advancementPrefix("root.title"), GaiaAdvancementGenerator.advancementPrefix("root.desc"), GaiaAdvancementGenerator.modLoc("textures/block/pearl_block_bottom.png"))).m_138386_("join", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)Blocks.f_50016_)).m_138389_(consumer, GaiaAdvancementGenerator.rootID("root"));
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ANT_SALVAGER, (Item)GaiaRegistry.PROJECTILE_POISON.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ANT_WORKER, Items.f_42496_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ANUBIS, (Item)GaiaRegistry.SKELETON_STAFF.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ARACHNE, (Item)GaiaRegistry.CAVE_SPIDER_STAFF.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.BANSHEE, (Item)GaiaRegistry.SOULFIRE.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.BEHENDER, (Item)GaiaRegistry.WEAPON_BOOK_ENDER.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.BONE_KNIGHT, (Item)GaiaRegistry.BONE_SHIELD.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.CECAELIA, (Item)GaiaRegistry.SHINY_PEARL.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.COBBLESTONE_GOLEM, (Item)GaiaRegistry.WEAPON_BOOK_METAL.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.CREEP, (Item)GaiaRegistry.DOLL_CREEPER_GIRL_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.CYAN_FLOWER, (Item)GaiaRegistry.MANDRAKE.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.DEATHWORD, Items.f_42516_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.DULLAHAN, (Item)GaiaRegistry.DOLL_DULLAHAN_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ENDER_EYE, Items.f_42584_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.FLESH_LICH, (Item)GaiaRegistry.ZOMBIE_STAFF.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.GELATINOUS_SLIME, (Item)GaiaRegistry.DOLL_SLIME_GIRL_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.GOBLIN_FERAL, Items.f_42423_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.GRAVEMITE, Items.f_41852_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.HARPY, (Item)GaiaRegistry.DECO_NEST_HARPY_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.KOBOLD, Items.f_42411_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MANDRAGORA, (Item)GaiaRegistry.DECO_GARDEN_GNOME_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MATANGO, Items.f_41953_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MIMIC, Items.f_42009_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MINOTAUR, (Item)GaiaRegistry.MINOTAUR_HAMMER.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MINOTAURUS, (Item)GaiaRegistry.WEAPON_BOOK_BATTLE.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MUMMY, Items.f_42583_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.NAGA, (Item)GaiaRegistry.GOLD_SHIELD.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.NINE_TAILS, (Item)GaiaRegistry.DOLL_NINE_TAILS_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ONI, (Item)GaiaRegistry.METAL_CLUB.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ORC, Items.f_42428_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SHAMAN, (Item)GaiaRegistry.ROTTEN_HEART.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SHARKO, (Item)GaiaRegistry.SHINY_PEARL.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SIREN, Items.f_42526_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SLUDGE_GIRL, Items.f_42518_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SPHINX, (Item)GaiaRegistry.BUST_SPHINX_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SPORELING, Items.f_41952_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SPRIGGAN, Items.f_41837_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SUCCUBUS, (Item)GaiaRegistry.FIRESHARD.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.TOAD, Items.f_42518_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.VALKYRIE, (Item)GaiaRegistry.BUST_VALKYRIE_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.WERECAT, (Item)GaiaRegistry.MEAT.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.WITCH, Items.f_42589_, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.WITHER_COW, (Item)GaiaRegistry.WITHERED_BRAIN.get(), root);
        }

        protected static void addKillAdvancement(Consumer<Advancement> consumer, MobReg<? extends LivingEntity> mobReg, @Nullable Item item, Advancement root) {
            ResourceLocation registryLocation = GaiaAdvancementGenerator.modLoc(mobReg.getName());
            Item icon = item != null ? item : (Item)mobReg.getSpawnEgg().orElse((Object)Items.f_42521_);
            Advancement advancement = Advancement.Builder.m_138353_().m_138358_(GaiaAdvancementGenerator.simpleDisplay((ItemLike)icon, registryLocation.m_135815_())).m_138398_(root).m_138386_("kill", (CriterionTriggerInstance)GaiaAdvancementGenerator.onKill(mobReg.getEntityType())).m_138389_(consumer, GaiaAdvancementGenerator.rootID(registryLocation.m_135815_()));
            entityTypeAdvancementMap.put(mobReg.getEntityType(), advancement);
        }

        protected static void addKillAdvancement(Consumer<Advancement> consumer, PropReg<? extends LivingEntity> propReg, @Nullable Item item, Advancement root) {
            ResourceLocation registryLocation = GaiaAdvancementGenerator.modLoc(propReg.getName());
            Item icon = item != null ? item : (Item)propReg.getSpawnEgg().orElse((Object)Items.f_42521_);
            Advancement advancement = Advancement.Builder.m_138353_().m_138358_(GaiaAdvancementGenerator.simpleDisplay((ItemLike)icon, registryLocation.m_135815_())).m_138398_(root).m_138386_("kill", (CriterionTriggerInstance)GaiaAdvancementGenerator.onKill(propReg.getEntityType())).m_138389_(consumer, GaiaAdvancementGenerator.rootID(registryLocation.m_135815_()));
            entityTypeAdvancementMap.put(propReg.getEntityType(), advancement);
        }

        protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)Component.m_237115_((String)titleKey), (Component)Component.m_237115_((String)descKey), background, FrameType.TASK, false, false, false);
        }

        protected static DisplayInfo simpleDisplay(ItemLike icon, String name) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)Component.m_237115_((String)GaiaAdvancementGenerator.advancementPrefix(name + ".title")), (Component)Component.m_237115_((String)GaiaAdvancementGenerator.advancementPrefix(name + ".desc")), null, FrameType.TASK, true, false, false);
        }

        protected static KilledTrigger.TriggerInstance onKill(EntityType<?> entityType) {
            return KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType));
        }

        private static ResourceLocation modLoc(String path) {
            return new ResourceLocation("grimoireofgaia", path);
        }

        private static String advancementPrefix(String name) {
            return "advancement.grimoireofgaia." + name;
        }

        private static String rootID(String name) {
            return GaiaAdvancementGenerator.modLoc("main/" + name).toString();
        }
    }
}

