/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Arachne
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Arachne.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(Arachne.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int switchHealth = 0;
    private int spawn = 0;
    private int spawnTimer = 0;
    private boolean animationPlay = false;
    private int animationTimer = 0;

    public Arachne(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.web(target, (LivingEntity)this, distanceFactor);
            this.setAttackType(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.ARACHNE.getEntityType();
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        this.beaconMonster(6, entity -> {
            if (entity instanceof Spider) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 1, true, true));
            }
        });
        if (this.m_21223_() < this.m_21233_() * 0.5f && this.switchHealth == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
            this.setGoals(1);
            this.switchHealth = 1;
        }
        if (this.m_21223_() > this.m_21233_() * 0.5f && this.switchHealth == 1) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.CAVE_SPIDER_STAFF.get()));
            this.setGoals(0);
            this.switchHealth = 0;
        }
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.m_21223_() > 0.0f && this.spawn == 0) {
            this.setAttackType(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.m_9236_().m_7605_((Entity)this, (byte)9);
                this.setAttackType(0);
                if (!this.m_9236_().f_46443_) {
                    this.setSpawn(0);
                }
                this.spawnTimer = 0;
                this.spawn = 1;
            }
        }
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.m_21223_() > 0.0f && this.spawn == 1) {
            this.setAttackType(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.m_9236_().m_7605_((Entity)this, (byte)9);
                this.setAttackType(0);
                if (!this.m_9236_().f_46443_) {
                    this.setSpawn(0);
                }
                this.spawnTimer = 0;
                this.spawn = 2;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAttackType(0);
                this.animationPlay = false;
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        super.m_8107_();
    }

    private void setSpawn(int id) {
        CaveSpider caveSpider;
        if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL && id == 0 && (caveSpider = (CaveSpider)EntityType.f_20554_.m_20615_(this.m_9236_())) != null) {
            caveSpider.m_20035_(this.m_20183_(), 0.0f, 0.0f);
            caveSpider.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
            this.m_9236_().m_7967_((Entity)caveSpider);
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
    }

    private void setCombatTask() {
        ItemStack itemstack = this.m_21205_();
        if (itemstack.m_150930_((Item)GaiaRegistry.CAVE_SPIDER_STAFF.get())) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.collideAttackGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.collideAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.rangedAttackGoal);
            this.setAttackType(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = value ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    protected ResourceLocation m_7582_() {
        return this.f_19796_.m_188503_(2) == 0 ? super.m_7582_() : EntityType.f_20495_.m_20677_();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        ItemStack staffStack = new ItemStack((ItemLike)GaiaRegistry.CAVE_SPIDER_STAFF.get());
        staffStack.m_41663_(Enchantments.f_44980_, 2);
        this.m_8061_(EquipmentSlot.MAINHAND, staffStack);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("WeaponType", this.getAttackType());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("WeaponType")) {
            this.setAttackType(tag.m_128451_("WeaponType"));
        }
        this.setCombatTask();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.ARACHNE.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.ARACHNE.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.ARACHNE.getDeath();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState state, Vec3 speedMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, speedMultiplier);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(effectInstance);
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkArachneSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Arachne.checkDaysPassed(levelAccessor) && Arachne.checkBelowSeaLevel(levelAccessor, pos) && Arachne.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

