/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Gryphon
extends AbstractAssistGaiaEntity
implements IDayMob {
    private static final UUID KNOCKBACK_MODIFIER_UUID = UUID.fromString("3F9A8135-BC93-4EAB-B02A-33D75D54A09E");
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(KNOCKBACK_MODIFIER_UUID, "Knockback boost", 2.0, AttributeModifier.Operation.ADDITION);

    public Gryphon(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(2, (Goal)new LeapAttack(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        Vec3 motion = this.m_20184_();
        if (!this.m_20096_() && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.6, 1.0));
        }
        super.m_8107_();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22282_);
        attributeinstance.m_22130_(KNOCKBACK_MODIFIER);
        attributeinstance.m_22118_(KNOCKBACK_MODIFIER);
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.GRYPHON.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.GRYPHON.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.GRYPHON.getDeath();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState state, BlockPos pos) {
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkGryphonSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Gryphon.checkDaysPassed(levelAccessor) && Gryphon.checkDaytime(levelAccessor) && Gryphon.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Gryphon.checkAboveSeaLevel(levelAccessor, pos) && Gryphon.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }

    static class LeapAttack
    extends MobAttackGoal {
        public LeapAttack(Gryphon gryphon) {
            super((PathfinderMob)gryphon, 1.25, true);
        }

        protected double m_6639_(LivingEntity livingEntity) {
            return 4.0 + (double)livingEntity.m_20205_();
        }
    }
}

