/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class Mandragora
extends AbstractGaiaEntity
implements IDayMob {
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(Mandragora.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SCREAMING = SynchedEntityData.m_135353_(Mandragora.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private byte inWaterTimer = 0;

    public Mandragora(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MobAttackGoal((PathfinderMob)this, 1.15, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
        this.m_20088_().m_135372_(IS_SCREAMING, (Object)false);
    }

    public boolean isScreaming() {
        return (Boolean)this.f_19804_.m_135370_(IS_SCREAMING);
    }

    public void setIsScreaming(boolean screaming) {
        this.f_19804_.m_135381_(IS_SCREAMING, (Object)screaming);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Player player;
        ItemStack itemstack;
        float input = this.getBaseDamage(source, damage);
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (itemstack = (player = (Player)entity).m_21120_(player.m_7655_())).canPerformAction(ToolActions.SHOVEL_DIG)) {
            input *= 1.5f;
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                int effectTime2 = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 20;
                    effectTime2 = 10;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 30;
                    effectTime2 = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 0));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, effectTime * 20, 0));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, effectTime2 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (this.isScreaming()) {
            this.beaconMonster(2, entity -> {
                if (entity instanceof Player) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0, true, true));
                }
            });
        }
        if (!this.m_9236_().f_46443_ && this.m_20069_()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)8);
                this.m_5634_(this.m_21233_() * 0.1f);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (!blockstate.m_60795_()) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
            }
        }
        if (this.m_6060_()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
        }
        super.m_8107_();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_6863_(true);
        this.setIsScreaming(true);
        return data;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19604_ && super.m_7301_(effectInstance);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsBaby", this.m_6162_());
        tag.m_128379_("IsScreaming", this.isScreaming());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_6863_(tag.m_128471_("IsBaby"));
        if (tag.m_128441_("IsScreaming")) {
            this.setIsScreaming(tag.m_128471_("IsScreaming"));
        }
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.MANDRAGORA.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.MANDRAGORA.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.MANDRAGORA.getDeath();
    }

    public int m_5792_() {
        return 2;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_6162_() && itemstack.m_150930_(Items.f_42499_)) {
            for (int i = 0; i < 16; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
            }
            if ((double)this.f_19796_.m_188501_() < 0.45 && !this.m_9236_().f_46443_) {
                this.m_6863_(false);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void setupFriendGoals(boolean friendly) {
        super.setupFriendGoals(friendly);
        this.setIsScreaming(false);
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    public void m_6863_(boolean value) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)value);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_BABY_ID.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public static boolean checkMandragoraSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Mandragora.checkDaysPassed(levelAccessor) && Mandragora.checkDaytime(levelAccessor) && Mandragora.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Mandragora.checkAboveSeaLevel(levelAccessor, pos) && Mandragora.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

