/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;

public class Spriggan
extends AbstractGaiaEntity {
    private byte inWaterTimer;

    public Spriggan(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.inWaterTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MobAttackGoal((PathfinderMob)this, 1.275, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Player player;
        ItemStack itemstack;
        float input = this.getBaseDamage(source, damage);
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (itemstack = (player = (Player)entity).m_21120_(player.m_7655_())).canPerformAction(ToolActions.AXE_DIG)) {
            input *= 1.5f;
        }
        return super.m_6469_(source, input);
    }

    @Override
    public void m_8107_() {
        if (!((Boolean)GaiaConfig.COMMON.disableInvisibility.get()).booleanValue()) {
            if (this.playerDetection(6, TargetingConditions.m_148352_())) {
                if (this.m_21023_(MobEffects.f_19609_)) {
                    this.m_21195_(MobEffects.f_19609_);
                }
            } else if (!this.m_21023_(MobEffects.f_19609_) || this.m_21124_(MobEffects.f_19609_).m_19557_() < 5) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 20, 0));
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_20070_()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)8);
                this.m_5634_(this.m_21233_() * 0.1f);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.m_6060_()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
        }
        super.m_8107_();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.SPRIGGAN.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.SPRIGGAN.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.SPRIGGAN.getDeath();
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkSprigganSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Spriggan.checkDaysPassed(levelAccessor) && Spriggan.checkAboveSeaLevel(levelAccessor, pos) && Spriggan.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

