/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Werecat
extends AbstractGaiaEntity {
    private static final UUID KNOCKBACK_MODIFIER_UUID = UUID.fromString("ADEC7FC8-DFB3-11EC-9D64-0242AC120002");
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(KNOCKBACK_MODIFIER_UUID, "Knockback boost", 2.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.m_135353_(Werecat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final LeapAtTargetGoal leapAtTargetGoal = new LeapAtTargetGoal((Mob)this, 0.4f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private final AvoidEntityGoal<Player> avoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 20.0f, 1.25, 1.3);
    private int switchHealth = 0;

    public Werecat(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLEEING, (Object)false);
    }

    public boolean isFleeing() {
        return (Boolean)this.f_19804_.m_135370_(FLEEING);
    }

    public void setFleeing(boolean flag) {
        this.f_19804_.m_135381_(FLEEING, (Object)flag);
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 1));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.switchHealth == 0) {
            switch (this.f_19796_.m_188503_(2)) {
                case 0: {
                    this.setGoals(1);
                    this.setFleeing(true);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.m_21223_() > this.m_21233_() * 0.25f && this.switchHealth == 1) {
            this.setGoals(0);
            this.setFleeing(false);
            this.switchHealth = 0;
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25352_(1, this.avoidPlayerGoal);
            this.f_21345_.m_25363_((Goal)this.leapAtTargetGoal);
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25352_(1, (Goal)this.leapAtTargetGoal);
            this.f_21345_.m_25352_(2, (Goal)this.mobAttackGoal);
            this.f_21345_.m_25363_(this.avoidPlayerGoal);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        if (this.f_19796_.m_188503_(4) == 0) {
            this.setVariant(1);
        }
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22282_);
        attributeinstance.m_22130_(KNOCKBACK_MODIFIER);
        attributeinstance.m_22118_(KNOCKBACK_MODIFIER);
        this.setGoals(0);
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.WERECAT.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.WERECAT.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.WERECAT.getDeath();
    }

    protected int m_6101_() {
        return 10;
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkWerecatSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Werecat.checkDaysPassed(levelAccessor) && Werecat.checkAboveSeaLevel(levelAccessor, pos) && Werecat.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

