/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Witch
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> IS_DRINKING = SynchedEntityData.m_135353_(Witch.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RIDING = SynchedEntityData.m_135353_(Witch.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID SPEED_MODIFIER_DRINKING_UUID = UUID.fromString("E5EEE9D2-C325-415F-ADAF-A320D2AABC8B");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_UUID, "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    protected final FlyingMoveControl flyingControl = new FlyingMoveControl((Mob)this, 20, true);
    protected final MoveControl groundControl = new MoveControl((Mob)this);
    protected final FlyingPathNavigation flyingNavigation = new FlyingPathNavigation((Mob)this, this.m_9236_());
    protected final GroundPathNavigation groundNavigation = new GroundPathNavigation((Mob)this, this.m_9236_());
    private int spawn;
    private int usingTime;

    public Witch(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.spawn = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.275, 60, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !Witch.this.isRidingBroom();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && Witch.this.isRidingBroom();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_DRINKING, (Object)false);
        this.m_20088_().m_135372_(IS_RIDING, (Object)false);
    }

    public void setUsingItem(boolean value) {
        this.m_20088_().m_135381_(IS_DRINKING, (Object)value);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.m_20088_().m_135370_(IS_DRINKING);
    }

    public void setRidingBroom(boolean value) {
        this.m_20088_().m_135381_(IS_RIDING, (Object)value);
    }

    public boolean isRidingBroom() {
        return (Boolean)this.m_20088_().m_135370_(IS_RIDING);
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (!this.isDrinkingPotion()) {
            Vec3 vec3 = target.m_20184_();
            double d0 = target.m_20185_() + vec3.f_82479_ - this.m_20185_();
            double d1 = target.m_20188_() - (double)1.1f - this.m_20186_();
            double d2 = target.m_20189_() + vec3.f_82481_ - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            Potion potion = Potions.f_43582_;
            if (target instanceof Raider) {
                potion = target.m_21223_() <= 4.0f ? Potions.f_43623_ : Potions.f_43587_;
                this.m_6710_(null);
            } else if (d3 >= 8.0 && !target.m_21023_(MobEffects.f_19597_)) {
                potion = Potions.f_43615_;
            } else if (target.m_21223_() >= 8.0f && !target.m_21023_(MobEffects.f_19614_)) {
                potion = Potions.f_43584_;
            } else if (d3 <= 3.0 && !target.m_21023_(MobEffects.f_19613_) && this.f_19796_.m_188501_() < 0.25f) {
                potion = Potions.f_43593_;
            }
            ThrownPotion thrownpotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
            thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
            thrownpotion.m_146926_(thrownpotion.m_146909_() + 20.0f);
            thrownpotion.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            this.m_9236_().m_7967_((Entity)thrownpotion);
        }
    }

    @Override
    public void m_8107_() {
        Vec3 motion = this.m_20184_();
        if (!this.m_20096_() && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.6, 1.0));
        }
        this.beaconMonster(6, entity -> {
            if (entity instanceof Zombie || entity instanceof Skeleton) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 1, true, true));
            }
        });
        if (!this.m_9236_().f_46443_ && this.m_20159_() && this.isRidingBroom()) {
            this.m_8127_();
        }
        motion = this.m_20184_();
        if (motion.f_82479_ > 0.0 || motion.f_82480_ > 0.0 || motion.f_82481_ > 0.0) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            }
        }
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.m_21223_() > 0.0f && this.spawn == 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)9);
            if (!this.m_9236_().f_46443_) {
                this.setSpawn(0);
            }
            this.spawn = 1;
        }
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.m_21223_() > 0.0f && this.spawn == 1) {
            this.m_9236_().m_7605_((Entity)this, (byte)9);
            if (!this.m_9236_().f_46443_) {
                this.setSpawn(1);
            }
            this.spawn = 2;
        }
        if (this.isDrinkingPotion()) {
            if (this.usingTime-- <= 0) {
                List list;
                this.setUsingItem(false);
                ItemStack itemstack = this.m_21205_();
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                if (itemstack.m_150930_(Items.f_42589_) && (list = PotionUtils.m_43547_((ItemStack)itemstack)) != null) {
                    for (MobEffectInstance mobeffectinstance : list) {
                        this.m_7292_(new MobEffectInstance(mobeffectinstance));
                    }
                }
                this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_DRINKING);
            }
        } else {
            Potion potion = null;
            if (this.f_19796_.m_188501_() < 0.15f && this.m_204029_(FluidTags.f_13131_) && !this.m_21023_(MobEffects.f_19608_)) {
                potion = Potions.f_43621_;
            } else if (this.f_19796_.m_188501_() < 0.15f && (this.m_6060_() || this.m_21225_() != null && this.m_21225_().m_269533_(DamageTypeTags.f_268745_)) && !this.m_21023_(MobEffects.f_19607_)) {
                potion = Potions.f_43610_;
            } else if (this.f_19796_.m_188501_() < 0.05f && this.m_21223_() < this.m_21233_()) {
                potion = Potions.f_43623_;
            } else if (this.f_19796_.m_188501_() < 0.5f && this.m_5448_() != null && !this.m_21023_(MobEffects.f_19596_) && this.m_5448_().m_20280_((Entity)this) > 121.0) {
                potion = Potions.f_43612_;
            }
            if (potion != null) {
                this.m_8061_(EquipmentSlot.MAINHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion));
                this.usingTime = this.m_21205_().m_41779_();
                this.setUsingItem(true);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
                AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
                attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
                attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
            }
        }
        super.m_8107_();
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (equipmentSlot == EquipmentSlot.OFFHAND) {
            boolean isRidingBroom = stack.m_150930_((Item)GaiaRegistry.BROOM.get());
            this.setRidingBroom(isRidingBroom);
            if (!isRidingBroom && this.m_20068_()) {
                this.m_20242_(false);
            }
            this.f_21342_ = isRidingBroom ? this.flyingControl : this.groundControl;
            this.f_21344_ = isRidingBroom ? this.flyingNavigation : this.groundNavigation;
        }
        super.m_8061_(equipmentSlot, stack);
    }

    private void setSpawn(int id) {
        if (!this.m_9236_().f_46443_) {
            Monster monster;
            BlockPos blockpos = this.m_20183_().m_7918_(-1 + this.f_19796_.m_188503_(3), 1, -1 + this.f_19796_.m_188503_(3));
            Monster monster2 = monster = id == 0 ? (Monster)EntityType.f_20501_.m_20615_(this.m_9236_()) : (Monster)EntityType.f_20524_.m_20615_(this.m_9236_());
            if (monster != null) {
                monster.m_20035_(blockpos, 0.0f, 0.0f);
                monster.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()));
                monster.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                monster.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                monster.m_21409_(EquipmentSlot.FEET, 0.0f);
                monster.m_21409_(EquipmentSlot.LEGS, 0.0f);
                monster.m_21409_(EquipmentSlot.CHEST, 0.0f);
                monster.m_21409_(EquipmentSlot.HEAD, 0.0f);
                this.m_9236_().m_7967_((Entity)monster);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected ResourceLocation m_7582_() {
        return this.f_19796_.m_188503_(2) == 0 ? super.m_7582_() : EntityType.f_20495_.m_20677_();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack(random.m_188503_(2) == 0 ? (ItemLike)GaiaRegistry.ZOMBIE_STAFF.get() : (ItemLike)GaiaRegistry.SKELETON_STAFF.get()));
        if (random.m_188503_(2) == 0) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.BROOM.get()));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        if (this.f_19796_.m_188503_(4) == 0) {
            this.setVariant(1);
        }
        this.m_213945_(this.f_19796_, difficultyInstance);
        return data;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && effectInstance.m_19544_() != MobEffects.f_19602_ && super.m_7301_(effectInstance);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.WITCH.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.WITCH.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.WITCH.getDeath();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkWitchSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Witch.checkDaysPassed(levelAccessor) && Witch.checkAboveSeaLevel(levelAccessor, pos) && Witch.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

