/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.item.weapon.book.WeaponBookItem;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class WizardHarpy
extends AbstractAssistGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(WizardHarpy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> STORED_STACK = SynchedEntityData.m_135353_(WizardHarpy.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final AvoidEntityGoal<Player> avoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 20.0f, 1.25, 1.3);
    private boolean animationPlay = false;
    private int animationTimer = 0;
    private int switchHealth = 0;

    public WizardHarpy(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    public float m_20236_(Pose pose) {
        return this.m_6972_((Pose)pose).f_20378_ * 0.5f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(STORED_STACK, (Object)ItemStack.f_41583_);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public ItemStack getStoredStack() {
        return (ItemStack)this.f_19804_.m_135370_(STORED_STACK);
    }

    public void setStoredStack(ItemStack stack) {
        this.f_19804_.m_135381_(STORED_STACK, (Object)stack);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            ItemStack offhandItem = this.m_21206_();
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_FREEZING.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19597_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19599_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_METAL.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19604_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_ENDER.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19610_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_HUNGER.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19612_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_BATTLE.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19613_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_NATURE.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19614_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK_WITHER.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, MobEffects.f_19615_);
            }
            if (offhandItem.m_150930_((Item)GaiaRegistry.WEAPON_BOOK.get())) {
                RangedUtil.magic(target, (LivingEntity)this, distanceFactor);
            }
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    @Override
    public void m_8107_() {
        Vec3 motion = this.m_20184_();
        if (!this.m_20096_() && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.switchHealth == 0) {
            switch (this.f_19796_.m_188503_(2)) {
                case 0: {
                    this.setGoals(1);
                    this.setStoredStack(this.m_21206_());
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    this.setAnimationState(2);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.m_21223_() > this.m_21233_() * 0.25f && this.switchHealth == 1) {
            this.setGoals(0);
            this.m_8061_(EquipmentSlot.OFFHAND, this.getStoredStack());
            this.setStoredStack(ItemStack.f_41583_);
            this.setAnimationState(0);
            this.switchHealth = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(3, this.avoidPlayerGoal);
        } else {
            this.f_21345_.m_25363_(this.avoidPlayerGoal);
            this.f_21345_.m_25352_(1, (Goal)this.rangedAttackGoal);
            this.setAnimationState(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    public boolean m_142535_(float distance, float multiplier, DamageSource source) {
        return false;
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_(this.avoidPlayerGoal);
        this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
        ItemStack itemstack = this.m_21206_();
        if (itemstack.m_41720_() instanceof WeaponBookItem) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        switch (random.m_188503_(3)) {
            case 0: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_FREEZING.get()));
                break;
            }
            case 1: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get()));
                break;
            }
            case 2: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_METAL.get()));
                break;
            }
            case 3: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_ENDER.get()));
                break;
            }
            case 4: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_HUNGER.get()));
                break;
            }
            case 5: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_BATTLE.get()));
                break;
            }
            case 6: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_NATURE.get()));
                break;
            }
            case 7: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_WITHER.get()));
                break;
            }
            default: {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK.get()));
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.WIZARD_HARPY.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.WIZARD_HARPY.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.WIZARD_HARPY.getDeath();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCombatTask();
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkWizardHarpySpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WizardHarpy.checkDaysPassed(levelAccessor) && WizardHarpy.checkAboveSeaLevel(levelAccessor, pos) && WizardHarpy.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

