/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class YukiOnna
extends AbstractAssistGaiaEntity
implements IDayMob {
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.m_135353_(YukiOnna.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID KNOCKBACK_MODIFIER_UUID = UUID.fromString("D2EF3144-4329-4118-860A-80D2820C2CF1");
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(KNOCKBACK_MODIFIER_UUID, "Knockback boost", 2.0, AttributeModifier.Operation.ADDITION);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private final AvoidEntityGoal<Player> avoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 20.0f, 1.275, 1.3);
    private int switchHealth;

    public YukiOnna(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.switchHealth = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLEEING, (Object)false);
    }

    public boolean isFleeing() {
        return (Boolean)this.f_19804_.m_135370_(FLEEING);
    }

    public void setFleeing(boolean flag) {
        this.f_19804_.m_135381_(FLEEING, (Object)flag);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 3));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.switchHealth == 0) {
            switch (this.f_19796_.m_188503_(2)) {
                case 0: {
                    this.setGoals(1);
                    this.setFleeing(true);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.m_21223_() > this.m_21233_() * 0.25f && this.switchHealth == 1) {
            this.setGoals(0);
            this.setFleeing(false);
            this.switchHealth = 0;
        }
        if (!this.m_9236_().f_46443_ && ((Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_()).m_47505_(this.m_20183_()) > 1.0f) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
            this.f_21345_.m_25352_(1, this.avoidPlayerGoal);
        } else {
            this.f_21345_.m_25363_(this.avoidPlayerGoal);
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        if (!this.m_6162_()) {
            if (random.m_188503_(4) == 0) {
                AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22282_);
                attributeinstance.m_22130_(KNOCKBACK_MODIFIER);
                ItemStack weapon = new ItemStack((ItemLike)GaiaRegistry.FAN.get(), 1);
                weapon.m_41663_(Enchantments.f_44980_, 3);
                this.setHandOrKnockback(weapon);
            } else {
                this.setHandOrKnockback(ItemStack.f_41583_);
            }
        }
    }

    protected void setHandOrKnockback(ItemStack stack) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22282_);
        attributeinstance.m_22130_(KNOCKBACK_MODIFIER);
        if (stack.m_41619_()) {
            attributeinstance.m_22118_(KNOCKBACK_MODIFIER);
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.setGoals(0);
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setGoals(0);
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.YUKI_ONNA.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.YUKI_ONNA.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.YUKI_ONNA.getDeath();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected int m_6101_() {
        return 20;
    }

    public boolean m_142535_(float distance, float multiplier, DamageSource source) {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkYukiOnnaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return YukiOnna.checkDaysPassed(levelAccessor) && YukiOnna.checkDaytime(levelAccessor) && YukiOnna.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && YukiOnna.checkAboveSeaLevel(levelAccessor, pos) && YukiOnna.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

