/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.projectile;

import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class MagicProjectile
extends SmallFireball {
    private static final EntityDataAccessor<Float> PROJECTILE_DAMAGE = SynchedEntityData.m_135353_(MagicProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public MagicProjectile(EntityType<? extends SmallFireball> entityType, Level level) {
        super(entityType, level);
    }

    public MagicProjectile(Level level) {
        this((EntityType<? extends SmallFireball>)((EntityType)GaiaRegistry.MAGIC.get()), level);
    }

    public MagicProjectile(Level level, LivingEntity livingEntity, double accelX, double accelY, double accelZ) {
        super(level, livingEntity, accelX, accelY, accelZ);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PROJECTILE_DAMAGE, (Object)Float.valueOf((float)SharedEntityData.getAttackDamage2() / 2.0f));
    }

    public ItemStack m_7846_() {
        ItemStack itemstack = this.m_37018_();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)GaiaRegistry.PROJECTILE_MAGIC.get()) : itemstack;
    }

    public MagicProjectile(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends SmallFireball>)((EntityType)GaiaRegistry.MAGIC.get()), level);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)GaiaRegistry.MAGIC.get();
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123810_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 60) {
            this.m_146870_();
        }
    }

    protected float m_6884_() {
        return this.m_20147_() ? 0.73f : super.m_6884_();
    }

    public boolean m_6060_() {
        return false;
    }

    protected float getProjectileDamage() {
        return ((Float)this.m_20088_().m_135370_(PROJECTILE_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.m_20088_().m_135381_(PROJECTILE_DAMAGE, (Object)Float.valueOf(damage));
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    protected void m_8060_(BlockHitResult hitResult) {
    }

    protected void m_5790_(EntityHitResult entityResult) {
        Entity owner;
        if (!this.m_9236_().f_46443_ && (owner = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity ownerEntity = (LivingEntity)owner;
            Entity entity = entityResult.m_82443_();
            entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)ownerEntity), this.getProjectileDamage());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 1));
                }
            }
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ProjectileDamage", this.getProjectileDamage());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setDamage(tag.m_128457_("ProjectileDamage"));
    }
}

