/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.entity.AntWorker;
import gaia.entity.prop.AbstractPropEntity;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.util.SharedEntityData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class AntHill
extends AbstractPropEntity {
    private static final EntityDataAccessor<Integer> DETECTION = SynchedEntityData.m_135353_(AntHill.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPAWN_AMOUNT = SynchedEntityData.m_135353_(AntHill.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int spawnTime = 0;

    public AntHill(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void finalizeAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)SharedEntityData.getMaxHealth1());
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = source.m_276093_(DamageTypes.f_268724_) ? damage : Math.min(damage, SharedEntityData.getBaseDefense1());
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack itemstack = player.m_21120_(player.m_7655_());
            input = itemstack.canPerformAction(ToolActions.SHOVEL_DIG) ? (input *= 8.0f) : 0.0f;
        }
        return super.m_6469_(source, input);
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public void m_8107_() {
        if (this.playerDetection()) {
            if (this.getSpawnAmount() > 0) {
                if (this.spawnTime >= 0 && this.spawnTime <= 60) {
                    ++this.spawnTime;
                } else {
                    if (!this.m_9236_().f_46443_) {
                        this.setSpawn(0);
                    }
                    this.m_6469_(this.m_269291_().m_269264_(), this.m_21233_() / (float)this.getSpawnAmount());
                    this.setSpawnAmount(this.getSpawnAmount() - 1);
                    this.spawnTime = 0;
                }
            } else {
                this.m_6074_();
            }
        }
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_6074_();
        }
        super.m_8107_();
    }

    private void setSpawn(int id) {
        AntWorker antWorker;
        if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL && id == 0 && (antWorker = (AntWorker)GaiaRegistry.ANT_WORKER.getEntityType().m_20615_(this.m_9236_())) != null) {
            antWorker.m_20035_(this.m_20183_(), 0.0f, 0.0f);
            antWorker.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            this.m_9236_().m_7967_((Entity)antWorker);
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
    }

    private boolean playerDetection() {
        AABB aabb = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82400_((double)this.getDetection());
        List list = this.m_9236_().m_45976_(Player.class, aabb);
        return !list.isEmpty();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.f_20883_ = 180.0f;
        this.f_20884_ = 180.0f;
        this.m_146922_(180.0f);
        this.f_19859_ = 180.0f;
        this.f_20885_ = 180.0f;
        this.f_20886_ = 180.0f;
        if (this.f_19796_.m_188503_(2) == 0) {
            this.setDetection(8);
            this.setSpawnAmount(4);
        } else {
            this.setDetection(6);
            this.setSpawnAmount(2);
        }
        return data;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DETECTION, (Object)-1);
        this.f_19804_.m_135372_(SPAWN_AMOUNT, (Object)-1);
    }

    public int getDetection() {
        return (Integer)this.f_19804_.m_135370_(DETECTION);
    }

    private void setDetection(int value) {
        this.f_19804_.m_135381_(DETECTION, (Object)value);
    }

    public int getSpawnAmount() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_AMOUNT);
    }

    private void setSpawnAmount(int value) {
        this.f_19804_.m_135381_(SPAWN_AMOUNT, (Object)value);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Detection", this.getDetection());
        tag.m_128405_("SpawnAmount", this.getSpawnAmount());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Detection")) {
            this.setDetection(tag.m_128451_("Detection"));
        }
        if (tag.m_128441_("SpawnAmount")) {
            this.setSpawnAmount(tag.m_128451_("SpawnAmount"));
        }
    }

    protected void playParticleEffect(boolean smoke) {
        SimpleParticleType particle = ParticleTypes.f_123762_;
        if (!smoke) {
            particle = ParticleTypes.f_123759_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    public void m_7822_(byte id) {
        if (id == 7) {
            this.playParticleEffect(true);
        } else if (id == 6) {
            this.playParticleEffect(false);
        } else {
            super.m_7822_(id);
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)GaiaSounds.ANT_HILL_DEATH.get();
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    public int m_8132_() {
        return 180;
    }

    public int m_8085_() {
        return 180;
    }

    public void m_7334_(Entity entity) {
    }

    public float m_6143_() {
        return 0.0f;
    }

    public static boolean checkAntHillSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AntHill.checkDaysPassed(levelAccessor) && AntHill.checkPropSpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

