/*
 * Decompiled with CFR 0.152.
 */
package gaia.util;

import com.google.common.collect.ImmutableMap;
import gaia.registry.GaiaRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class GaiaMerchantTrades {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> MERCHANT_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemForMerchantToken((ItemLike)GaiaRegistry.GIGA_GEAR.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.TOTEM_FRAGMENT.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_SPEED.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_HASTE.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_JUMP.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_NIGHT.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_EGG.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.CREEPER_GIRL.getSpawnEgg().get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.TRADER.getSpawnEgg().get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_OVERWORLD.get(), 1, 1, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_NETHER.get(), 1, 1, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_END.get(), 1, 1, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_OLD.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.FAN_FIRE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.FAN_ICE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_FREEZING.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_METAL.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_ENDER.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_HUNGER.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_BATTLE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_NATURE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_WITHER.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.HEAVY_BARBELL.get(), 1, 2, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_IRON.get(), 1, 1, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_GOLD.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_DIAMOND.get(), 1, 4, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BAG_BOOK.get(), 1, 4, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BAG_RECORD.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get(), 1, 4, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.CHEST_DUNGEON.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.CHEST_JUNGLE.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.CHEST_DESERT.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_HAT.get(), 1, 4, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> CREEPER_GIRL_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.f_42403_, 1, (ItemLike)Items.f_42500_, 2, 10, 5), new ItemsToItems((ItemLike)Items.f_42403_, 1, (ItemLike)Items.f_42583_, 4, 10, 5), new ItemsToItems((ItemLike)Items.f_42403_, 1, (ItemLike)Items.f_42591_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42403_, 1, (ItemLike)Items.f_42401_, 2, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.f_42500_, 4, (ItemLike)Items.f_42403_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42584_, 1, (ItemLike)Items.f_42403_, 2, 10, 5), new ItemsToItems((ItemLike)Items.f_42583_, 6, (ItemLike)Items.f_42403_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42401_, 4, (ItemLike)Items.f_42403_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42518_, 2, (ItemLike)Items.f_42403_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42591_, 2, (ItemLike)Items.f_42403_, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> SLIME_GIRL_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.f_42518_, 1, (ItemLike)Items.f_42500_, 2, 10, 5), new ItemsToItems((ItemLike)Items.f_42518_, 1, (ItemLike)Items.f_42583_, 4, 10, 5), new ItemsToItems((ItemLike)Items.f_42518_, 1, (ItemLike)Items.f_42403_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42518_, 1, (ItemLike)Items.f_42591_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42518_, 1, (ItemLike)Items.f_42401_, 2, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.f_42500_, 4, (ItemLike)Items.f_42518_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42584_, 1, (ItemLike)Items.f_42518_, 2, 10, 5), new ItemsToItems((ItemLike)Items.f_42403_, 2, (ItemLike)Items.f_42518_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42583_, 6, (ItemLike)Items.f_42518_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42401_, 4, (ItemLike)Items.f_42518_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42591_, 2, (ItemLike)Items.f_42518_, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> ENDER_GIRL_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.f_42584_, 1, (ItemLike)Items.f_42500_, 8, 10, 5), new ItemsToItems((ItemLike)Items.f_42584_, 1, (ItemLike)Items.f_42583_, 16, 10, 5), new ItemsToItems((ItemLike)Items.f_42584_, 1, (ItemLike)Items.f_42403_, 4, 10, 5), new ItemsToItems((ItemLike)Items.f_42584_, 1, (ItemLike)Items.f_42591_, 4, 10, 5), new ItemsToItems((ItemLike)Items.f_42584_, 1, (ItemLike)Items.f_42401_, 8, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.f_42500_, 16, (ItemLike)Items.f_42584_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42403_, 8, (ItemLike)Items.f_42584_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42583_, 24, (ItemLike)Items.f_42584_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42401_, 16, (ItemLike)Items.f_42584_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42518_, 8, (ItemLike)Items.f_42584_, 1, 10, 5), new ItemsToItems((ItemLike)Items.f_42591_, 8, (ItemLike)Items.f_42584_, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> HOLSTAURUS_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new HolstaurusTokenForItem((ItemLike)Items.f_42404_, 8, 1, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.f_42733_, 8, 1, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.f_42577_, 16, 1, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.f_42578_, 16, 2, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.f_42502_, 1, 16, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.f_42687_, 1, 8, 10, 5), new EnchantedItemForEmeralds(Items.f_42387_, (ItemLike)GaiaRegistry.HOLSTAURUS_TOKEN.get(), 16, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemForHolstaurusToken((ItemLike)Items.f_42405_, 8, 1, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.f_42046_, 2, 1, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.f_42028_, 1, 2, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.f_42521_, 8, 1, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.f_42501_, 16, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> WERESHEEP_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new WeresheepTokenForItem((ItemLike)Items.f_41870_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41871_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41872_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41873_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41874_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41875_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41876_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41877_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41878_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41932_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41933_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41934_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41935_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41936_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41937_, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.f_41938_, 1, 1, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemForWeresheepToken((ItemLike)Items.f_41870_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41871_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41872_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41873_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41874_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41875_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41876_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41877_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41878_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41932_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41933_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41934_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41935_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41936_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41937_, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.f_41938_, 1, 4, 10, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new ItemForWeresheepToken((ItemLike)Items.f_42401_, 4, 4, 10, 5)}));

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    static class ItemForMerchantToken
    extends ItemsToItems {
        public ItemForMerchantToken(ItemLike fromItem, int fromCount, int tokenCount, int maxUses, int xp) {
            super(fromItem, fromCount, (ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, maxUses, xp);
        }
    }

    static class MerchantTokenForItem
    extends ItemsToItems {
        public MerchantTokenForItem(ItemLike toItem, int toCount, int tokenCount, int maxUses, int xp) {
            super((ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, toItem, toCount, maxUses, xp);
        }
    }

    static class ItemsToItems
    implements VillagerTrades.ItemListing {
        private final ItemStack fromItem;
        private final int fromCount;
        private final ItemStack toItem;
        private final int toCount;
        private final int maxUses;
        private final int XP;
        private final float priceMultiplier;

        public ItemsToItems(ItemLike fromItem, int fromCount, ItemLike toItem, int toCount, int maxUses, int xp) {
            this.fromItem = new ItemStack(fromItem);
            this.fromCount = fromCount;
            this.toItem = new ItemStack(toItem);
            this.toCount = toCount;
            this.maxUses = maxUses;
            this.XP = xp;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)this.fromItem.m_41720_(), this.fromCount), new ItemStack((ItemLike)this.toItem.m_41720_(), this.toCount), this.maxUses, this.XP, this.priceMultiplier);
        }
    }

    static class HolstaurusTokenForItem
    extends ItemsToItems {
        public HolstaurusTokenForItem(ItemLike toItem, int toCount, int tokenCount, int maxUses, int xp) {
            super((ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, toItem, toCount, maxUses, xp);
        }
    }

    static class EnchantedItemForEmeralds
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final ItemLike token;
        private final int tokenCost;
        private final int maxUses;
        private final int XP;
        private final float priceMultiplier;

        public EnchantedItemForEmeralds(Item item, ItemLike token, int tokenCost, int maxUses, int xp) {
            this.itemStack = new ItemStack((ItemLike)item);
            this.token = token;
            this.tokenCost = tokenCost;
            this.maxUses = maxUses;
            this.XP = xp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            int i = 5 + random.m_188503_(15);
            ItemStack itemstack = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)new ItemStack((ItemLike)this.itemStack.m_41720_()), (int)i, (boolean)false);
            int j = Math.min(this.tokenCost + i, 64);
            ItemStack tokenStack = new ItemStack(this.token, j);
            return new MerchantOffer(tokenStack, itemstack, this.maxUses, this.XP, this.priceMultiplier);
        }
    }

    static class ItemForHolstaurusToken
    extends ItemsToItems {
        public ItemForHolstaurusToken(ItemLike fromItem, int fromCount, int tokenCount, int maxUses, int xp) {
            super(fromItem, fromCount, (ItemLike)GaiaRegistry.HOLSTAURUS_TOKEN.get(), tokenCount, maxUses, xp);
        }
    }

    static class WeresheepTokenForItem
    extends ItemsToItems {
        public WeresheepTokenForItem(ItemLike toItem, int toCount, int tokenCount, int maxUses, int xp) {
            super((ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, toItem, toCount, maxUses, xp);
        }
    }

    static class ItemForWeresheepToken
    extends ItemsToItems {
        public ItemForWeresheepToken(ItemLike fromItem, int fromCount, int tokenCount, int maxUses, int xp) {
            super(fromItem, fromCount, (ItemLike)GaiaRegistry.WERESHEEP_TOKEN.get(), tokenCount, maxUses, xp);
        }
    }
}

