package com.mdlc.higherchat.mixin;

import com.mdlc.higherchat.SharedStorage;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_329.class)
public abstract class GuiMixin {
    protected GuiMixin() {
    }

    /**
     * Runs before everything. Resets the values.
     */
    @Inject(method = "render", at = @At("HEAD"))
    private void onRender(class_332 graphics, class_9779 deltaTracker, CallbackInfo ci) {
        SharedStorage.resetData((class_329) (Object) this);
    }

    /**
     * Tests if a heart is higher than what we had seen until now.
     */
    @Redirect(method = "renderHeart", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"))
    private void onRenderHeart(class_332 graphics, RenderPipeline renderPipeline, class_2960 iconsLocation, int x, int y, int width, int height) {
        SharedStorage.declareIconAt(x, y);
        graphics.method_52706(renderPipeline, iconsLocation, x, y, width, height);
    }

    /**
     * Tests if an armor piece is higher than what we had seen until now.
     */
    @Redirect(method = "renderArmor", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"))
    private static void onRenderArmorPiece(class_332 graphics, RenderPipeline renderPipeline, class_2960 iconsLocation, int x, int y, int width, int height) {
        SharedStorage.declareIconAt(x, y);
        graphics.method_52706(renderPipeline, iconsLocation, x, y, width, height);
    }

    /**
     * Tests if a food icon is higher than what we had seen until now.
     */
    @Redirect(method = "renderFood", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"))
    private void onRenderFoodIcon(class_332 graphics, RenderPipeline renderPipeline, class_2960 iconsLocation, int x, int y, int width, int height) {
        SharedStorage.declareIconAt(x, y);
        graphics.method_52706(renderPipeline, iconsLocation, x, y, width, height);
    }

    /**
     * Tests if a vehicle heart is higher than what we had seen until now.
     */
    @Redirect(method = "renderVehicleHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"))
    private void onRenderVehicleHeart(class_332 graphics, RenderPipeline renderPipeline, class_2960 iconsLocation, int x, int y, int width, int height) {
        SharedStorage.declareIconAt(x, y);
        graphics.method_52706(renderPipeline, iconsLocation, x, y, width, height);
    }
}
