/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.core.protocol.protoweaver;

import java.util.Arrays;
import me.mrnavastar.protoweaver.api.ProtoConnectionHandler;
import me.mrnavastar.protoweaver.api.ProtoWeaver;
import me.mrnavastar.protoweaver.api.auth.ServerAuthHandler;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.netty.Sender;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.AuthStatus;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.InternalConnectionHandler;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.ProtocolStatus;

public class ServerConnectionHandler
extends InternalConnectionHandler
implements ProtoConnectionHandler {
    private boolean authenticated = false;
    private Protocol nextProtocol = null;
    private ServerAuthHandler authHandler = null;

    @Override
    public void handlePacket(ProtoConnection connection, Object packet) {
        if (packet instanceof ProtocolStatus) {
            ProtocolStatus status = (ProtocolStatus)packet;
            switch (status.getStatus()) {
                case START: {
                    this.nextProtocol = ProtoWeaver.getLoadedProtocol(status.getNextProtocol());
                    if (this.nextProtocol == null) {
                        this.protocolNotLoaded(connection, status.getNextProtocol());
                        return;
                    }
                    if (!"1.4.9".equals(status.getProtoweaverVersion())) {
                        this.nextProtocol.logWarn("Client connecting with ProtoWeaver version: " + status.getProtoweaverVersion() + ", but server is running: 1.4.9. There could be unexpected issues.");
                    }
                    if (this.nextProtocol.getMaxConnections() != -1 && this.nextProtocol.getConnections() >= this.nextProtocol.getMaxConnections()) {
                        status.setStatus(ProtocolStatus.Status.FULL);
                        this.disconnectIfNeverUpgraded(connection, connection.send(status));
                        return;
                    }
                    if (!Arrays.equals(this.nextProtocol.getSHA1(), status.getNextSHA1())) {
                        this.nextProtocol.logErr("Mismatch with protocol version on the client!");
                        this.nextProtocol.logErr("Double check that all packets are registered in the same order and all settings are the same.");
                        status.setStatus(ProtocolStatus.Status.MISMATCH);
                        this.disconnectIfNeverUpgraded(connection, connection.send(status));
                        return;
                    }
                    if (this.nextProtocol.requiresAuth(Side.SERVER)) {
                        this.authHandler = this.nextProtocol.newServerAuthHandler();
                        connection.send((Object)AuthStatus.REQUIRED);
                        return;
                    }
                    this.authenticated = true;
                    break;
                }
                case MISSING: {
                    this.nextProtocol.logErr("Protocol is not loaded on client!");
                    this.disconnectIfNeverUpgraded(connection);
                }
            }
        }
        if (this.nextProtocol != null && packet instanceof byte[]) {
            byte[] secret = (byte[])packet;
            this.authenticated = this.authHandler.handleAuth(connection, secret);
        }
        if (!this.authenticated) {
            Sender sender = connection.send((Object)AuthStatus.DENIED);
            this.disconnectIfNeverUpgraded(connection, sender);
            return;
        }
        connection.send((Object)AuthStatus.OK);
        connection.send(new ProtocolStatus(connection.getProtocol().toString(), this.nextProtocol.toString(), new byte[0], ProtocolStatus.Status.UPGRADE));
        connection.upgradeProtocol(this.nextProtocol);
        this.nextProtocol.logInfo("Connected to: " + String.valueOf(connection.getRemoteAddress()));
    }

    @Override
    public void onDisconnect(ProtoConnection connection) {
        protocol.logInfo("Disconnected from: " + String.valueOf(connection.getRemoteAddress()));
    }
}

