/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.core.protocol.protoweaver;

import lombok.Generated;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.netty.Sender;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.AuthStatus;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.ClientConnectionHandler;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.ProtocolStatus;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.ServerConnectionHandler;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;

public class InternalConnectionHandler {
    protected static final Protocol protocol = Protocol.create("protoweaver", "internal").setServerHandler(ServerConnectionHandler.class, new Object[0]).setClientHandler(ClientConnectionHandler.class, new Object[0]).addPacket(AuthStatus.class).addPacket(ProtocolStatus.class).load();

    protected boolean wasUpgraded(ProtoConnection connection) {
        return connection.getProtocol().toString().equals(protocol.toString());
    }

    protected void disconnectIfNeverUpgraded(ProtoConnection connection, Sender sender) {
        if (!this.wasUpgraded(connection)) {
            return;
        }
        if (sender != null) {
            sender.disconnect();
            return;
        }
        connection.disconnect();
    }

    protected void disconnectIfNeverUpgraded(ProtoConnection connection) {
        this.disconnectIfNeverUpgraded(connection, null);
    }

    protected void protocolNotLoaded(ProtoConnection connection, String name) {
        ProtoLogger.warn("Protocol: " + name + " is not loaded! Closing connection!");
        Sender sender = connection.send(new ProtocolStatus(connection.getProtocol().toString(), name, new byte[0], ProtocolStatus.Status.MISSING));
        this.disconnectIfNeverUpgraded(connection, sender);
    }

    @Generated
    public static Protocol getProtocol() {
        return protocol;
    }
}

