/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.loader;

import io.netty.channel.Channel;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.network.ChannelInitializeListener;
import io.papermc.paper.network.ChannelInitializeListenerHolder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import me.mrnavastar.protoweaver.api.ProtoWeaver;
import me.mrnavastar.protoweaver.api.protocol.velocity.VelocityAuth;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;
import me.mrnavastar.protoweaver.loader.netty.ProtoDeterminer;
import me.mrnavastar.protoweaver.loader.netty.SSLContext;
import net.kyori.adventure.key.Key;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Paper
extends JavaPlugin
implements ChannelInitializeListener,
ProtoLogger.IProtoLogger {
    private final Logger logger = this.getLogger();
    private boolean setup = false;

    public void onEnable() {
        if (!ProtoWeaver.getLoadedProtocols().isEmpty()) {
            this.setup();
        } else {
            ProtoWeaver.PROTOCOL_LOADED.register(protocol -> this.setup());
        }
    }

    private void setup() {
        if (this.setup) {
            return;
        }
        ProtoLogger.setLogger(this);
        ChannelInitializeListenerHolder.addListener((Key)new NamespacedKey("protoweaver", "internal"), (ChannelInitializeListener)this);
        SSLContext.init(this.getDataFolder().getAbsolutePath());
        VelocityAuth.setSecret(GlobalConfiguration.get().proxies.velocity.secret.getBytes(StandardCharsets.UTF_8));
        this.setup = true;
    }

    public void afterInitChannel(@NonNull Channel channel) {
        ProtoDeterminer.registerToPipeline(channel);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void warn(String message) {
        this.logger.warning(message);
    }

    @Override
    public void err(String message) {
        this.logger.severe(message);
    }
}

