/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.loader.netty;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SSLContext {
    private static SslContext context;
    private static InputStream privateKey;
    private static InputStream cert;

    public static void init(String dir) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Optional.ofNullable(System.getenv("PROTOWEAVER_PRIVATE_KEY")).ifPresent(value -> {
            privateKey = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
        });
        Optional.ofNullable(System.getenv("PROTOWEAVER_CERT")).ifPresent(value -> {
            cert = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
        });
        SSLContext.genKeys(dir);
        context = SslContextBuilder.forServer((InputStream)cert, (InputStream)privateKey).sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"http/1.1"})).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void genKeys(String dir) throws NoSuchAlgorithmException, CertificateException, IOException, OperatorCreationException {
        if (privateKey != null && cert != null) {
            return;
        }
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        X509Certificate certificate = SSLContext.genCert(kp);
        File privateKeyFile = new File(dir + "/keys/private.pem");
        File certFile = new File(dir + "/keys/cert.pem");
        if (!privateKeyFile.exists() || !certFile.exists()) {
            ProtoLogger.info("Generating SSL Keys");
            privateKeyFile.getParentFile().mkdirs();
            JcaPEMWriter privateWriter = new JcaPEMWriter((Writer)new FileWriter(privateKeyFile));
            try {
                JcaPEMWriter certWriter = new JcaPEMWriter((Writer)new FileWriter(certFile));
                try {
                    privateWriter.writeObject((Object)kp.getPrivate());
                    certWriter.writeObject((Object)certificate);
                }
                finally {
                    if (Collections.singletonList(certWriter).get(0) != null) {
                        certWriter.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(privateWriter).get(0) != null) {
                    privateWriter.close();
                }
            }
        }
        privateKey = new FileInputStream(privateKeyFile);
        cert = new FileInputStream(certFile);
    }

    private static X509Certificate genCert(KeyPair keyPair) throws OperatorCreationException, CertificateException, IOException {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        X500Name dnName = new X500Name("CN=PROTOWEAVER");
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 999);
        Date endDate = calendar.getTime();
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSA").build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, new BigInteger(Long.toString(now)), startDate, endDate, dnName, keyPair.getPublic());
        BasicConstraints basicConstraints = new BasicConstraints(true);
        certBuilder.addExtension(new ASN1ObjectIdentifier("2.5.29.19"), true, (ASN1Encodable)basicConstraints);
        return new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(certBuilder.build(contentSigner));
    }

    @Generated
    public static SslContext getContext() {
        return context;
    }
}

