/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.api.protocol;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import lombok.Generated;
import lombok.NonNull;
import me.mrnavastar.protoweaver.api.ProtoConnectionHandler;
import me.mrnavastar.protoweaver.api.ProtoSerializer;
import me.mrnavastar.protoweaver.api.ProtoWeaver;
import me.mrnavastar.protoweaver.api.auth.ClientAuthHandler;
import me.mrnavastar.protoweaver.api.auth.ServerAuthHandler;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.protocol.CompressionType;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.core.util.ObjectSerializer;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;

public class Protocol {
    private final ObjectSerializer serializer = new ObjectSerializer();
    private final MessageDigest packetMD = MessageDigest.getInstance("SHA-1");
    private final String namespace;
    private final String name;
    private CompressionType compression = CompressionType.NONE;
    private int compressionLevel = -37;
    private int maxPacketSize = 16384;
    private int maxConnections = -1;
    private Level loggingLevel = Level.ALL;
    private Constructor<? extends ProtoConnectionHandler> serverConnectionHandler;
    private Object[] serverConnectionHandlerArgs = new Object[0];
    private Constructor<? extends ProtoConnectionHandler> clientConnectionHandler;
    private Object[] clientConnectionHandlerArgs = new Object[0];
    private Constructor<? extends ServerAuthHandler> serverAuthHandler;
    private Object[] serverAuthHandlerArgs = new Object[0];
    private Constructor<? extends ClientAuthHandler> clientAuthHandler;
    private Object[] clientAuthHandlerArgs = new Object[0];

    private Protocol(String namespace, String name) throws NoSuchAlgorithmException {
        this.namespace = namespace;
        this.name = name;
    }

    public static Builder create(@NonNull String namespace, @NonNull String name) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new Builder(new Protocol(namespace, name));
    }

    public Builder modify() {
        return new Builder(this);
    }

    public ProtoConnectionHandler newConnectionHandler(Side side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Side.CLIENT -> {
                if (this.clientConnectionHandler == null) {
                    throw new RuntimeException("No client connection handler set for protocol: " + String.valueOf(this));
                }
                yield this.clientConnectionHandler.newInstance(this.clientConnectionHandlerArgs);
            }
            case Side.SERVER -> {
                if (this.serverConnectionHandler == null) {
                    throw new RuntimeException("No server connection handler set for protocol: " + String.valueOf(this));
                }
                yield this.serverConnectionHandler.newInstance(this.serverConnectionHandlerArgs);
            }
        };
    }

    public ServerAuthHandler newServerAuthHandler() {
        if (this.serverAuthHandler == null) {
            throw new RuntimeException("No server auth handler set for protocol: " + String.valueOf(this));
        }
        return this.serverAuthHandler.newInstance(this.serverAuthHandlerArgs);
    }

    public ClientAuthHandler newClientAuthHandler() {
        if (this.clientAuthHandler == null) {
            throw new RuntimeException("No client auth handler set for protocol: " + String.valueOf(this));
        }
        return this.clientAuthHandler.newInstance(this.clientAuthHandlerArgs);
    }

    public byte[] serialize(@NonNull Object packet) throws IllegalArgumentException {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return this.serializer.serialize(packet);
    }

    public Object deserialize(byte @NonNull [] packet) throws IllegalArgumentException {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return this.serializer.deserialize(packet);
    }

    public byte[] getSHA1() {
        MessageDigest md = (MessageDigest)this.packetMD.clone();
        md.update(this.toString().getBytes(StandardCharsets.UTF_8));
        md.update(ByteBuffer.allocate(12).putInt(this.compressionLevel).putInt(this.compression.ordinal()).putInt(this.maxPacketSize).array());
        return md.digest();
    }

    public int getConnections() {
        return ProtoConnection.getConnectionCount(this);
    }

    public boolean requiresAuth(@NonNull Side side) {
        if (side == null) {
            throw new NullPointerException("side is marked non-null but is null");
        }
        if (side.equals((Object)Side.CLIENT)) {
            return this.clientAuthHandler != null;
        }
        return this.serverAuthHandler != null;
    }

    public void logInfo(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.loggingLevel.intValue() <= Level.INFO.intValue()) {
            ProtoLogger.info("[" + String.valueOf(this) + "]: " + message);
        }
    }

    public void logWarn(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.loggingLevel.intValue() <= Level.WARNING.intValue()) {
            ProtoLogger.warn("[" + String.valueOf(this) + "]: " + message);
        }
    }

    public void logErr(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.loggingLevel.intValue() <= Level.SEVERE.intValue()) {
            ProtoLogger.err("[" + String.valueOf(this) + "]: " + message);
        }
    }

    public String toString() {
        return this.namespace + ":" + this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Protocol)) {
            return false;
        }
        Protocol other = (Protocol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCompressionLevel() != other.getCompressionLevel()) {
            return false;
        }
        if (this.getMaxPacketSize() != other.getMaxPacketSize()) {
            return false;
        }
        if (this.getMaxConnections() != other.getMaxConnections()) {
            return false;
        }
        MessageDigest this$packetMD = this.packetMD;
        MessageDigest other$packetMD = other.packetMD;
        if (this$packetMD == null ? other$packetMD != null : !this$packetMD.equals(other$packetMD)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CompressionType this$compression = this.getCompression();
        CompressionType other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !((Object)((Object)this$compression)).equals((Object)other$compression)) {
            return false;
        }
        Level this$loggingLevel = this.getLoggingLevel();
        Level other$loggingLevel = other.getLoggingLevel();
        return !(this$loggingLevel == null ? other$loggingLevel != null : !((Object)this$loggingLevel).equals(other$loggingLevel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Protocol;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCompressionLevel();
        result = result * 59 + this.getMaxPacketSize();
        result = result * 59 + this.getMaxConnections();
        MessageDigest $packetMD = this.packetMD;
        result = result * 59 + ($packetMD == null ? 43 : $packetMD.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CompressionType $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : ((Object)((Object)$compression)).hashCode());
        Level $loggingLevel = this.getLoggingLevel();
        result = result * 59 + ($loggingLevel == null ? 43 : ((Object)$loggingLevel).hashCode());
        return result;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public CompressionType getCompression() {
        return this.compression;
    }

    @Generated
    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    @Generated
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    @Generated
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Generated
    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public static class Builder {
        private final Protocol protocol;

        private Class<?>[] getArgTypes(Object[] args) {
            Class[] types = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                types[i] = args[i].getClass();
            }
            return types;
        }

        public Builder setServerHandler(Class<? extends ProtoConnectionHandler> handler, Object ... args) {
            if (Modifier.isAbstract(handler.getModifiers())) {
                throw new IllegalArgumentException("Handler class cannot be abstract: " + String.valueOf(handler));
            }
            this.protocol.serverConnectionHandler = handler.getDeclaredConstructor(this.getArgTypes(args));
            this.protocol.serverConnectionHandlerArgs = args;
            return this;
        }

        public Builder setClientHandler(Class<? extends ProtoConnectionHandler> handler, Object ... args) {
            if (Modifier.isAbstract(handler.getModifiers())) {
                throw new IllegalArgumentException("Handler class cannot be abstract: " + String.valueOf(handler));
            }
            this.protocol.clientConnectionHandler = handler.getDeclaredConstructor(this.getArgTypes(args));
            this.protocol.clientConnectionHandlerArgs = args;
            return this;
        }

        public Builder setServerAuthHandler(Class<? extends ServerAuthHandler> handler, Object ... args) {
            if (Modifier.isAbstract(handler.getModifiers())) {
                throw new IllegalArgumentException("Handler class cannot be abstract: " + String.valueOf(handler));
            }
            this.protocol.serverAuthHandler = handler.getDeclaredConstructor(this.getArgTypes(args));
            this.protocol.serverAuthHandlerArgs = args;
            return this;
        }

        public Builder setClientAuthHandler(Class<? extends ClientAuthHandler> handler, Object ... args) {
            if (Modifier.isAbstract(handler.getModifiers())) {
                throw new IllegalArgumentException("Handler class cannot be abstract: " + String.valueOf(handler));
            }
            this.protocol.clientAuthHandler = handler.getDeclaredConstructor(this.getArgTypes(args));
            this.protocol.clientAuthHandlerArgs = args;
            return this;
        }

        public Builder addPacket(@NonNull Class<?> packet) {
            if (packet == null) {
                throw new NullPointerException("packet is marked non-null but is null");
            }
            this.protocol.serializer.register(packet);
            this.protocol.packetMD.update(packet.getName().getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public <T> Builder addPacket(@NonNull Class<T> packet, @NonNull Class<? extends ProtoSerializer<T>> serializer, Object ... args) {
            if (packet == null) {
                throw new NullPointerException("packet is marked non-null but is null");
            }
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            this.protocol.serializer.register(packet, serializer.getDeclaredConstructor(this.getArgTypes(args)).newInstance(args));
            this.protocol.packetMD.update(packet.getName().getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public Builder setCompression(@NonNull CompressionType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.protocol.compression = type;
            return this;
        }

        public Builder setCompressionLevel(int level) {
            this.protocol.compressionLevel = level;
            return this;
        }

        public Builder setMaxPacketSize(int maxPacketSize) {
            this.protocol.maxPacketSize = maxPacketSize;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.protocol.maxConnections = maxConnections;
            return this;
        }

        public Builder setLoggingLevel(Level level) {
            this.protocol.loggingLevel = level;
            return this;
        }

        public Protocol build() {
            if (this.protocol.compression != CompressionType.NONE && this.protocol.compressionLevel == -37) {
                this.protocol.compressionLevel = this.protocol.compression.getDefaultLevel();
            }
            return this.protocol;
        }

        public Protocol load() {
            ProtoWeaver.load(this.build());
            return this.protocol;
        }

        @Generated
        private Builder(Protocol protocol) {
            this.protocol = protocol;
        }
    }
}

