/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.core.protocol.protoweaver;

import me.mrnavastar.protoweaver.api.ProtoConnectionHandler;
import me.mrnavastar.protoweaver.api.ProtoWeaver;
import me.mrnavastar.protoweaver.api.auth.ClientAuthHandler;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.AuthStatus;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.InternalConnectionHandler;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.ProtocolStatus;

public class ClientConnectionHandler
extends InternalConnectionHandler
implements ProtoConnectionHandler {
    private Protocol protocol;
    private boolean authenticated = false;
    private ClientAuthHandler authHandler = null;

    public void start(ProtoConnection connection, Protocol protocol) {
        this.protocol = protocol;
        this.authenticated = false;
        if (protocol.requiresAuth(Side.CLIENT)) {
            this.authHandler = protocol.newClientAuthHandler();
        }
        connection.send(new ProtocolStatus(connection.getProtocol().toString(), protocol.toString(), protocol.getSHA1(), ProtocolStatus.Status.START));
    }

    @Override
    public void handlePacket(ProtoConnection connection, Object packet) {
        if (packet instanceof ProtocolStatus) {
            ProtocolStatus status = (ProtocolStatus)packet;
            switch (status.getStatus()) {
                case MISSING: {
                    this.protocol.logErr("Not loaded on server: " + String.valueOf(connection.getRemoteAddress()));
                    this.disconnectIfNeverUpgraded(connection);
                    break;
                }
                case MISMATCH: {
                    this.protocol.logErr("Mismatch with protocol version on server: " + String.valueOf(connection.getRemoteAddress()));
                    this.protocol.logErr("Double check that all packets are registered in the same order and all settings are the same");
                    this.disconnectIfNeverUpgraded(connection);
                    break;
                }
                case FULL: {
                    this.protocol.logErr("The maximum number of allowed connections on server: " + String.valueOf(connection.getRemoteAddress()) + " has been reached!");
                    this.disconnectIfNeverUpgraded(connection);
                    break;
                }
                case UPGRADE: {
                    if (!"1.4.8".equals(status.getProtoweaverVersion())) {
                        this.protocol.logWarn("Connecting with ProtoWeaver version: " + status.getProtoweaverVersion() + ", but server is running: 1.4.8. There could be unexpected issues");
                    }
                    if (!this.authenticated) {
                        return;
                    }
                    this.protocol = ProtoWeaver.getLoadedProtocol(status.getNextProtocol());
                    if (this.protocol == null) {
                        this.protocolNotLoaded(connection, status.getNextProtocol());
                        return;
                    }
                    connection.upgradeProtocol(this.protocol);
                    this.protocol.logInfo("Connected to: " + String.valueOf(connection.getRemoteAddress()));
                }
            }
            return;
        }
        if (packet instanceof AuthStatus) {
            AuthStatus auth = (AuthStatus)((Object)packet);
            switch (auth) {
                case OK: {
                    this.authenticated = true;
                    break;
                }
                case REQUIRED: {
                    if (this.authHandler == null) {
                        this.protocol.logErr("Client protocol has not defined an auth handler, but the server at: " + String.valueOf(connection.getRemoteAddress()) + " requires auth. Closing connection");
                        connection.disconnect();
                        return;
                    }
                    connection.send(this.authHandler.getSecret());
                    break;
                }
                case DENIED: {
                    this.protocol.logErr("Denied access by server at: " + String.valueOf(connection.getRemoteAddress()));
                    this.disconnectIfNeverUpgraded(connection);
                }
            }
        }
    }

    @Override
    public void onDisconnect(ProtoConnection connection) {
        if (this.wasUpgraded(connection)) {
            this.protocol.logInfo("Disconnected from: " + String.valueOf(connection.getRemoteAddress()));
        }
    }
}

