/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.loader;

import java.nio.charset.StandardCharsets;
import me.mrnavastar.protoweaver.api.ProtoWeaver;
import me.mrnavastar.protoweaver.api.protocol.velocity.VelocityAuth;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;
import me.mrnavastar.protoweaver.loader.netty.SSLContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import org.adde0109.pcf.v1_14_4.forge.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="protoweaver")
public class Forge
implements ProtoLogger.IProtoLogger {
    private final Logger logger = LogManager.getLogger();
    private boolean setup = false;

    public Forge() {
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
    }

    private void serverStarted(FMLDedicatedServerSetupEvent event) {
        if (!ProtoWeaver.getLoadedProtocols().isEmpty()) {
            this.setup();
        } else {
            ProtoWeaver.PROTOCOL_LOADED.register(protocol -> this.setup());
        }
    }

    private void setup() {
        if (this.setup) {
            return;
        }
        ProtoLogger.setLogger(this);
        SSLContext.init(FMLConfig.defaultConfigPath() + "/protoweaver");
        if (FMLLoader.getLoadingModList().getModFileById("proxy-compatible-forge") != null) {
            VelocityAuth.setSecret(((String)Config.config.forwardingSecret.get()).getBytes(StandardCharsets.UTF_8));
        }
        this.setup = true;
    }

    @Override
    public void info(String message) {
        this.logger.info("[ProtoWeaver]: {}", (Object)message);
    }

    @Override
    public void warn(String message) {
        this.logger.info("[ProtoWeaver]: {}", (Object)message);
    }

    @Override
    public void err(String message) {
        this.logger.info("[ProtoWeaver]: {}", (Object)message);
    }
}

