/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.loader.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class Http2ServerResponseHandler
extends ChannelDuplexHandler {
    static final ByteBuf RESPONSE_BYTES = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.UTF_8));

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame msgHeader = (Http2HeadersFrame)msg;
            if (msgHeader.isEndStream()) {
                ByteBuf content = ctx.alloc().buffer();
                content.writeBytes(RESPONSE_BYTES.duplicate());
                Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());
                ctx.write((Object)new DefaultHttp2HeadersFrame(headers).stream(msgHeader.stream()));
                ctx.write((Object)new DefaultHttp2DataFrame(content, true).stream(msgHeader.stream()));
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

