/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.loader.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import java.util.Map;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.InternalConnectionHandler;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;
import me.mrnavastar.protoweaver.loader.netty.SSLContext;

public class ProtoDeterminer
extends ByteToMessageDecoder {
    private final boolean sslEnabled;

    public ProtoDeterminer() {
        this.sslEnabled = false;
    }

    public ProtoDeterminer(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public static void registerToPipeline(Channel channel) {
        channel.pipeline().addFirst("protoDeterminer", (ChannelHandler)new ProtoDeterminer());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> list) {
        short magic2;
        if (buf.readableBytes() < 5) {
            return;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        short magic1 = buf.getUnsignedByte(buf.readerIndex());
        if (this.isMinecraft(magic1, magic2 = buf.getUnsignedByte(buf.readerIndex() + 1))) {
            pipeline.remove((ChannelHandler)this);
            return;
        }
        if (!this.sslEnabled) {
            for (Map.Entry handler : pipeline.toMap().entrySet()) {
                if (((String)handler.getKey()).equals("protoDeterminer")) continue;
                pipeline.remove((ChannelHandler)handler.getValue());
            }
        }
        if (SSLContext.getContext() != null && this.enableSSL(buf)) {
            pipeline.addLast("ssl", (ChannelHandler)SSLContext.getContext().newHandler(ctx.alloc()));
            pipeline.addLast("sslProtoDeterminer", (ChannelHandler)new ProtoDeterminer(true));
            pipeline.remove((ChannelHandler)this);
            return;
        }
        if (this.isProtoWeaver(magic1, magic2)) {
            if (!this.sslEnabled) {
                ctx.close();
                return;
            }
            new ProtoConnection(InternalConnectionHandler.getProtocol(), Side.SERVER, ctx.channel());
            buf.readerIndex(2);
            pipeline.remove((ChannelHandler)this);
            return;
        }
        ctx.close();
    }

    private boolean isMinecraft(int magic1, int magic2) {
        return magic1 > 0 && magic2 == 0;
    }

    private boolean enableSSL(ByteBuf buf) {
        if (this.sslEnabled) {
            return false;
        }
        return SslHandler.isEncrypted((ByteBuf)buf);
    }

    private boolean isProtoWeaver(int magic1, int magic2) {
        return magic1 == 0 && magic2 == 99;
    }

    private boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ProtoLogger.warn("Client rejected ssl certificate. Closing connection");
        ctx.close();
    }
}

