/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.api;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.api.util.Event;

public class ProtoWeaver {
    private static final ConcurrentHashMap<String, Protocol> loadedProtocols = new ConcurrentHashMap();
    public static final Event<PreLoadedProtocol> PRE_PROTOCOL_LOADED = new Event<PreLoadedProtocol>(callbacks -> (protocol, cancelable) -> {
        for (PreLoadedProtocol callback : callbacks) {
            if (cancelable.isCanceled() && !protocol.getNamespace().equals("protoweaver") && !protocol.getName().equals("internal")) break;
            callback.trigger(protocol, cancelable);
        }
    });
    public static final Event<LoadedProtocol> PROTOCOL_LOADED = new Event<LoadedProtocol>(callbacks -> protocol -> callbacks.forEach(callback -> callback.trigger(protocol)));

    public static void load(@NonNull Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        if (loadedProtocols.containsKey(protocol.toString())) {
            return;
        }
        Event.Cancelable cancelable = new Event.Cancelable();
        PRE_PROTOCOL_LOADED.getInvoker().trigger(protocol, cancelable);
        if (cancelable.isCanceled()) {
            return;
        }
        loadedProtocols.put(protocol.toString(), protocol);
        PROTOCOL_LOADED.getInvoker().trigger(protocol);
    }

    public static List<Protocol> getLoadedProtocols() {
        return loadedProtocols.values().stream().toList();
    }

    public static Protocol getLoadedProtocol(@NonNull String namespaceAndName) {
        if (namespaceAndName == null) {
            throw new NullPointerException("namespaceAndName is marked non-null but is null");
        }
        return loadedProtocols.get(namespaceAndName);
    }

    public static Protocol getLoadedProtocol(@NonNull String namespace, @NonNull String name) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ProtoWeaver.getLoadedProtocol(namespace + ":" + name);
    }

    @FunctionalInterface
    public static interface PreLoadedProtocol {
        public void trigger(Protocol var1, Event.Cancelable var2);
    }

    @FunctionalInterface
    public static interface LoadedProtocol {
        public void trigger(Protocol var1);
    }
}

