/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.api.netty;

import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import me.mrnavastar.protoweaver.api.ProtoConnectionHandler;
import me.mrnavastar.protoweaver.api.netty.Sender;
import me.mrnavastar.protoweaver.api.protocol.CompressionType;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.core.netty.ProtoPacketHandler;
import me.mrnavastar.protoweaver.libs.io.netty.channel.Channel;
import me.mrnavastar.protoweaver.libs.io.netty.channel.ChannelHandler;
import me.mrnavastar.protoweaver.libs.io.netty.channel.ChannelPipeline;
import me.mrnavastar.protoweaver.libs.io.netty.handler.codec.compression.FastLzFrameDecoder;
import me.mrnavastar.protoweaver.libs.io.netty.handler.codec.compression.FastLzFrameEncoder;
import me.mrnavastar.protoweaver.libs.io.netty.handler.codec.compression.SnappyFrameDecoder;
import me.mrnavastar.protoweaver.libs.io.netty.handler.codec.compression.SnappyFrameEncoder;
import me.mrnavastar.protoweaver.libs.io.netty.handler.codec.compression.ZlibCodecFactory;
import me.mrnavastar.protoweaver.libs.io.netty.handler.codec.compression.ZlibWrapper;

public class ProtoConnection {
    private static final ConcurrentHashMap<String, Integer> connectionCount = new ConcurrentHashMap();
    private final ProtoPacketHandler packetHandler;
    private final Channel channel;
    private final ChannelPipeline pipeline;
    private ProtoConnectionHandler handler;
    private Protocol protocol;
    private final Side side;
    private Side disconnecter;

    public ProtoConnection(@NonNull Protocol protocol, @NonNull Side side, @NonNull Channel channel) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        if (side == null) {
            throw new NullPointerException("side is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.side = side;
        this.disconnecter = Side.SERVER == side ? Side.CLIENT : Side.SERVER;
        this.protocol = protocol;
        this.handler = protocol.newConnectionHandler(side);
        this.packetHandler = new ProtoPacketHandler(this, connectionCount);
        this.packetHandler.setHandler(this.handler);
        this.channel = channel;
        this.pipeline = channel.pipeline();
        this.pipeline.addLast("packetHandler", (ChannelHandler)this.packetHandler);
        this.setCompression(protocol);
    }

    private void setCompression(@NonNull Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        CompressionType compression = this.protocol.getCompression();
        if (protocol.getCompression().equals((Object)compression)) {
            return;
        }
        if (this.pipeline.names().contains("compressionEncoder")) {
            this.pipeline.remove("compressionEncoder");
            this.pipeline.remove("compressionDecoder");
        }
        int level = protocol.getCompressionLevel();
        switch (protocol.getCompression()) {
            case GZIP: {
                this.pipeline.addBefore("packetHandler", "compressionEncoder", ZlibCodecFactory.newZlibEncoder(ZlibWrapper.GZIP, level));
                this.pipeline.addAfter("compressionEncoder", "compressionDecoder", ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
                break;
            }
            case SNAPPY: {
                this.pipeline.addBefore("packetHandler", "compressionEncoder", new SnappyFrameEncoder());
                this.pipeline.addAfter("compressionEncoder", "compressionDecoder", new SnappyFrameDecoder());
                break;
            }
            case FAST_LZ: {
                this.pipeline.addBefore("packetHandler", "compressionEncoder", new FastLzFrameEncoder(level));
                this.pipeline.addAfter("compressionEncoder", "compressionDecoder", new FastLzFrameDecoder());
            }
        }
    }

    public void upgradeProtocol(@NonNull Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        try {
            this.setCompression(protocol);
            this.handler = protocol.newConnectionHandler(this.side);
            connectionCount.put(protocol.toString(), connectionCount.getOrDefault(protocol.toString(), 1) - 1);
            this.protocol = protocol;
            connectionCount.put(protocol.toString(), connectionCount.getOrDefault(protocol.toString(), 0) + 1);
            this.packetHandler.setHandler(this.handler);
            this.handler.onReady(this);
        }
        catch (Exception e) {
            protocol.logErr("Threw an error on initialization!");
            e.printStackTrace();
        }
    }

    public static int getConnectionCount(Protocol protocol) {
        return connectionCount.getOrDefault(protocol.toString(), 0);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public Sender send(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return this.packetHandler.send(packet);
    }

    public void disconnect() {
        if (this.isOpen()) {
            this.channel.close();
        }
        this.disconnecter = this.side;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProtoConnection)) {
            return false;
        }
        ProtoConnection connection = (ProtoConnection)obj;
        return this.protocol.equals(connection.getProtocol()) && Objects.equals(this.getRemoteAddress(), connection.getRemoteAddress());
    }

    public String toString() {
        return "[" + this.protocol.toString() + ", " + String.valueOf(this.getRemoteAddress()) + "]";
    }

    @Generated
    public ProtoConnectionHandler getHandler() {
        return this.handler;
    }

    @Generated
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public Side getSide() {
        return this.side;
    }

    @Generated
    public Side getDisconnecter() {
        return this.disconnecter;
    }
}

