/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.net.ssl.SSLException;
import lombok.Generated;
import lombok.NonNull;
import me.mrnavastar.protoweaver.api.ProtoWeaver;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.netty.Sender;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.client.netty.ProtoTrustManager;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.ClientConnectionHandler;
import me.mrnavastar.protoweaver.core.protocol.protoweaver.InternalConnectionHandler;
import me.mrnavastar.protoweaver.libs.com.google.common.base.internal.Finalizer;
import me.mrnavastar.protoweaver.libs.io.netty.bootstrap.Bootstrap;
import me.mrnavastar.protoweaver.libs.io.netty.channel.ChannelFuture;
import me.mrnavastar.protoweaver.libs.io.netty.channel.ChannelHandler;
import me.mrnavastar.protoweaver.libs.io.netty.channel.ChannelInitializer;
import me.mrnavastar.protoweaver.libs.io.netty.channel.ChannelOption;
import me.mrnavastar.protoweaver.libs.io.netty.channel.EventLoopGroup;
import me.mrnavastar.protoweaver.libs.io.netty.channel.nio.NioEventLoopGroup;
import me.mrnavastar.protoweaver.libs.io.netty.channel.socket.SocketChannel;
import me.mrnavastar.protoweaver.libs.io.netty.channel.socket.nio.NioSocketChannel;
import me.mrnavastar.protoweaver.libs.io.netty.handler.ssl.SslContext;
import me.mrnavastar.protoweaver.libs.io.netty.handler.ssl.SslContextBuilder;

public class ProtoClient {
    private final InetSocketAddress address;
    private EventLoopGroup workerGroup = null;
    private ProtoConnection connection = null;
    private final SslContext sslContext;
    private final ArrayList<ConnectionEstablishedHandler> connectionEstablishedHandlers = new ArrayList();
    private final ArrayList<ConnectionLostHandler> connectionLostHandlers = new ArrayList();

    public ProtoClient(@NonNull InetSocketAddress address, @NonNull String hostsFile) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (hostsFile == null) {
            throw new NullPointerException("hostsFile is marked non-null but is null");
        }
        try {
            this.address = address;
            ProtoTrustManager trustManager = new ProtoTrustManager(address.getHostName(), address.getPort(), hostsFile);
            this.sslContext = SslContextBuilder.forClient().trustManager(trustManager.getTm()).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    public ProtoClient(@NonNull InetSocketAddress address) {
        this(address.getHostName(), address.getPort());
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
    }

    public ProtoClient(@NonNull String host, int port, @NonNull String hostsFile) {
        this(new InetSocketAddress(host, port), hostsFile);
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (hostsFile == null) {
            throw new NullPointerException("hostsFile is marked non-null but is null");
        }
    }

    public ProtoClient(@NonNull String host, int port) {
        this(host, port, ".");
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
    }

    public ProtoClient connect(@NonNull Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        ProtoWeaver.load(protocol);
        Bootstrap b = new Bootstrap();
        this.workerGroup = new NioEventLoopGroup();
        b.group(this.workerGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, true);
        b.option(ChannelOption.TCP_NODELAY, true);
        b.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(@NonNull SocketChannel ch) throws Exception {
                if (ch == null) {
                    throw new NullPointerException("ch is marked non-null but is null");
                }
                ch.pipeline().addLast("ssl", (ChannelHandler)ProtoClient.this.sslContext.newHandler(ch.alloc(), ProtoClient.this.address.getHostName(), ProtoClient.this.address.getPort()));
                ProtoClient.this.connection = new ProtoConnection(InternalConnectionHandler.getProtocol(), Side.CLIENT, ch);
            }
        });
        ChannelFuture f = b.connect(this.address);
        new Thread(() -> {
            try {
                f.awaitUninterruptibly();
                if (f.isSuccess()) {
                    ((ClientConnectionHandler)this.connection.getHandler()).start(this.connection, protocol);
                    while (this.connection == null || this.connection.isOpen() && !this.connection.getProtocol().toString().equals(protocol.toString())) {
                        Thread.onSpinWait();
                    }
                    if (this.connection.isOpen()) {
                        this.connectionEstablishedHandlers.forEach(handler -> {
                            try {
                                handler.handle(this.connection);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                }
                f.channel().closeFuture().sync();
                this.connectionLostHandlers.forEach(handler -> {
                    try {
                        handler.handle(this.connection);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                this.connection = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.disconnect();
            }
        }).start();
        return this;
    }

    public boolean isConnected() {
        return !this.workerGroup.isShutdown() || !this.workerGroup.isShuttingDown() || this.connection != null && this.connection.isOpen();
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        if (this.workerGroup != null && !this.workerGroup.isShutdown()) {
            this.workerGroup.shutdownGracefully();
        }
    }

    public ProtoClient onConnectionEstablished(@NonNull ConnectionEstablishedHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.connectionEstablishedHandlers.add(handler);
        return this;
    }

    public ProtoClient onConnectionLost(@NonNull ConnectionLostHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.connectionLostHandlers.add(handler);
        return this;
    }

    public Sender send(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (this.connection != null) {
            return this.connection.send(packet);
        }
        return Sender.NULL;
    }

    public Protocol getCurrentProtocol() {
        return this.connection == null ? null : this.connection.getProtocol();
    }

    @Generated
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Generated
    public ProtoConnection getConnection() {
        return this.connection;
    }

    static {
        Class<Finalizer> clazz = Finalizer.class;
    }

    @FunctionalInterface
    public static interface ConnectionLostHandler {
        public void handle(ProtoConnection var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ConnectionEstablishedHandler {
        public void handle(ProtoConnection var1) throws Exception;
    }
}

