/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.client.netty;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import me.mrnavastar.protoweaver.libs.io.netty.util.concurrent.FastThreadLocal;
import me.mrnavastar.protoweaver.libs.io.netty.util.internal.EmptyArrays;
import me.mrnavastar.protoweaver.libs.io.netty.util.internal.StringUtil;

public class ProtoTrustManager {
    private final File hostsFile;
    private static final FastThreadLocal<MessageDigest> tlmd = new FastThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Unsupported hash algorithm", e);
            }
        }
    };
    private final String hostId;
    private byte[] trusted = null;
    private final TrustManager tm = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s2) {
            this.checkTrusted(chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s2) {
            this.checkTrusted(chain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTrusted(X509Certificate[] chain) {
            MessageDigest md = tlmd.get();
            md.reset();
            byte[] fingerprint = md.digest(chain[0].getEncoded());
            if (ProtoTrustManager.this.trusted == null) {
                ProtoTrustManager.this.hostsFile.getParentFile().mkdirs();
                ProtoTrustManager.this.hostsFile.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(ProtoTrustManager.this.hostsFile, true));
                try {
                    writer.append(ProtoTrustManager.this.hostId).append("=").append(StringUtil.toHexString(fingerprint)).append("\n");
                    ProtoTrustManager.this.trusted = fingerprint;
                    return;
                }
                finally {
                    if (Collections.singletonList(writer).get(0) != null) {
                        writer.close();
                    }
                }
            }
            if (Arrays.equals(ProtoTrustManager.this.trusted, fingerprint)) {
                return;
            }
            throw new CertificateException("protoweaver-client-cert-error:" + ProtoTrustManager.this.hostId + ":" + StringUtil.toHexString(ProtoTrustManager.this.trusted) + "!=" + StringUtil.toHexString(fingerprint));
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };

    public ProtoTrustManager(String host, int port, String file) {
        this.hostsFile = new File(file + File.separator + "protoweaver.hosts");
        this.hostId = host + ":" + port;
        if (!this.hostsFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.hostsFile));){
            reader.lines().filter(l -> l.startsWith(host + ":" + port)).findFirst().ifPresent(l -> {
                this.trusted = StringUtil.decodeHexDump(l.split("=")[1]);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public TrustManager getTm() {
        return this.tm;
    }
}

