/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.core.netty;

import java.net.SocketException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import me.mrnavastar.protoweaver.api.ProtoConnectionHandler;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.netty.Sender;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.core.util.DrunkenBishop;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;
import me.mrnavastar.protoweaver.libs.io.netty.buffer.ByteBuf;
import me.mrnavastar.protoweaver.libs.io.netty.buffer.Unpooled;
import me.mrnavastar.protoweaver.libs.io.netty.channel.ChannelHandlerContext;
import me.mrnavastar.protoweaver.libs.io.netty.handler.codec.ByteToMessageDecoder;

public class ProtoPacketHandler
extends ByteToMessageDecoder {
    private static ConcurrentHashMap<String, Integer> connectionCount;
    private final ProtoConnection connection;
    private ProtoConnectionHandler handler;
    private ChannelHandlerContext ctx;
    private ByteBuf buf = Unpooled.buffer();

    public ProtoPacketHandler(ProtoConnection connection, ConcurrentHashMap<String, Integer> connectionCount) {
        this.connection = connection;
        ProtoPacketHandler.connectionCount = connectionCount;
        if (connection.getSide().equals((Object)Side.CLIENT)) {
            this.buf.writeByte(0);
            this.buf.writeByte(99);
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        try {
            connectionCount.put(this.connection.getProtocol().toString(), connectionCount.getOrDefault(this.connection.getProtocol().toString(), 1) - 1);
            this.handler.onDisconnect(this.connection);
        }
        catch (Exception e) {
            this.connection.getProtocol().logErr("Threw an error on disconnect!");
            e.printStackTrace();
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.readableBytes() < 4) {
            return;
        }
        byteBuf.markReaderIndex();
        int packetLen = byteBuf.readInt();
        if (byteBuf.readableBytes() < packetLen) {
            byteBuf.resetReaderIndex();
            return;
        }
        Object packet = null;
        try {
            byte[] bytes = new byte[packetLen];
            byteBuf.readBytes(bytes);
            packet = this.connection.getProtocol().deserialize(bytes);
            this.handler.handlePacket(this.connection, packet);
        }
        catch (IllegalArgumentException e) {
            this.connection.getProtocol().logWarn("Ignoring an " + e.getMessage());
        }
        catch (Exception e) {
            if (packet != null) {
                this.connection.getProtocol().logErr("Threw an error when trying to handle: " + String.valueOf(packet.getClass()) + "!");
            }
            e.printStackTrace();
        }
    }

    public Sender send(Object packet) {
        try {
            byte[] packetBuf = this.connection.getProtocol().serialize(packet);
            if (packetBuf.length == 0) {
                return new Sender(this.connection, this.ctx.newSucceededFuture(), false);
            }
            this.buf.writeInt(packetBuf.length);
            this.buf.writeBytes(packetBuf);
            Sender sender = new Sender(this.connection, this.ctx.writeAndFlush(this.buf), true);
            this.buf = Unpooled.buffer();
            return sender;
        }
        catch (IllegalArgumentException e) {
            this.connection.getProtocol().logErr("Tried to send an " + e.getMessage());
            return new Sender(this.connection, this.ctx.newSucceededFuture(), false);
        }
        catch (Exception e) {
            this.connection.getProtocol().logErr("Threw an error when trying to send: " + String.valueOf(packet.getClass()) + "!");
            e.printStackTrace();
            return new Sender(this.connection, this.ctx.newSucceededFuture(), false);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String message = cause.getMessage();
        String[] parts = message.split(":");
        if (parts[1].contains("protoweaver-client-cert-error")) {
            String[] fingerprints = parts[4].split("!=");
            ProtoLogger.warn(" Saved Fingerprint:     Server Fingerprint:");
            String images = DrunkenBishop.inlineImages(DrunkenBishop.parse(fingerprints[0]), DrunkenBishop.parse(fingerprints[1]));
            for (String line : images.split("\n")) {
                ProtoLogger.warn(line);
            }
            ProtoLogger.err("Failed to connect to: " + parts[2] + ":" + parts[3]);
            ProtoLogger.err("Server SSL fingerprint does not match saved fingerprint! This could be a MITM ATTACK!");
            ProtoLogger.err(" - https://en.wikipedia.org/wiki/Man-in-the-middle_attack");
            ProtoLogger.err("If you've reset your server configuration recently, you can probably ignore this and reset/remove the \"protoweaver.hosts\" file.");
            ctx.close();
            this.connection.disconnect();
        }
        if (cause instanceof SocketException) {
            ctx.close();
            this.connection.disconnect();
        }
    }

    @Generated
    public void setHandler(ProtoConnectionHandler handler) {
        this.handler = handler;
    }
}

