/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import me.mrnavastar.protoweaver.api.ProtoSerializer;
import me.mrnavastar.protoweaver.libs.me.mrnavastar.r.R;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.config.CompatibleMode;
import me.mrnavastar.protoweaver.libs.org.apache.fury.config.Language;
import me.mrnavastar.protoweaver.libs.org.apache.fury.exception.InsecureException;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.LoggerFactory;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;

public class ObjectSerializer {
    private final Fury fury = Fury.builder().withJdkClassSerializableCheck(false).withDeserializeNonexistentClass(false).withLanguage(Language.JAVA).withCompatibleMode(CompatibleMode.COMPATIBLE).withAsyncCompilation(true).withClassLoader(ProtoSerializer.class.getClassLoader()).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveRegister(Class<?> type, List<Class<?>> registered) {
        if (type == null || type == Object.class || registered.contains(type) || Modifier.isAbstract(type.getModifiers())) {
            return;
        }
        Fury fury = this.fury;
        synchronized (fury) {
            this.fury.register(type);
        }
        registered.add(type);
        List.of(type.getDeclaredFields()).forEach(field -> this.recursiveRegister(field.getType(), registered));
        List.of(R.of(type).generics()).forEach(t2 -> this.recursiveRegister((Class<?>)t2, registered));
        if (!type.isEnum()) {
            this.recursiveRegister(type.getSuperclass(), registered);
        }
    }

    public void register(Class<?> type) {
        this.recursiveRegister(type, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(Class<T> type, ProtoSerializer<T> serializer) {
        Fury fury = this.fury;
        synchronized (fury) {
            this.fury.registerSerializer(type, new SerializerAdapter<T>(this.fury, type, serializer));
        }
    }

    public byte[] serialize(Object object) throws IllegalArgumentException {
        Fury fury = this.fury;
        synchronized (fury) {
            try {
                return this.fury.serialize(object);
            }
            catch (InsecureException e) {
                throw new IllegalArgumentException("unregistered object: " + object.getClass().getName());
            }
        }
    }

    public Object deserialize(byte[] bytes) throws IllegalArgumentException {
        Fury fury = this.fury;
        synchronized (fury) {
            try {
                return this.fury.deserialize(bytes);
            }
            catch (InsecureException e) {
                String packet = e.getMessage().split(" is not registered")[0].replace("class ", "");
                throw new IllegalArgumentException("unregistered object: " + packet);
            }
        }
    }

    static {
        LoggerFactory.disableLogging();
    }

    private static class SerializerAdapter<T>
    extends Serializer<T> {
        private final ProtoSerializer<T> serializer;

        public SerializerAdapter(Fury fury, Class<T> type, ProtoSerializer<T> serializer) {
            super(fury, type);
            this.serializer = serializer;
        }

        @Override
        public T read(MemoryBuffer buffer) {
            ByteArrayInputStream in = new ByteArrayInputStream(buffer.getRemainingBytes());
            return this.serializer.read(in);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.serializer.write(out, value);
            buffer.writeBytes(out.toByteArray());
        }
    }
}

