/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.CodeGenerator;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.CodegenContext;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.CompileUnit;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.JaninoUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.Logger;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.LoggerFactory;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.Descriptor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.ClassLoaderUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.StringUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.record.RecordUtils;

public class AccessorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AccessorHelper.class);
    private static final WeakHashMap<Class<?>, Boolean> defineAccessorStatus = new WeakHashMap();
    private static final WeakHashMap<Class<?>, Object> defineAccessorLock = new WeakHashMap();
    private static final Object defineLock = new Object();
    private static final String OBJ_NAME = "obj";
    private static final String FIELD_VALUE = "fieldValue";
    private static final Map<String, Integer> idGenerator = new ConcurrentHashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String accessorClassName(Class<?> beanClass) {
        String key = CodeGenerator.getClassUniqueId(beanClass);
        Integer id = idGenerator.get(key);
        if (id == null) {
            Map<String, Integer> map = idGenerator;
            synchronized (map) {
                id = idGenerator.computeIfAbsent(key, k -> idGenerator.size());
            }
        }
        String name = ReflectionUtils.getClassNameWithoutPackage(beanClass) + "FuryAccessor_" + id;
        return name.replace("$", "_");
    }

    public static String qualifiedAccessorClassName(Class<?> beanClass) {
        String pkgName = CodeGenerator.getPackage(beanClass);
        if (StringUtils.isNotBlank(pkgName)) {
            return pkgName + "." + AccessorHelper.accessorClassName(beanClass);
        }
        return AccessorHelper.accessorClassName(beanClass);
    }

    public static String genCode(Class<?> beanClass) {
        CodegenContext ctx = new CodegenContext();
        ctx.setPackage(CodeGenerator.getPackage(beanClass));
        String className = AccessorHelper.accessorClassName(beanClass);
        ctx.setClassName(className);
        boolean isRecord = RecordUtils.isRecord(beanClass);
        Collection<Descriptor> descriptors = Descriptor.getAllDescriptorsMap(beanClass, false).values();
        for (Descriptor descriptor : descriptors) {
            if (Modifier.isPrivate(descriptor.getModifiers())) continue;
            boolean accessible = CodeGenerator.sourcePkgLevelAccessible(descriptor.getRawType());
            String methodName = descriptor.getName();
            Class returnType = accessible ? descriptor.getRawType() : Object.class;
            String codeBody = isRecord ? StringUtils.format("return ${obj}.${fieldName}();", OBJ_NAME, OBJ_NAME, "fieldName", descriptor.getName()) : StringUtils.format("return ${obj}.${fieldName};", OBJ_NAME, OBJ_NAME, "fieldName", descriptor.getName());
            ctx.addStaticMethod(methodName, codeBody, returnType, beanClass, OBJ_NAME);
            if (!accessible) continue;
            methodName = descriptor.getName();
            codeBody = StringUtils.format("${obj}.${fieldName} = ${fieldValue};", OBJ_NAME, OBJ_NAME, "fieldName", descriptor.getName(), FIELD_VALUE, FIELD_VALUE);
            ctx.addStaticMethod(methodName, codeBody, Void.TYPE, beanClass, OBJ_NAME, descriptor.getRawType(), FIELD_VALUE);
        }
        return ctx.genCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean defineAccessorClass(Class<?> beanClass) {
        ClassLoader classLoader = beanClass.getClassLoader();
        if (classLoader == null) {
            return false;
        }
        String qualifiedClassName = AccessorHelper.qualifiedAccessorClassName(beanClass);
        try {
            classLoader.loadClass(qualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            Object lock;
            Object object = defineLock;
            synchronized (object) {
                if (defineAccessorStatus.containsKey(beanClass)) {
                    return defineAccessorStatus.get(beanClass);
                }
                lock = AccessorHelper.getDefineLock(beanClass);
            }
            object = lock;
            synchronized (object) {
                if (defineAccessorStatus.containsKey(beanClass)) {
                    return defineAccessorStatus.get(beanClass);
                }
                long startTime = System.nanoTime();
                String code = AccessorHelper.genCode(beanClass);
                long durationMs = (System.nanoTime() - startTime) / 1000000L;
                LOG.info("Generate code {} take {} ms", (Object)qualifiedClassName, (Object)durationMs);
                String pkg = CodeGenerator.getPackage(beanClass);
                CompileUnit compileUnit = new CompileUnit(pkg, AccessorHelper.accessorClassName(beanClass), code);
                Map<String, byte[]> classByteCodes = JaninoUtils.toBytecode(classLoader, compileUnit);
                boolean succeed = ClassLoaderUtils.tryDefineClassesInClassLoader(qualifiedClassName, beanClass, classLoader, classByteCodes.values().iterator().next()) != null;
                defineAccessorStatus.put(beanClass, succeed);
                if (!succeed) {
                    LOG.info("Define accessor {} in classloader {} failed.", (Object)qualifiedClassName, (Object)classLoader);
                }
                return succeed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDefineLock(Class<?> clazz) {
        Object object = defineLock;
        synchronized (object) {
            return defineAccessorLock.computeIfAbsent(clazz, k -> new Object());
        }
    }

    public static Class<?> getAccessorClass(Class<?> beanClass) {
        Preconditions.checkArgument(AccessorHelper.defineAccessorClass(beanClass));
        ClassLoader classLoader = beanClass.getClassLoader();
        String qualifiedClassName = AccessorHelper.qualifiedAccessorClassName(beanClass);
        try {
            return classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("unreachable code", e);
        }
    }

    public static Class<?> getAccessorClass(Field field) {
        Class<?> beanClass = field.getDeclaringClass();
        return AccessorHelper.getAccessorClass(beanClass);
    }

    public static Class<?> getAccessorClass(Method method) {
        Class<?> beanClass = method.getDeclaringClass();
        return AccessorHelper.getAccessorClass(beanClass);
    }

    public static boolean defineAccessor(Field field) {
        Class<?> beanClass = field.getDeclaringClass();
        return AccessorHelper.defineAccessorClass(beanClass);
    }

    public static boolean defineAccessor(Method method) {
        Class<?> beanClass = method.getDeclaringClass();
        return AccessorHelper.defineAccessorClass(beanClass);
    }

    public static boolean defineSetter(Field field) {
        if (ReflectionUtils.isPrivate(field.getType()) || !CodeGenerator.sourcePkgLevelAccessible(field.getType())) {
            return false;
        }
        Class<?> beanClass = field.getDeclaringClass();
        return AccessorHelper.defineAccessorClass(beanClass);
    }

    public static boolean defineSetter(Method method) {
        if (ReflectionUtils.isPrivate(method.getReturnType()) || !CodeGenerator.sourcePkgLevelAccessible(method.getReturnType())) {
            return false;
        }
        Class<?> beanClass = method.getDeclaringClass();
        return AccessorHelper.defineAccessorClass(beanClass);
    }
}

