/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.builder.CodecBuilder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.builder.Generated;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.Code;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.CodeGenerator;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.CodegenContext;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.Expression;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.ExpressionOptimizer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.ExpressionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.ExpressionVisitor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple2;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.TypeRef;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassInfo;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassInfoHolder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.RefResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.CodegenSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.CompatibleSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.EnumSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.ObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.PrimitiveSerializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.StringSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.AbstractCollectionSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.AbstractMapSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.CollectionFlags;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.MapFlags;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.TypeUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.GraalvmSupport;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.StringUtils;

public abstract class BaseObjectCodecBuilder
extends CodecBuilder {
    public static final String BUFFER_NAME = "buffer";
    public static final String REF_RESOLVER_NAME = "refResolver";
    public static final String CLASS_RESOLVER_NAME = "classResolver";
    public static final String POJO_CLASS_TYPE_NAME = "classType";
    public static final String STRING_SERIALIZER_NAME = "strSerializer";
    private static final TypeRef<?> CLASS_RESOLVER_TYPE_TOKEN = TypeRef.of(ClassResolver.class);
    private static final TypeRef<?> STRING_SERIALIZER_TYPE_TOKEN = TypeRef.of(StringSerializer.class);
    private static final TypeRef<?> SERIALIZER_TYPE = TypeRef.of(Serializer.class);
    private static final TypeRef<?> COLLECTION_SERIALIZER_TYPE = TypeRef.of(AbstractCollectionSerializer.class);
    private static final TypeRef<?> MAP_SERIALIZER_TYPE = TypeRef.of(AbstractMapSerializer.class);
    protected final Expression.Reference refResolverRef;
    protected final Expression.Reference classResolverRef = Expression.Reference.fieldRef("classResolver", CLASS_RESOLVER_TYPE_TOKEN);
    protected final Fury fury;
    protected final ClassResolver classResolver;
    protected final Expression.Reference stringSerializerRef;
    private final Map<Class<?>, Expression.Reference> serializerMap = new HashMap();
    private final Map<String, Object> sharedFieldMap = new HashMap<String, Object>();
    protected final Class<?> parentSerializerClass;
    private final Map<String, Expression> jitCallbackUpdateFields;
    protected LinkedList<String> walkPath = new LinkedList();
    private static final Map<String, Map<String, Integer>> idGenerator = new ConcurrentHashMap<String, Map<String, Integer>>();

    public BaseObjectCodecBuilder(TypeRef<?> beanType, Fury fury, Class<?> parentSerializerClass) {
        super(new CodegenContext(), beanType);
        this.fury = fury;
        this.classResolver = fury.getClassResolver();
        this.parentSerializerClass = parentSerializerClass;
        this.addCommonImports();
        this.ctx.reserveName(REF_RESOLVER_NAME);
        this.ctx.reserveName(CLASS_RESOLVER_NAME);
        TypeRef<?> refResolverTypeRef = TypeRef.of(fury.getRefResolver().getClass());
        this.refResolverRef = Expression.Reference.fieldRef(REF_RESOLVER_NAME, refResolverTypeRef);
        Expression.Invoke refResolverExpr = new Expression.Invoke((Expression)this.furyRef, "getRefResolver", TypeRef.of(RefResolver.class));
        this.ctx.addField(this.ctx.type(refResolverTypeRef), REF_RESOLVER_NAME, (Expression)new Expression.Cast(refResolverExpr, refResolverTypeRef));
        Expression.Invoke classResolverExpr = Expression.Invoke.inlineInvoke((Expression)this.furyRef, "getClassResolver", CLASS_RESOLVER_TYPE_TOKEN, new Expression[0]);
        this.ctx.addField(this.ctx.type(CLASS_RESOLVER_TYPE_TOKEN), CLASS_RESOLVER_NAME, (Expression)classResolverExpr);
        this.ctx.reserveName(STRING_SERIALIZER_NAME);
        this.stringSerializerRef = Expression.Reference.fieldRef(STRING_SERIALIZER_NAME, STRING_SERIALIZER_TYPE_TOKEN);
        this.ctx.addField(this.ctx.type(TypeRef.of(StringSerializer.class)), STRING_SERIALIZER_NAME, (Expression)Expression.Invoke.inlineInvoke((Expression)this.furyRef, "getStringSerializer", CLASS_RESOLVER_TYPE_TOKEN, new Expression[0]));
        this.jitCallbackUpdateFields = new HashMap<String, Expression>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String codecClassName(Class<?> beanClass) {
        String name = ReflectionUtils.getClassNameWithoutPackage(beanClass).replace("$", "_");
        StringBuilder nameBuilder = new StringBuilder(name);
        if (this.fury.trackingRef()) {
            nameBuilder.append("FuryRef");
        } else {
            nameBuilder.append("Fury");
        }
        nameBuilder.append("Codec").append(this.codecSuffix());
        Map subGenerator = idGenerator.computeIfAbsent(nameBuilder.toString(), k -> new ConcurrentHashMap());
        String key = this.fury.getConfig().getConfigHash() + "_" + CodeGenerator.getClassUniqueId(beanClass);
        Integer id = (Integer)subGenerator.get(key);
        if (id == null) {
            Map map = subGenerator;
            synchronized (map) {
                id = subGenerator.computeIfAbsent(key, k -> subGenerator.size());
            }
        }
        nameBuilder.append('_').append(id);
        return nameBuilder.toString();
    }

    public String codecQualifiedClassName(Class<?> beanClass) {
        String pkg = CodeGenerator.getPackage(beanClass);
        if (StringUtils.isNotBlank(pkg)) {
            return pkg + "." + this.codecClassName(beanClass);
        }
        return this.codecClassName(beanClass);
    }

    protected abstract String codecSuffix();

    protected <T> T visitFury(Function<Fury, T> function) {
        return this.fury.getJITContext().asyncVisitFury(function);
    }

    private boolean needWriteRef(TypeRef<?> type) {
        return this.visitFury(fury -> fury.getClassResolver().needToWriteRef(type));
    }

    @Override
    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage(this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.extendsClasses(this.ctx.type(this.parentSerializerClass));
        this.ctx.reserveName(POJO_CLASS_TYPE_NAME);
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        Expression encodeExpr = this.buildEncodeExpression();
        Expression decodeExpr = this.buildDecodeExpression();
        String constructorCode = StringUtils.format("super(${fury}, ${cls});\nthis.${fury} = ${fury};\n${fury}.getClassResolver().setSerializerIfAbsent(${cls}, this);\n", "fury", "fury", "cls", POJO_CLASS_TYPE_NAME);
        this.ctx.clearExprState();
        String encodeCode = encodeExpr.genCode(this.ctx).code();
        encodeCode = this.ctx.optimizeMethodCode(encodeCode);
        this.ctx.clearExprState();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        decodeCode = this.ctx.optimizeMethodCode(decodeCode);
        this.ctx.overrideMethod("write", encodeCode, Void.TYPE, MemoryBuffer.class, BUFFER_NAME, Object.class, "obj");
        this.ctx.overrideMethod("read", decodeCode, Object.class, MemoryBuffer.class, BUFFER_NAME);
        this.registerJITNotifyCallback();
        this.ctx.addConstructor(constructorCode, Fury.class, "fury", Class.class, POJO_CLASS_TYPE_NAME);
        return this.ctx.genCode();
    }

    protected void registerJITNotifyCallback() {
        if (!this.jitCallbackUpdateFields.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(", ", "registerJITNotifyCallback(this,", ");\n");
            for (Map.Entry<String, Expression> entry : this.jitCallbackUpdateFields.entrySet()) {
                Code.ExprCode exprCode = entry.getValue().genCode(this.ctx);
                if (StringUtils.isNotBlank(exprCode.code())) {
                    stringJoiner.add(exprCode.code());
                }
                stringJoiner.add("\"" + entry.getKey() + "\"");
                stringJoiner.add(exprCode.value().toString());
            }
            this.ctx.addInitCode(stringJoiner.toString());
        }
    }

    protected void addCommonImports() {
        this.ctx.addImports(Fury.class, MemoryBuffer.class, this.fury.getRefResolver().getClass(), Platform.class);
        this.ctx.addImports(ClassInfo.class, ClassInfoHolder.class, ClassResolver.class);
        this.ctx.addImport(Generated.class);
        this.ctx.addImports(CodegenSerializer.LazyInitBeanSerializer.class, EnumSerializer.class);
        this.ctx.addImports(Serializer.class, StringSerializer.class);
        this.ctx.addImports(ObjectSerializer.class, CompatibleSerializer.class);
        this.ctx.addImports(AbstractCollectionSerializer.class, AbstractMapSerializer.class);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeRef<?> typeRef) {
        return this.serializeFor(inputObject, buffer, typeRef, false);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeRef<?> typeRef, boolean generateNewMethod) {
        return this.serializeFor(inputObject, buffer, typeRef, null, generateNewMethod);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeRef<?> typeRef, Expression serializer, boolean generateNewMethod) {
        Class<?> rawType = TypeUtils.getRawType(typeRef);
        if (this.needWriteRef(typeRef)) {
            return new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, inputObject)), this.serializeForNotNull(inputObject, buffer, typeRef, serializer, generateNewMethod));
        }
        if (typeRef.isPrimitive()) {
            return this.serializeForNotNull(inputObject, buffer, typeRef, serializer, generateNewMethod);
        }
        Expression.ListExpression action = new Expression.ListExpression(new Expression.Invoke(buffer, "writeByte", new Expression.Literal((byte)-1, TypeUtils.PRIMITIVE_BYTE_TYPE)), this.serializeForNotNull(inputObject, buffer, typeRef, serializer, generateNewMethod));
        return new Expression.If(ExpressionUtils.eqNull(inputObject), new Expression.Invoke(buffer, "writeByte", new Expression.Literal((byte)-3, TypeUtils.PRIMITIVE_BYTE_TYPE)), action);
    }

    protected Expression writeRefOrNull(Expression buffer, Expression object) {
        return Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "writeRefOrNull", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, object);
    }

    protected Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeRef<?> typeRef) {
        boolean genNewMethod = this.useCollectionSerialization(typeRef) || this.useMapSerialization(typeRef);
        return this.serializeForNotNull(inputObject, buffer, typeRef, null, genNewMethod);
    }

    private Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeRef<?> typeRef, boolean generateNewMethod) {
        return this.serializeForNotNull(inputObject, buffer, typeRef, null, generateNewMethod);
    }

    private Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeRef<?> typeRef, Expression serializer) {
        boolean genNewMethod = this.useCollectionSerialization(typeRef) || this.useMapSerialization(typeRef);
        return this.serializeForNotNull(inputObject, buffer, typeRef, serializer, genNewMethod);
    }

    private Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeRef<?> typeRef, Expression serializer, boolean generateNewMethod) {
        Class<?> clz = TypeUtils.getRawType(typeRef);
        if (TypeUtils.isPrimitive(clz) || TypeUtils.isBoxed(clz)) {
            if (clz == Byte.TYPE || clz == Byte.class) {
                return new Expression.Invoke(buffer, "writeByte", inputObject);
            }
            if (clz == Boolean.TYPE || clz == Boolean.class) {
                return new Expression.Invoke(buffer, "writeBoolean", inputObject);
            }
            if (clz == Character.TYPE || clz == Character.class) {
                return new Expression.Invoke(buffer, "writeChar", inputObject);
            }
            if (clz == Short.TYPE || clz == Short.class) {
                return new Expression.Invoke(buffer, "writeInt16", inputObject);
            }
            if (clz == Integer.TYPE || clz == Integer.class) {
                String func = this.fury.compressInt() ? "writeVarInt32" : "writeInt32";
                return new Expression.Invoke(buffer, func, inputObject);
            }
            if (clz == Long.TYPE || clz == Long.class) {
                return PrimitiveSerializers.LongSerializer.writeInt64(buffer, inputObject, this.fury.longEncoding(), true);
            }
            if (clz == Float.TYPE || clz == Float.class) {
                return new Expression.Invoke(buffer, "writeFloat32", inputObject);
            }
            if (clz == Double.TYPE || clz == Double.class) {
                return new Expression.Invoke(buffer, "writeFloat64", inputObject);
            }
            throw new IllegalStateException("impossible");
        }
        if (clz == String.class) {
            return this.fury.getStringSerializer().writeStringExpr(this.stringSerializerRef, buffer, inputObject);
        }
        Expression action = this.useCollectionSerialization(typeRef) ? this.serializeForCollection(buffer, inputObject, typeRef, serializer, generateNewMethod) : (this.useMapSerialization(typeRef) ? this.serializeForMap(buffer, inputObject, typeRef, serializer, generateNewMethod) : this.serializeForNotNullObject(inputObject, buffer, typeRef, serializer));
        return action;
    }

    protected boolean useCollectionSerialization(TypeRef<?> typeRef) {
        return this.visitFury(f -> f.getClassResolver().isCollection(TypeUtils.getRawType(typeRef)));
    }

    protected boolean useCollectionSerialization(Class<?> type) {
        return this.visitFury(f -> f.getClassResolver().isCollection(TypeUtils.getRawType(type)));
    }

    protected boolean useMapSerialization(TypeRef<?> typeRef) {
        return this.visitFury(f -> f.getClassResolver().isMap(TypeUtils.getRawType(typeRef)));
    }

    protected boolean useMapSerialization(Class<?> type) {
        return this.visitFury(f -> f.getClassResolver().isMap(TypeUtils.getRawType(type)));
    }

    protected abstract boolean isMonomorphic(Class<?> var1);

    protected boolean isMonomorphic(TypeRef<?> typeRef) {
        return this.isMonomorphic(typeRef.getRawType());
    }

    protected Expression serializeForNotNullObject(Expression inputObject, Expression buffer, TypeRef<?> typeRef, Expression serializer) {
        Class<?> clz = TypeUtils.getRawType(typeRef);
        if (serializer != null) {
            return new Expression.Invoke(serializer, "write", buffer, inputObject);
        }
        if (this.isMonomorphic(clz)) {
            serializer = this.getOrCreateSerializer(clz);
            return new Expression.Invoke(serializer, "write", buffer, inputObject);
        }
        return this.writeForNotNullNonFinalObject(inputObject, buffer, typeRef);
    }

    protected Expression writeForNotNullNonFinalObject(Expression inputObject, Expression buffer, TypeRef<?> typeRef) {
        Class<?> clz = TypeUtils.getRawType(typeRef);
        Expression.Invoke clsExpr = new Expression.Invoke(inputObject, "getClass", "cls", TypeUtils.CLASS_TYPE);
        Expression.ListExpression writeClassAndObject = new Expression.ListExpression(new Expression[0]);
        Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
        Expression classInfo = (Expression)classInfoRef.f0;
        if (((Boolean)classInfoRef.f1).booleanValue()) {
            writeClassAndObject.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeRef, clsExpr))));
        }
        writeClassAndObject.add(this.classResolver.writeClassExpr(this.classResolverRef, buffer, classInfo));
        writeClassAndObject.add(new Expression.Invoke(ExpressionUtils.invokeInline(classInfo, "getSerializer", this.getSerializerType(clz)), "write", TypeUtils.PRIMITIVE_VOID_TYPE, buffer, inputObject));
        return ExpressionOptimizer.invokeGenerated(this.ctx, me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, inputObject), writeClassAndObject, "writeClassAndObject", false);
    }

    protected Expression writeClassInfo(Expression buffer, Expression clsExpr, Class<?> declaredClass, boolean returnSerializer) {
        Expression.ListExpression writeClassAction = new Expression.ListExpression(new Expression[0]);
        Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(declaredClass);
        Expression classInfo = (Expression)classInfoRef.f0;
        writeClassAction.add(new Expression.If(ExpressionUtils.neq(Expression.Invoke.inlineInvoke(classInfo, "getCls", TypeUtils.CLASS_TYPE, new Expression[0]), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeRef, clsExpr))));
        writeClassAction.add(this.classResolver.writeClassExpr(this.classResolverRef, buffer, classInfo));
        if (returnSerializer) {
            writeClassAction.add(ExpressionUtils.invoke(classInfo, "getSerializer", "serializer", this.getSerializerType(declaredClass)));
        }
        return writeClassAction;
    }

    protected Expression getOrCreateSerializer(Class<?> cls) {
        Expression.Reference serializerRef = this.serializerMap.get(cls);
        if (serializerRef == null) {
            Class<Serializer> serializerClass = this.visitFury(f -> f.getClassResolver().getSerializerClass(cls));
            Preconditions.checkNotNull(serializerClass, "Unsupported for class " + cls);
            if (!ReflectionUtils.isPublic(serializerClass)) {
                serializerClass = Serializer.class;
            } else {
                ClassLoader beanClassClassLoader = this.beanClass.getClassLoader();
                if (beanClassClassLoader == null && (beanClassClassLoader = Thread.currentThread().getContextClassLoader()) == null) {
                    beanClassClassLoader = Fury.class.getClassLoader();
                }
                try {
                    beanClassClassLoader.loadClass(serializerClass.getName());
                }
                catch (ClassNotFoundException e) {
                    serializerClass = CodegenSerializer.LazyInitBeanSerializer.class;
                }
                if (serializerClass == CodegenSerializer.LazyInitBeanSerializer.class || serializerClass == ObjectSerializer.class || serializerClass == CompatibleSerializer.class) {
                    serializerClass = Serializer.class;
                }
            }
            if (this.useCollectionSerialization(cls) && !AbstractCollectionSerializer.class.isAssignableFrom(serializerClass)) {
                serializerClass = AbstractCollectionSerializer.class;
            } else if (this.useMapSerialization(cls) && !AbstractMapSerializer.class.isAssignableFrom(serializerClass)) {
                serializerClass = AbstractMapSerializer.class;
            }
            TypeRef<Serializer> serializerTypeRef = TypeRef.of(serializerClass);
            Expression fieldTypeExpr = this.getClassExpr(cls);
            Expression.Invoke newSerializerExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getRawSerializer", SERIALIZER_TYPE, fieldTypeExpr);
            String name = this.ctx.newName(StringUtils.uncapitalize(serializerClass.getSimpleName()));
            boolean hasJITResult = this.fury.getJITContext().hasJITResult(cls);
            if (hasJITResult) {
                this.jitCallbackUpdateFields.put(name, this.getClassExpr(cls));
                this.ctx.addField(false, this.ctx.type(Serializer.class), name, ExpressionUtils.cast(newSerializerExpr, SERIALIZER_TYPE));
                serializerRef = new Expression.Reference(name, SERIALIZER_TYPE, false);
            } else {
                this.ctx.addField(true, this.ctx.type(serializerClass), name, ExpressionUtils.cast(newSerializerExpr, serializerTypeRef));
                serializerRef = Expression.Reference.fieldRef(name, serializerTypeRef);
            }
            this.serializerMap.put(cls, serializerRef);
        }
        return serializerRef;
    }

    protected Expression getClassExpr(Class<?> cls) {
        if (this.sourcePublicAccessible(cls)) {
            return Expression.Literal.ofClass(cls);
        }
        return this.staticClassFieldExpr(cls, "__class__" + cls.getName().replace(".", "_"));
    }

    protected Tuple2<Expression.Reference, Boolean> addClassInfoField(Class<?> cls) {
        boolean needUpdate = !ReflectionUtils.isMonomorphic(cls);
        String key = !needUpdate ? "classInfo:" + cls : "classInfo:" + cls + this.walkPath;
        Tuple2<Expression.Reference, Boolean> classInfoRef = (Tuple2<Expression.Reference, Boolean>)this.sharedFieldMap.get(key);
        if (classInfoRef != null) {
            return classInfoRef;
        }
        if (!needUpdate) {
            Expression clsExpr = this.getClassExpr(cls);
            Expression.Invoke classInfoExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeRef, clsExpr);
            String name = this.ctx.newName(this.ctx.newName(cls) + "ClassInfo");
            this.ctx.addField(true, this.ctx.type(ClassInfo.class), name, classInfoExpr);
            classInfoRef = Tuple2.of(Expression.Reference.fieldRef(name, classInfoTypeRef), false);
        } else {
            Expression.Invoke classInfoExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "nilClassInfo", classInfoTypeRef, new Expression[0]);
            String name = this.ctx.newName(cls, "ClassInfo");
            this.ctx.addField(false, this.ctx.type(ClassInfo.class), name, classInfoExpr);
            classInfoRef = Tuple2.of(new Expression.Reference(name, classInfoTypeRef), true);
        }
        this.sharedFieldMap.put(key, classInfoRef);
        return classInfoRef;
    }

    protected Expression.Reference addClassInfoHolderField(Class<?> cls) {
        String key = ReflectionUtils.isMonomorphic(cls) ? "classInfoHolder:" + cls : "classInfoHolder:" + cls + this.walkPath;
        Expression.Reference reference = (Expression.Reference)this.sharedFieldMap.get(key);
        if (reference != null) {
            return reference;
        }
        Expression.Invoke classInfoHolderExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "nilClassInfoHolder", classInfoHolderTypeRef, new Expression[0]);
        String name = this.ctx.newName(cls, "ClassInfoHolder");
        this.ctx.addField(true, this.ctx.type(ClassInfoHolder.class), name, classInfoHolderExpr);
        reference = new Expression.Reference(name, classInfoHolderTypeRef);
        this.sharedFieldMap.put(key, reference);
        return reference;
    }

    protected Expression readClassInfo(Class<?> cls, Expression buffer) {
        return this.readClassInfo(cls, buffer, true);
    }

    protected Expression readClassInfo(Class<?> cls, Expression buffer, boolean inlineReadClassInfo) {
        if (ReflectionUtils.isMonomorphic(cls)) {
            Expression.Reference classInfoRef = (Expression.Reference)this.addClassInfoField(cls).f0;
            if (inlineReadClassInfo) {
                return Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeRef, buffer, classInfoRef);
            }
            return new Expression.Invoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeRef, buffer, classInfoRef);
        }
        Expression.Reference classInfoHolderRef = this.addClassInfoHolderField(cls);
        if (inlineReadClassInfo) {
            return Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeRef, buffer, classInfoHolderRef);
        }
        return new Expression.Invoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeRef, buffer, classInfoHolderRef);
    }

    protected TypeRef<?> getSerializerType(TypeRef<?> objType) {
        return this.getSerializerType(objType.getRawType());
    }

    protected TypeRef<?> getSerializerType(Class<?> objType) {
        if (this.classResolver.isCollection(objType)) {
            return COLLECTION_SERIALIZER_TYPE;
        }
        if (this.classResolver.isMap(objType)) {
            return MAP_SERIALIZER_TYPE;
        }
        return SERIALIZER_TYPE;
    }

    protected Expression serializeForCollection(Expression buffer, Expression collection, TypeRef<?> typeRef, Expression serializer, boolean generateNewMethod) {
        if (serializer == null) {
            Class<?> clz = TypeUtils.getRawType(typeRef);
            if (this.isMonomorphic(clz)) {
                serializer = this.getOrCreateSerializer(clz);
            } else {
                Expression.ListExpression writeClassAction = new Expression.ListExpression(new Expression[0]);
                Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
                Expression classInfo = (Expression)classInfoRef.f0;
                Expression.Invoke clsExpr = new Expression.Invoke(collection, "getClass", "cls", TypeUtils.CLASS_TYPE);
                writeClassAction.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeRef, clsExpr))));
                writeClassAction.add(this.classResolver.writeClassExpr(this.classResolverRef, buffer, classInfo));
                writeClassAction.add(new Expression.Return(ExpressionUtils.invokeInline(classInfo, "getSerializer", this.getSerializerType(typeRef))));
                serializer = ExpressionOptimizer.invokeGenerated(this.ctx, me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, collection), writeClassAction, "writeCollectionClassInfo", false);
            }
        } else if (!TypeRef.of(AbstractCollectionSerializer.class).isSupertypeOf(serializer.type())) {
            serializer = ExpressionUtils.cast(serializer, TypeRef.of(AbstractCollectionSerializer.class), "colSerializer");
        }
        Expression.ListExpression actions = new Expression.ListExpression(new Expression[0]);
        Expression.If write = new Expression.If(Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]), this.writeCollectionData(buffer, collection, serializer, TypeUtils.getElementType(typeRef)), new Expression.Invoke(serializer, "write", buffer, collection));
        actions.add(write);
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, collection, serializer), actions, "writeCollection", false);
        }
        return actions;
    }

    protected Expression writeCollectionData(Expression buffer, Expression collection, Expression serializer, TypeRef<?> elementType) {
        Expression.Invoke onCollectionWrite = new Expression.Invoke(serializer, "onCollectionWrite", TypeUtils.collectionOf(elementType), buffer, collection);
        boolean isList = List.class.isAssignableFrom(TypeUtils.getRawType(collection.type()));
        collection = isList ? new Expression.Cast(onCollectionWrite.inline(), TypeUtils.LIST_TYPE, "list") : onCollectionWrite;
        Expression.Invoke size = new Expression.Invoke(collection, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        this.walkPath.add(elementType.toString());
        Expression.ListExpression builder = new Expression.ListExpression(new Expression[0]);
        Class<?> elemClass = TypeUtils.getRawType(elementType);
        boolean trackingRef = this.needWriteRef(elementType);
        Tuple2<Expression, Expression.Invoke> writeElementsHeader = this.writeElementsHeader(elemClass, trackingRef, serializer, buffer, collection);
        Expression flags = (Expression)writeElementsHeader.f0;
        builder.add(flags);
        boolean finalType = this.isMonomorphic(elemClass);
        if (finalType) {
            if (trackingRef) {
                builder.add(this.writeContainerElements(elementType, true, null, null, buffer, collection, size));
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(CollectionFlags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags, hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add((Expression)hasNull, this.writeContainerElements(elementType, false, null, hasNull, buffer, collection, size));
            }
        } else {
            Expression.If action;
            Expression.Literal flag = Expression.Literal.ofInt(CollectionFlags.NOT_SAME_TYPE);
            Expression.Comparator sameElementClass = ExpressionUtils.neq((Expression)new Expression.BitAnd(flags, flag), (Expression)flag, "sameElementClass");
            builder.add(sameElementClass);
            Expression.Literal notDeclTypeFlag = Expression.Literal.ofInt(CollectionFlags.NOT_DECL_ELEMENT_TYPE);
            Expression.Comparator isDeclType = ExpressionUtils.neq(new Expression.BitAnd(flags, notDeclTypeFlag), notDeclTypeFlag);
            boolean maybeDecl = this.visitFury(f -> f.getClassResolver().isSerializable(elemClass));
            TypeRef<?> serializerType = this.getSerializerType(elementType);
            Expression elemSerializer = maybeDecl ? new Expression.If(isDeclType, ExpressionUtils.cast(this.getOrCreateSerializer(elemClass), serializerType), ExpressionUtils.cast(((Expression.Invoke)writeElementsHeader.f1).inline(), serializerType), false, serializerType) : ExpressionUtils.cast(((Expression.Invoke)writeElementsHeader.f1).inline(), serializerType);
            elemSerializer = ExpressionUtils.uninline(elemSerializer);
            if (trackingRef) {
                Expression.ListExpression writeBuilder = new Expression.ListExpression(new Expression[]{elemSerializer});
                writeBuilder.add(this.writeContainerElements(elementType, true, elemSerializer, null, buffer, collection, size));
                HashSet<Expression> cutPoint = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, collection, size);
                if (maybeDecl) {
                    cutPoint.add((Expression.Invoke)flags);
                }
                action = new Expression.If(sameElementClass, ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, writeBuilder, "sameElementClassWrite", false), this.writeContainerElements(elementType, true, null, null, buffer, collection, size));
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(CollectionFlags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags, hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add(hasNull);
                Expression.ListExpression writeBuilder = new Expression.ListExpression(new Expression[]{elemSerializer});
                writeBuilder.add(this.writeContainerElements(elementType, false, elemSerializer, hasNull, buffer, collection, size));
                HashSet<Expression> cutPoint = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, collection, size, hasNull);
                if (maybeDecl) {
                    cutPoint.add((Expression.Comparator)flags);
                }
                action = new Expression.If(sameElementClass, ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, writeBuilder, "sameElementClassWrite", false), this.writeContainerElements(elementType, false, null, hasNull, buffer, collection, size));
            }
            builder.add(action);
        }
        this.walkPath.removeLast();
        return new Expression.ListExpression(onCollectionWrite, new Expression.If(ExpressionUtils.gt(size, Expression.Literal.ofInt(0)), builder));
    }

    private Tuple2<Expression, Expression.Invoke> writeElementsHeader(Class<?> elementType, boolean trackingRef, Expression collectionSerializer, Expression buffer, Expression value) {
        if (this.isMonomorphic(elementType)) {
            Expression.AbstractExpression bitmap = trackingRef ? new Expression.ListExpression(new Expression.Invoke(buffer, "writeByte", Expression.Literal.ofInt(CollectionFlags.TRACKING_REF)), Expression.Literal.ofInt(CollectionFlags.TRACKING_REF)) : new Expression.Invoke(collectionSerializer, "writeNullabilityHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value);
            return Tuple2.of(bitmap, null);
        }
        Expression elementTypeExpr = this.getClassExpr(elementType);
        Expression.Reference classInfoHolder = this.addClassInfoHolderField(elementType);
        Expression.Invoke bitmap = trackingRef ? (elementType == Object.class ? new Expression.Invoke(collectionSerializer, "writeTypeHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value, classInfoHolder) : new Expression.Invoke(collectionSerializer, "writeTypeHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value, elementTypeExpr, classInfoHolder)) : new Expression.Invoke(collectionSerializer, "writeTypeNullabilityHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value, elementTypeExpr, classInfoHolder);
        Expression.Invoke serializer = new Expression.Invoke((Expression)classInfoHolder, "getSerializer", SERIALIZER_TYPE);
        return Tuple2.of(bitmap, serializer);
    }

    private Expression writeContainerElements(TypeRef<?> elementType, boolean trackingRef, Expression serializer, Expression hasNull, Expression buffer, Expression collection, Expression size) {
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of(BUFFER_NAME, buffer, "hasNull", hasNull, "serializer", serializer);
        boolean isList = List.class.isAssignableFrom(TypeUtils.getRawType(collection.type()));
        if (isList) {
            exprHolder.add("list", collection);
            return new Expression.ForLoop(new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE), size, new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE), i -> {
                Expression.Invoke elem = new Expression.Invoke(exprHolder.get("list"), "get", TypeUtils.OBJECT_TYPE, false, (Expression)i);
                return this.writeContainerElement(exprHolder.get(BUFFER_NAME), elem, elementType, trackingRef, exprHolder.get("hasNull"), exprHolder.get("serializer"));
            });
        }
        return new Expression.ForEach(collection, (i, elem) -> this.writeContainerElement(exprHolder.get(BUFFER_NAME), (Expression)elem, elementType, trackingRef, exprHolder.get("hasNull"), exprHolder.get("serializer")));
    }

    private Expression writeContainerElement(Expression buffer, Expression elem, TypeRef<?> elementType, boolean trackingRef, Expression hasNull, Expression elemSerializer) {
        boolean generateNewMethod = this.useCollectionSerialization(elementType) || this.useMapSerialization(elementType);
        Class<?> rawType = TypeUtils.getRawType(elementType);
        boolean finalType = this.isMonomorphic(rawType);
        elem = this.tryCastIfPublic(elem, elementType);
        Expression.If write = finalType ? (trackingRef ? new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, elem)), this.serializeForNotNull(elem, buffer, elementType, generateNewMethod)) : new Expression.If(hasNull, this.serializeFor(elem, buffer, elementType, generateNewMethod), this.serializeForNotNull(elem, buffer, elementType))) : (trackingRef ? new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, elem)), this.serializeForNotNull(elem, buffer, elementType, elemSerializer, generateNewMethod)) : new Expression.If(hasNull, this.serializeFor(elem, buffer, elementType, elemSerializer, generateNewMethod), this.serializeForNotNull(elem, buffer, elementType, elemSerializer, generateNewMethod)));
        return new Expression.ListExpression(elem, write);
    }

    protected Expression serializeForMap(Expression buffer, Expression map, TypeRef<?> typeRef, Expression serializer, boolean generateNewMethod) {
        if (serializer == null) {
            Class<?> clz = TypeUtils.getRawType(typeRef);
            if (this.isMonomorphic(clz)) {
                serializer = this.getOrCreateSerializer(clz);
            } else {
                Expression.ListExpression writeClassAction = new Expression.ListExpression(new Expression[0]);
                Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
                Expression classInfo = (Expression)classInfoRef.f0;
                Expression.Invoke clsExpr = new Expression.Invoke(map, "getClass", "cls", TypeUtils.CLASS_TYPE);
                writeClassAction.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeRef, clsExpr))));
                writeClassAction.add(this.classResolver.writeClassExpr(this.classResolverRef, buffer, classInfo));
                writeClassAction.add(new Expression.Return(ExpressionUtils.invokeInline(classInfo, "getSerializer", MAP_SERIALIZER_TYPE)));
                serializer = ExpressionOptimizer.invokeGenerated(this.ctx, me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, map), writeClassAction, "writeMapClassInfo", false);
            }
        } else if (!AbstractMapSerializer.class.isAssignableFrom(serializer.type().getRawType())) {
            serializer = ExpressionUtils.cast(serializer, TypeRef.of(AbstractMapSerializer.class), "mapSerializer");
        }
        Expression.If write = new Expression.If(Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]), this.jitWriteMap(buffer, map, serializer, typeRef), new Expression.Invoke(serializer, "write", buffer, map));
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, map, serializer), write, "writeMap", false);
        }
        return write;
    }

    private Expression jitWriteMap(Expression buffer, Expression map, Expression serializer, TypeRef<?> typeRef) {
        Tuple2<TypeRef<?>, TypeRef<?>> keyValueType = TypeUtils.getMapKeyValueType(typeRef);
        TypeRef keyType = (TypeRef)keyValueType.f0;
        TypeRef valueType = (TypeRef)keyValueType.f1;
        map = new Expression.Invoke(serializer, "onMapWrite", TypeUtils.mapOf(keyType, valueType), buffer, map);
        Expression.Invoke iterator = new Expression.Invoke((Expression)Expression.Invoke.inlineInvoke(map, "entrySet", TypeUtils.SET_TYPE, new Expression[0]), "iterator", TypeUtils.ITERATOR_TYPE);
        Expression entry = ExpressionUtils.cast(Expression.Invoke.inlineInvoke((Expression)iterator, "next", TypeUtils.OBJECT_TYPE, new Expression[0]), TypeUtils.MAP_ENTRY_TYPE, "entry");
        boolean keyMonomorphic = this.isMonomorphic(keyType);
        boolean valueMonomorphic = this.isMonomorphic(valueType);
        boolean inline = keyMonomorphic && valueMonomorphic;
        Class keyTypeRawType = keyType.getRawType();
        Class valueTypeRawType = valueType.getRawType();
        boolean trackingKeyRef = this.visitFury(fury -> fury.getClassResolver().needToWriteRef(keyType));
        boolean trackingValueRef = this.visitFury(fury -> fury.getClassResolver().needToWriteRef(valueType));
        Tuple2<Expression, Expression> mapKVSerializer = this.getMapKVSerializer(keyTypeRawType, valueTypeRawType);
        Expression keySerializer = (Expression)mapKVSerializer.f0;
        Expression valueSerializer = (Expression)mapKVSerializer.f1;
        Expression.While whileAction = new Expression.While(ExpressionUtils.neqNull(entry), () -> {
            String method = "writeJavaNullChunk";
            if (keyMonomorphic && valueMonomorphic && !trackingKeyRef && !trackingValueRef) {
                method = "writeNullChunkKVFinalNoRef";
            }
            Expression writeChunk = this.writeChunk(buffer, entry, iterator, keyType, valueType);
            return new Expression.ListExpression(new Expression.Assign(entry, Expression.Invoke.inlineInvoke(serializer, method, TypeUtils.MAP_ENTRY_TYPE, buffer, entry, iterator, keySerializer, valueSerializer)), new Expression.If(ExpressionUtils.neqNull(entry), inline ? writeChunk : new Expression.Assign(entry, ExpressionUtils.inline(writeChunk))));
        });
        return new Expression.If(ExpressionUtils.not(Expression.Invoke.inlineInvoke(map, "isEmpty", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0])), whileAction);
    }

    private Tuple2<Expression, Expression> getMapKVSerializer(Class<?> keyType, Class<?> valueType) {
        Expression valueSerializer;
        Expression keySerializer;
        boolean keyMonomorphic = this.isMonomorphic(keyType);
        boolean valueMonomorphic = this.isMonomorphic(valueType);
        if (keyMonomorphic && valueMonomorphic) {
            keySerializer = this.getOrCreateSerializer(keyType);
            valueSerializer = this.getOrCreateSerializer(valueType);
        } else if (keyMonomorphic) {
            keySerializer = this.getOrCreateSerializer(keyType);
            valueSerializer = ExpressionUtils.nullValue(SERIALIZER_TYPE);
        } else if (valueMonomorphic) {
            keySerializer = ExpressionUtils.nullValue(SERIALIZER_TYPE);
            valueSerializer = this.getOrCreateSerializer(valueType);
        } else {
            keySerializer = ExpressionUtils.nullValue(SERIALIZER_TYPE);
            valueSerializer = ExpressionUtils.nullValue(SERIALIZER_TYPE);
        }
        return Tuple2.of(keySerializer, valueSerializer);
    }

    protected Expression writeChunk(Expression buffer, Expression entry, Expression iterator, TypeRef<?> keyType, TypeRef<?> valueType) {
        Expression chunkHeader;
        int header;
        Expression valueSerializer;
        Expression keySerializer;
        boolean inline;
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression key = ExpressionUtils.invoke(entry, "getKey", "key", keyType);
        Expression value = ExpressionUtils.invoke(entry, "getValue", "value", valueType);
        boolean keyMonomorphic = this.isMonomorphic(keyType);
        boolean valueMonomorphic = this.isMonomorphic(valueType);
        Class<?> keyTypeRawType = keyType.getRawType();
        Class<?> valueTypeRawType = valueType.getRawType();
        Expression keyTypeExpr = keyMonomorphic ? this.getClassExpr(keyTypeRawType) : new Expression.Invoke(key, "getClass", "keyType", TypeUtils.CLASS_TYPE);
        Expression valueTypeExpr = valueMonomorphic ? this.getClassExpr(valueTypeRawType) : new Expression.Invoke(value, "getClass", "valueType", TypeUtils.CLASS_TYPE);
        Expression.Invoke writePlaceHolder = new Expression.Invoke(buffer, "writeInt16", Expression.Literal.ofShort((short)-1));
        Expression.Arithmetic chunkSizeOffset = ExpressionUtils.subtract(Expression.Invoke.inlineInvoke(buffer, "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE, new Expression[0]), Expression.Literal.ofInt(1), "chunkSizeOffset");
        expressions.add(key, value, keyTypeExpr, valueTypeExpr, writePlaceHolder, chunkSizeOffset, writePlaceHolder, chunkSizeOffset);
        boolean trackingKeyRef = this.visitFury(fury -> fury.getClassResolver().needToWriteRef(keyType));
        boolean trackingValueRef = this.visitFury(fury -> fury.getClassResolver().needToWriteRef(valueType));
        Expression.AbstractExpression keyWriteRef = Expression.Literal.ofBoolean(trackingKeyRef);
        Expression.AbstractExpression valueWriteRef = Expression.Literal.ofBoolean(trackingValueRef);
        boolean bl = inline = keyMonomorphic && valueMonomorphic;
        if (keyMonomorphic && valueMonomorphic) {
            keySerializer = this.getOrCreateSerializer(keyTypeRawType);
            valueSerializer = this.getOrCreateSerializer(valueTypeRawType);
            header = MapFlags.KEY_DECL_TYPE | MapFlags.VALUE_DECL_TYPE;
            if (trackingKeyRef) {
                header |= MapFlags.TRACKING_KEY_REF;
            }
            if (trackingValueRef) {
                header |= MapFlags.TRACKING_VALUE_REF;
            }
            chunkHeader = Expression.Literal.ofInt(header);
            expressions.add(chunkHeader);
        } else if (keyMonomorphic) {
            header = MapFlags.KEY_DECL_TYPE;
            if (trackingKeyRef) {
                header |= MapFlags.TRACKING_KEY_REF;
            }
            keySerializer = this.getOrCreateSerializer(keyTypeRawType);
            this.walkPath.add("value:" + valueType);
            valueSerializer = this.writeClassInfo(buffer, valueTypeExpr, valueTypeRawType, true);
            this.walkPath.removeLast();
            chunkHeader = ExpressionUtils.ofInt("chunkHeader", header);
            expressions.add(chunkHeader);
            if (trackingValueRef) {
                valueWriteRef = new Expression.Invoke(valueSerializer, "needToWriteRef", "valueWriteRef", TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
                expressions.add(new Expression.If(valueWriteRef, new Expression.Assign(chunkHeader, ExpressionUtils.bitor(chunkHeader, Expression.Literal.ofInt(MapFlags.TRACKING_VALUE_REF)))));
            }
        } else if (valueMonomorphic) {
            this.walkPath.add("key:" + keyType);
            keySerializer = this.writeClassInfo(buffer, keyTypeExpr, keyTypeRawType, true);
            this.walkPath.removeLast();
            valueSerializer = this.getOrCreateSerializer(valueTypeRawType);
            header = MapFlags.VALUE_DECL_TYPE;
            if (trackingValueRef) {
                header |= MapFlags.TRACKING_VALUE_REF;
            }
            chunkHeader = ExpressionUtils.ofInt("chunkHeader", header);
            expressions.add(chunkHeader);
            if (trackingKeyRef) {
                keyWriteRef = new Expression.Invoke(keySerializer, "needToWriteRef", "keyWriteRef", TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
                expressions.add(new Expression.If(keyWriteRef, new Expression.Assign(chunkHeader, ExpressionUtils.bitor(chunkHeader, Expression.Literal.ofInt(MapFlags.TRACKING_KEY_REF)))));
            }
        } else {
            this.walkPath.add("key:" + keyType);
            keySerializer = this.writeClassInfo(buffer, keyTypeExpr, keyTypeRawType, true);
            this.walkPath.removeLast();
            this.walkPath.add("value:" + valueType);
            valueSerializer = this.writeClassInfo(buffer, valueTypeExpr, valueTypeRawType, true);
            this.walkPath.removeLast();
            chunkHeader = ExpressionUtils.ofInt("chunkHeader", 0);
            expressions.add(chunkHeader);
            if (trackingKeyRef) {
                keyWriteRef = new Expression.Invoke(keySerializer, "needToWriteRef", "keyWriteRef", TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
                expressions.add(new Expression.If(keyWriteRef, new Expression.Assign(chunkHeader, ExpressionUtils.bitor(chunkHeader, Expression.Literal.ofInt(MapFlags.TRACKING_KEY_REF)))));
            }
            if (trackingValueRef) {
                valueWriteRef = new Expression.Invoke(valueSerializer, "needToWriteRef", "valueWriteRef", TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
                expressions.add(new Expression.If(valueWriteRef, new Expression.Assign(chunkHeader, ExpressionUtils.bitor(chunkHeader, Expression.Literal.ofInt(MapFlags.TRACKING_VALUE_REF)))));
            }
        }
        Expression chunkSize = ExpressionUtils.ofInt("chunkSize", 0);
        expressions.add(keySerializer, valueSerializer, keyWriteRef, valueWriteRef, new Expression.Invoke(buffer, "putByte", ExpressionUtils.subtract(chunkSizeOffset, Expression.Literal.ofInt(1)), chunkHeader), chunkSize);
        Expression.AbstractExpression keyWriteRefExpr = keyWriteRef;
        Expression.AbstractExpression valueWriteRefExpr = valueWriteRef;
        Expression.While writeLoop = new Expression.While((Expression)Expression.Literal.ofBoolean(true), () -> {
            Expression.LogicalOr breakCondition = keyMonomorphic && valueMonomorphic ? ExpressionUtils.or(ExpressionUtils.eqNull(key), ExpressionUtils.eqNull(value), new Expression[0]) : (keyMonomorphic ? ExpressionUtils.or(ExpressionUtils.eqNull(key), ExpressionUtils.eqNull(value), ExpressionUtils.neq(Expression.Invoke.inlineInvoke(value, "getClass", TypeUtils.CLASS_TYPE, new Expression[0]), valueTypeExpr)) : (valueMonomorphic ? ExpressionUtils.or(ExpressionUtils.eqNull(key), ExpressionUtils.eqNull(value), ExpressionUtils.neq(Expression.Invoke.inlineInvoke(key, "getClass", TypeUtils.CLASS_TYPE, new Expression[0]), keyTypeExpr)) : ExpressionUtils.or(ExpressionUtils.eqNull(key), ExpressionUtils.eqNull(value), ExpressionUtils.neq(Expression.Invoke.inlineInvoke(key, "getClass", TypeUtils.CLASS_TYPE, new Expression[0]), keyTypeExpr), ExpressionUtils.neq(Expression.Invoke.inlineInvoke(value, "getClass", TypeUtils.CLASS_TYPE, new Expression[0]), valueTypeExpr))));
            Expression writeKey = this.serializeForNotNull(key, buffer, keyType, keySerializer);
            if (trackingKeyRef) {
                writeKey = new Expression.If(ExpressionUtils.or(ExpressionUtils.not(keyWriteRefExpr), ExpressionUtils.not(Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "writeRefOrNull", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, key)), new Expression[0]), writeKey);
            }
            Expression writeValue = this.serializeForNotNull(value, buffer, valueType, valueSerializer);
            if (trackingValueRef) {
                writeValue = new Expression.If(ExpressionUtils.or(ExpressionUtils.not(valueWriteRefExpr), ExpressionUtils.not(Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "writeRefOrNull", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, value)), new Expression[0]), writeValue);
            }
            return new Expression.ListExpression(new Expression.If(breakCondition, new Expression.Break()), writeKey, writeValue, new Expression.Assign(chunkSize, ExpressionUtils.add(chunkSize, Expression.Literal.ofInt(1))), new Expression.If(Expression.Invoke.inlineInvoke(iterator, "hasNext", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]), new Expression.ListExpression(new Expression.Assign(entry, ExpressionUtils.cast(Expression.Invoke.inlineInvoke(iterator, "next", TypeUtils.OBJECT_TYPE, new Expression[0]), TypeUtils.MAP_ENTRY_TYPE)), new Expression.Assign(key, this.tryInlineCast(Expression.Invoke.inlineInvoke(entry, "getKey", TypeUtils.OBJECT_TYPE, new Expression[0]), keyType)), new Expression.Assign(value, ExpressionUtils.invokeInline(entry, "getValue", valueType))), ExpressionUtils.list(new Expression.Assign(entry, new Expression.Literal(null, TypeUtils.MAP_ENTRY_TYPE)), new Expression.Break())), new Expression.If(ExpressionUtils.eq(chunkSize, Expression.Literal.ofInt(255)), new Expression.Break()));
        });
        expressions.add((Expression)writeLoop, new Expression.Invoke(buffer, "putByte", chunkSizeOffset, chunkSize));
        if (!inline) {
            expressions.add(new Expression.Return(entry));
            HashSet<Expression> params = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, entry, iterator);
            return ExpressionOptimizer.invokeGenerated(this.ctx, params, expressions, "writeChunk", false);
        }
        return expressions;
    }

    protected Expression readRefOrNull(Expression buffer) {
        return new Expression.Invoke((Expression)this.refResolverRef, "readRefOrNull", "tag", TypeUtils.PRIMITIVE_BYTE_TYPE, false, buffer);
    }

    protected Expression tryPreserveRefId(Expression buffer) {
        return new Expression.Invoke((Expression)this.refResolverRef, "tryPreserveRefId", "refId", TypeUtils.PRIMITIVE_INT_TYPE, false, buffer);
    }

    protected Expression deserializeFor(Expression buffer, TypeRef<?> typeRef, Function<Expression, Expression> callback) {
        return this.deserializeFor(buffer, typeRef, callback, null);
    }

    protected Expression deserializeFor(Expression buffer, TypeRef<?> typeRef, Function<Expression, Expression> callback, InvokeHint invokeHint) {
        if (this.visitFury(f -> f.getClassResolver().needToWriteRef(typeRef)).booleanValue()) {
            return this.readRef(buffer, callback, () -> this.deserializeForNotNull(buffer, typeRef, invokeHint));
        }
        if (typeRef.isPrimitive()) {
            Expression value = this.deserializeForNotNull(buffer, typeRef, invokeHint);
            return new Expression.ListExpression(value, callback.apply(value));
        }
        return this.readNullable(buffer, typeRef, callback, () -> this.deserializeForNotNull(buffer, typeRef, invokeHint));
    }

    private Expression readRef(Expression buffer, Function<Expression, Expression> callback, Supplier<Expression> deserializeForNotNull) {
        Expression refId = this.tryPreserveRefId(buffer);
        Expression.Comparator needDeserialize = ExpressionUtils.egt(refId, new Expression.Literal((byte)-1, TypeUtils.PRIMITIVE_BYTE_TYPE));
        Expression deserializedValue = deserializeForNotNull.get();
        Expression.Invoke setReadObject = new Expression.Invoke((Expression)this.refResolverRef, "setReadObject", refId, deserializedValue);
        Expression.Invoke readValue = Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "getReadObject", TypeUtils.OBJECT_TYPE, false, new Expression[0]);
        return new Expression.If(needDeserialize, callback.apply(new Expression.ListExpression(refId, deserializedValue, setReadObject, deserializedValue)), callback.apply(readValue), false);
    }

    private Expression readNullable(Expression buffer, TypeRef<?> typeRef, Function<Expression, Expression> callback, Supplier<Expression> deserializeForNotNull) {
        Expression.Comparator notNull = ExpressionUtils.neq(Expression.Invoke.inlineInvoke(buffer, "readByte", TypeUtils.PRIMITIVE_BYTE_TYPE, new Expression[0]), new Expression.Literal((byte)-3, TypeUtils.PRIMITIVE_BYTE_TYPE));
        Expression value = deserializeForNotNull.get();
        return new Expression.If(notNull, callback.apply(value), callback.apply(ExpressionUtils.nullValue(typeRef)), false);
    }

    protected Expression deserializeForNotNull(Expression buffer, TypeRef<?> typeRef, InvokeHint invokeHint) {
        return this.deserializeForNotNull(buffer, typeRef, null, invokeHint);
    }

    protected Expression deserializeForNotNull(Expression buffer, TypeRef<?> typeRef, Expression serializer, InvokeHint invokeHint) {
        Expression obj;
        Class<?> cls = TypeUtils.getRawType(typeRef);
        if (TypeUtils.isPrimitive(cls) || TypeUtils.isBoxed(cls)) {
            if (cls == Byte.TYPE || cls == Byte.class) {
                return new Expression.Invoke(buffer, "readByte", TypeUtils.PRIMITIVE_BYTE_TYPE);
            }
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                return new Expression.Invoke(buffer, "readBoolean", TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
            }
            if (cls == Character.TYPE || cls == Character.class) {
                return this.readChar(buffer);
            }
            if (cls == Short.TYPE || cls == Short.class) {
                return this.readInt16(buffer);
            }
            if (cls == Integer.TYPE || cls == Integer.class) {
                return this.fury.compressInt() ? this.readVarInt32(buffer) : this.readInt32(buffer);
            }
            if (cls == Long.TYPE || cls == Long.class) {
                return PrimitiveSerializers.LongSerializer.readInt64(buffer, this.fury.longEncoding());
            }
            if (cls == Float.TYPE || cls == Float.class) {
                return this.readFloat32(buffer);
            }
            if (cls == Double.TYPE || cls == Double.class) {
                return this.readFloat64(buffer);
            }
            throw new IllegalStateException("impossible");
        }
        if (cls == String.class) {
            return this.fury.getStringSerializer().readStringExpr(this.stringSerializerRef, buffer);
        }
        if (this.useCollectionSerialization(typeRef)) {
            obj = this.deserializeForCollection(buffer, typeRef, serializer, invokeHint);
        } else if (this.useMapSerialization(typeRef)) {
            obj = this.deserializeForMap(buffer, typeRef, serializer, invokeHint);
        } else {
            if (serializer != null) {
                return new Expression.Invoke(serializer, "read", TypeUtils.OBJECT_TYPE, buffer);
            }
            if (this.isMonomorphic(cls)) {
                serializer = this.getOrCreateSerializer(cls);
                Class<?> returnType = ReflectionUtils.getReturnType(TypeUtils.getRawType(serializer.type()), "read");
                obj = new Expression.Invoke(serializer, "read", TypeRef.of(returnType), buffer);
            } else {
                obj = this.readForNotNullNonFinal(buffer, typeRef, serializer);
            }
        }
        return obj;
    }

    protected Expression readForNotNullNonFinal(Expression buffer, TypeRef<?> typeRef, Expression serializer) {
        if (serializer == null) {
            Expression classInfo = this.readClassInfo(TypeUtils.getRawType(typeRef), buffer);
            serializer = Expression.Invoke.inlineInvoke(classInfo, "getSerializer", SERIALIZER_TYPE, new Expression[0]);
        }
        return new Expression.Invoke(serializer, "read", TypeUtils.OBJECT_TYPE, buffer);
    }

    protected Expression deserializeForCollection(Expression buffer, TypeRef<?> typeRef, Expression serializer, InvokeHint invokeHint) {
        TypeRef<?> elementType = TypeUtils.getElementType(typeRef);
        if (serializer == null) {
            Class<?> cls = TypeUtils.getRawType(typeRef);
            if (this.isMonomorphic(cls)) {
                serializer = this.getOrCreateSerializer(cls);
            } else {
                Expression classInfo = this.readClassInfo(cls, buffer);
                serializer = ExpressionUtils.invoke(classInfo, "getSerializer", "collectionSerializer", COLLECTION_SERIALIZER_TYPE);
            }
        } else {
            Preconditions.checkArgument(AbstractCollectionSerializer.class.isAssignableFrom(serializer.type().getRawType()), "Expected AbstractCollectionSerializer but got %s", serializer.type(), new Object[0]);
        }
        Expression.Invoke supportHook = Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]);
        Expression.Invoke collection = new Expression.Invoke(serializer, "newCollection", TypeUtils.COLLECTION_TYPE, buffer);
        Expression.Invoke size = new Expression.Invoke(serializer, "getAndClearNumElements", "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression hookRead = this.readCollectionCodegen(buffer, collection, size, elementType);
        hookRead = new Expression.Invoke(serializer, "onCollectionRead", TypeUtils.OBJECT_TYPE, hookRead);
        Expression.If action = new Expression.If(supportHook, new Expression.ListExpression(collection, hookRead), new Expression.Invoke(serializer, "read", TypeUtils.OBJECT_TYPE, buffer), false);
        if (invokeHint != null && invokeHint.genNewMethod) {
            invokeHint.add(buffer);
            return ExpressionOptimizer.invokeGenerated(this.ctx, invokeHint.cutPoints, new Expression.ListExpression(action, new Expression.Return(action)), "readCollection", false);
        }
        return action;
    }

    protected Expression readCollectionCodegen(Expression buffer, Expression collection, Expression size, TypeRef<?> elementType) {
        Expression.ListExpression builder = new Expression.ListExpression(new Expression[0]);
        Expression.Invoke flags = new Expression.Invoke(buffer, "readByte", "flags", TypeUtils.PRIMITIVE_INT_TYPE, false, new Expression[0]);
        builder.add(flags);
        Class<?> elemClass = TypeUtils.getRawType(elementType);
        this.walkPath.add(elementType.toString());
        boolean finalType = this.isMonomorphic(elemClass);
        boolean trackingRef = this.visitFury(fury -> fury.getClassResolver().needToWriteRef(elementType));
        if (finalType) {
            if (trackingRef) {
                builder.add(this.readContainerElements(elementType, true, null, null, buffer, collection, size));
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(CollectionFlags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags.inline(), hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add((Expression)hasNull, this.readContainerElements(elementType, false, null, hasNull, buffer, collection, size));
            }
        } else {
            Expression.If action;
            Expression.Literal notSameTypeFlag = Expression.Literal.ofInt(CollectionFlags.NOT_SAME_TYPE);
            Expression.Comparator sameElementClass = ExpressionUtils.neq((Expression)new Expression.BitAnd(flags, notSameTypeFlag), (Expression)notSameTypeFlag, "sameElementClass");
            Expression.Literal notDeclTypeFlag = Expression.Literal.ofInt(CollectionFlags.NOT_DECL_ELEMENT_TYPE);
            Expression.Comparator isDeclType = ExpressionUtils.neq(new Expression.BitAnd(flags, notDeclTypeFlag), notDeclTypeFlag);
            Expression.Invoke serializer = Expression.Invoke.inlineInvoke(this.readClassInfo(elemClass, buffer), "getSerializer", SERIALIZER_TYPE, new Expression[0]);
            TypeRef<?> serializerType = this.getSerializerType(elementType);
            boolean maybeDecl = this.visitFury(f -> f.getClassResolver().isSerializable(elemClass));
            Expression elemSerializer = maybeDecl ? new Expression.If(isDeclType, ExpressionUtils.cast(this.getOrCreateSerializer(elemClass), serializerType), ExpressionUtils.cast(serializer.inline(), serializerType), false, serializerType) : ExpressionUtils.cast(serializer.inline(), serializerType);
            elemSerializer = ExpressionUtils.uninline(elemSerializer);
            builder.add(sameElementClass);
            if (trackingRef) {
                Expression.ListExpression readBuilder = new Expression.ListExpression(new Expression[]{elemSerializer});
                readBuilder.add(this.readContainerElements(elementType, true, elemSerializer, null, buffer, collection, size));
                HashSet<Expression> cutPoint = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, collection, size);
                Expression differentElemTypeRead = ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, this.readContainerElements(elementType, true, null, null, buffer, collection, size), "differentTypeElemsRead", false);
                action = new Expression.If(sameElementClass, readBuilder, differentElemTypeRead);
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(CollectionFlags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags, hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add(hasNull);
                Expression.ListExpression readBuilder = new Expression.ListExpression(new Expression[]{elemSerializer});
                readBuilder.add(this.readContainerElements(elementType, false, elemSerializer, hasNull, buffer, collection, size));
                HashSet<Expression> cutPoint = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, collection, size, hasNull);
                Expression differentTypeElemsRead = ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, this.readContainerElements(elementType, false, null, hasNull, buffer, collection, size), "differentTypeElemsRead", false);
                action = new Expression.If(sameElementClass, readBuilder, differentTypeElemsRead);
            }
            builder.add(action);
        }
        this.walkPath.removeLast();
        return new Expression.ListExpression(size, collection, new Expression.If(ExpressionUtils.gt(size, Expression.Literal.ofInt(0)), builder), collection);
    }

    private Expression readContainerElements(TypeRef<?> elementType, boolean trackingRef, Expression serializer, Expression hasNull, Expression buffer, Expression collection, Expression size) {
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of("collection", collection, BUFFER_NAME, buffer, "hasNull", hasNull, "serializer", serializer);
        Expression.Literal start = new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Literal step = new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE);
        return new Expression.ForLoop(start, size, step, i -> this.readContainerElement(exprHolder.get(BUFFER_NAME), elementType, trackingRef, exprHolder.get("hasNull"), exprHolder.get("serializer"), v -> new Expression.Invoke(exprHolder.get("collection"), "add", ExpressionUtils.inline(v))));
    }

    private Expression readContainerElement(Expression buffer, TypeRef<?> elementType, boolean trackingRef, Expression hasNull, Expression elemSerializer, Function<Expression, Expression> callback) {
        Expression read;
        boolean genNewMethod = this.useCollectionSerialization(elementType) || this.useMapSerialization(elementType);
        InvokeHint invokeHint = new InvokeHint(genNewMethod, buffer);
        Class<?> rawType = TypeUtils.getRawType(elementType);
        boolean finalType = this.isMonomorphic(rawType);
        if (finalType) {
            if (trackingRef) {
                read = this.deserializeFor(buffer, elementType, callback, invokeHint);
            } else {
                invokeHint.add(hasNull);
                read = new Expression.If(hasNull, this.deserializeFor(buffer, elementType, callback, invokeHint.copy()), callback.apply(this.deserializeForNotNull(buffer, elementType, invokeHint.copy())));
            }
        } else {
            invokeHint.add(elemSerializer);
            if (trackingRef) {
                read = this.readRef(buffer, callback, () -> this.deserializeForNotNull(buffer, elementType, elemSerializer, invokeHint));
            } else {
                invokeHint.add(hasNull);
                read = new Expression.If(hasNull, this.readNullable(buffer, elementType, callback, () -> this.deserializeForNotNull(buffer, elementType, elemSerializer, invokeHint.copy())), callback.apply(this.deserializeForNotNull(buffer, elementType, elemSerializer, invokeHint.copy())));
            }
        }
        return read;
    }

    protected Expression deserializeForMap(Expression buffer, TypeRef<?> typeRef, Expression serializer, InvokeHint invokeHint) {
        Tuple2<TypeRef<?>, TypeRef<?>> keyValueType = TypeUtils.getMapKeyValueType(typeRef);
        TypeRef keyType = (TypeRef)keyValueType.f0;
        TypeRef valueType = (TypeRef)keyValueType.f1;
        if (serializer == null) {
            Class<?> cls = TypeUtils.getRawType(typeRef);
            if (this.isMonomorphic(cls)) {
                serializer = this.getOrCreateSerializer(cls);
            } else {
                Expression classInfo = this.readClassInfo(cls, buffer);
                serializer = ExpressionUtils.invoke(classInfo, "getSerializer", "mapSerializer", MAP_SERIALIZER_TYPE);
            }
        } else {
            Preconditions.checkArgument(AbstractMapSerializer.class.isAssignableFrom(serializer.type().getRawType()), "Expected AbstractMapSerializer but got %s", serializer.type(), new Object[0]);
        }
        Expression mapSerializer = serializer;
        Expression.Invoke supportHook = Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression.Invoke newMap = new Expression.Invoke(serializer, "newMap", TypeUtils.MAP_TYPE, buffer);
        Expression.Invoke size = new Expression.Invoke(serializer, "getAndClearNumElements", "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.If chunkHeader = new Expression.If(ExpressionUtils.eq(size, Expression.Literal.ofInt(0)), Expression.Literal.ofInt(0), Expression.Invoke.inlineInvoke(buffer, "readUnsignedByte", TypeUtils.PRIMITIVE_INT_TYPE, new Expression[0]));
        expressions.add((Expression)newMap, size, chunkHeader);
        Class keyCls = keyType.getRawType();
        Class valueCls = valueType.getRawType();
        boolean keyMonomorphic = this.isMonomorphic(keyCls);
        boolean valueMonomorphic = this.isMonomorphic(valueCls);
        boolean refKey = this.needWriteRef(keyType);
        boolean refValue = this.needWriteRef(valueType);
        boolean inline = keyMonomorphic && valueMonomorphic && (!refKey || !refValue);
        Tuple2<Expression, Expression> mapKVSerializer = this.getMapKVSerializer(keyCls, valueCls);
        Expression keySerializer = (Expression)mapKVSerializer.f0;
        Expression valueSerializer = (Expression)mapKVSerializer.f1;
        Expression.While chunksLoop = new Expression.While((Expression)ExpressionUtils.gt(size, Expression.Literal.ofInt(0)), () -> {
            Expression.ListExpression exprs = new Expression.ListExpression(new Expression[0]);
            String method = "readJavaNullChunk";
            if (keyMonomorphic && valueMonomorphic && !refKey && !refValue) {
                method = "readNullChunkKVFinalNoRef";
            }
            Expression.Invoke sizeAndHeader = new Expression.Invoke(mapSerializer, method, "sizeAndHeader", TypeUtils.PRIMITIVE_LONG_TYPE, false, buffer, newMap, chunkHeader, size, keySerializer, valueSerializer);
            exprs.add((Expression)new Expression.Assign(chunkHeader, ExpressionUtils.cast(ExpressionUtils.bitand(sizeAndHeader, Expression.Literal.ofInt(255)), TypeUtils.PRIMITIVE_INT_TYPE)), new Expression.Assign(size, ExpressionUtils.cast(ExpressionUtils.shift(">>>", sizeAndHeader, 8), TypeUtils.PRIMITIVE_INT_TYPE)));
            exprs.add(new Expression.If(ExpressionUtils.eq(size, Expression.Literal.ofInt(0)), new Expression.Break()));
            Expression sizeAndHeader2 = this.readChunk(buffer, newMap, size, keyType, valueType, chunkHeader);
            if (inline) {
                exprs.add(sizeAndHeader2);
            } else {
                exprs.add((Expression)new Expression.Assign(chunkHeader, ExpressionUtils.cast(ExpressionUtils.bitand(sizeAndHeader2, Expression.Literal.ofInt(255)), TypeUtils.PRIMITIVE_INT_TYPE)), new Expression.Assign(size, ExpressionUtils.cast(ExpressionUtils.shift(">>>", sizeAndHeader2, 8), TypeUtils.PRIMITIVE_INT_TYPE)));
            }
            return exprs;
        });
        expressions.add((Expression)chunksLoop, newMap);
        Expression.Invoke map = Expression.Invoke.inlineInvoke(serializer, "onMapRead", TypeUtils.OBJECT_TYPE, expressions);
        Expression.If action = new Expression.If(supportHook, map, new Expression.Invoke(serializer, "read", TypeUtils.OBJECT_TYPE, buffer), false);
        if (invokeHint != null && invokeHint.genNewMethod) {
            invokeHint.add(buffer);
            invokeHint.add(serializer);
            return ExpressionOptimizer.invokeGenerated(this.ctx, invokeHint.cutPoints, new Expression.ListExpression(action, new Expression.Return(action)), "readMap", false);
        }
        return action;
    }

    private Expression readChunk(Expression buffer, Expression map, Expression size, TypeRef<?> keyType, TypeRef<?> valueType, Expression chunkHeader) {
        Expression valueSerializer;
        Expression keySerializer;
        boolean keyMonomorphic = this.isMonomorphic(keyType);
        boolean valueMonomorphic = this.isMonomorphic(valueType);
        Class<?> keyTypeRawType = keyType.getRawType();
        Class<?> valueTypeRawType = valueType.getRawType();
        boolean trackingKeyRef = this.needWriteRef(keyType);
        boolean trackingValueRef = this.needWriteRef(valueType);
        boolean inline = keyMonomorphic && valueMonomorphic && (!trackingKeyRef || !trackingValueRef);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[]{buffer});
        Expression.Comparator trackKeyRef = ExpressionUtils.neq(ExpressionUtils.bitand(chunkHeader, Expression.Literal.ofInt(MapFlags.TRACKING_KEY_REF)), Expression.Literal.ofInt(0));
        Expression.Comparator trackValueRef = ExpressionUtils.neq(ExpressionUtils.bitand(chunkHeader, Expression.Literal.ofInt(MapFlags.TRACKING_VALUE_REF)), Expression.Literal.ofInt(0));
        Expression.Comparator keyIsDeclaredType = ExpressionUtils.neq(ExpressionUtils.bitand(chunkHeader, Expression.Literal.ofInt(MapFlags.KEY_DECL_TYPE)), Expression.Literal.ofInt(0));
        Expression.Comparator valueIsDeclaredType = ExpressionUtils.neq(ExpressionUtils.bitand(chunkHeader, Expression.Literal.ofInt(MapFlags.VALUE_DECL_TYPE)), Expression.Literal.ofInt(0));
        Expression.Invoke chunkSize = new Expression.Invoke(buffer, "readUnsignedByte", "chunkSize", TypeUtils.PRIMITIVE_INT_TYPE);
        expressions.add(chunkSize);
        if (!keyMonomorphic && !valueMonomorphic) {
            keySerializer = this.readOrGetSerializerForDeclaredType(buffer, keyTypeRawType, keyIsDeclaredType);
            valueSerializer = this.readOrGetSerializerForDeclaredType(buffer, valueTypeRawType, valueIsDeclaredType);
        } else if (!keyMonomorphic) {
            keySerializer = this.readOrGetSerializerForDeclaredType(buffer, keyTypeRawType, keyIsDeclaredType);
            valueSerializer = this.getOrCreateSerializer(valueTypeRawType);
        } else if (!valueMonomorphic) {
            keySerializer = this.getOrCreateSerializer(keyTypeRawType);
            valueSerializer = this.readOrGetSerializerForDeclaredType(buffer, valueTypeRawType, valueIsDeclaredType);
        } else {
            keySerializer = this.getOrCreateSerializer(keyTypeRawType);
            valueSerializer = this.getOrCreateSerializer(valueTypeRawType);
        }
        Expression keySerializerExpr = ExpressionUtils.uninline(keySerializer);
        Expression valueSerializerExpr = ExpressionUtils.uninline(valueSerializer);
        expressions.add(keySerializerExpr, valueSerializerExpr);
        Expression.ForLoop readKeyValues = new Expression.ForLoop(Expression.Literal.ofInt(0), chunkSize, Expression.Literal.ofInt(1), i -> {
            boolean genKeyMethod = this.useCollectionSerialization(keyType) || this.useMapSerialization(keyType);
            boolean genValueMethod = this.useCollectionSerialization(valueType) || this.useMapSerialization(valueType);
            this.walkPath.add("key:" + keyType);
            InvokeHint keyHint = new InvokeHint(genKeyMethod, new Expression[0]);
            InvokeHint valueHint = new InvokeHint(genValueMethod, new Expression[0]);
            if (genKeyMethod) {
                keyHint.add(keySerializerExpr);
            }
            if (genValueMethod) {
                valueHint.add(valueSerializer);
            }
            Expression keyAction = trackingKeyRef ? new Expression.If(trackKeyRef, this.readRef(buffer, expr -> expr, () -> this.deserializeForNotNull(buffer, keyType, keySerializerExpr, keyHint)), this.deserializeForNotNull(buffer, keyType, keySerializerExpr, keyHint), false) : this.deserializeForNotNull(buffer, keyType, keySerializerExpr, keyHint);
            this.walkPath.removeLast();
            this.walkPath.add("value:" + valueType);
            Expression valueAction = trackingValueRef ? new Expression.If(trackValueRef, this.readRef(buffer, expr -> expr, () -> this.deserializeForNotNull(buffer, valueType, valueSerializerExpr, valueHint)), this.deserializeForNotNull(buffer, valueType, valueSerializerExpr, valueHint), false) : this.deserializeForNotNull(buffer, valueType, valueSerializerExpr, valueHint);
            this.walkPath.removeLast();
            return ExpressionUtils.list(new Expression.Invoke(map, "put", keyAction, valueAction), new Expression.Assign(size, ExpressionUtils.subtract(size, Expression.Literal.ofInt(1))));
        });
        expressions.add(readKeyValues);
        if (inline) {
            expressions.add(new Expression.If(ExpressionUtils.gt(size, Expression.Literal.ofInt(0)), new Expression.Assign(chunkHeader, Expression.Invoke.inlineInvoke(buffer, "readUnsignedByte", TypeUtils.PRIMITIVE_INT_TYPE, new Expression[0]))));
            return expressions;
        }
        Expression.If returnSizeAndHeader = new Expression.If(ExpressionUtils.gt(size, Expression.Literal.ofInt(0)), new Expression.Return(ExpressionUtils.bitor(ExpressionUtils.shift("<<", size, 8), Expression.Invoke.inlineInvoke(buffer, "readUnsignedByte", TypeUtils.PRIMITIVE_INT_TYPE, new Expression[0]))), new Expression.Return(Expression.Literal.ofInt(0)));
        expressions.add(returnSizeAndHeader);
        HashSet<Expression> params = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(buffer, size, chunkHeader, map);
        return ExpressionOptimizer.invokeGenerated(this.ctx, params, expressions, "readChunk", false);
    }

    private Expression readOrGetSerializerForDeclaredType(Expression buffer, Class<?> type, Expression isDeclaredType) {
        if (this.isMonomorphic(type)) {
            return this.getOrCreateSerializer(type);
        }
        TypeRef<?> serializerType = this.getSerializerType(type);
        if (ReflectionUtils.isAbstract(type) || type.isInterface()) {
            return ExpressionUtils.invoke(this.readClassInfo(type, buffer), "getSerializer", "serializer", serializerType);
        }
        return new Expression.If(isDeclaredType, this.getOrCreateSerializer(type), ExpressionUtils.invokeInline(this.readClassInfo(type, buffer), "getSerializer", serializerType), false);
    }

    @Override
    protected Expression beanClassExpr() {
        if (GraalvmSupport.isGraalBuildtime()) {
            return this.staticBeanClassExpr();
        }
        return new Expression.Reference("super.type", TypeUtils.CLASS_TYPE);
    }

    protected static class InvokeHint {
        public boolean genNewMethod;
        public Set<Expression> cutPoints = new HashSet<Expression>();

        public InvokeHint(boolean genNewMethod, Expression ... cutPoints) {
            this.genNewMethod = genNewMethod;
            Collections.addAll(this.cutPoints, cutPoints);
        }

        public InvokeHint add(Expression cutPoint) {
            if (cutPoint != null) {
                this.cutPoints.add(cutPoint);
            }
            return this;
        }

        public InvokeHint copy() {
            InvokeHint invokeHint = new InvokeHint(this.genNewMethod, new Expression[0]);
            invokeHint.cutPoints = new HashSet<Expression>(this.cutPoints);
            return invokeHint;
        }

        public String toString() {
            return "InvokeHint{genNewMethod=" + this.genNewMethod + ", cutPoints=" + this.cutPoints + '}';
        }
    }
}

