/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.builder.BaseObjectCodecBuilder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.builder.Generated;
import me.mrnavastar.protoweaver.libs.org.apache.fury.builder.ObjectCodecOptimizer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.Code;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.CodegenContext;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.Expression;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.ExpressionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.ExpressionVisitor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.TypeRef;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.ObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.PrimitiveSerializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.Descriptor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.DescriptorGrouper;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.TypeUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.function.SerializableSupplier;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.record.RecordUtils;

public class ObjectCodecBuilder
extends BaseObjectCodecBuilder {
    public static final String BUFFER_NAME = "buffer";
    private final Expression.Literal classVersionHash;
    protected ObjectCodecOptimizer objectCodecOptimizer;
    protected Map<String, Integer> recordReversedMapping;

    public ObjectCodecBuilder(Class<?> beanClass, Fury fury) {
        super(TypeRef.of(beanClass), fury, Generated.GeneratedObjectSerializer.class);
        boolean shareMeta = fury.getConfig().isMetaShareEnabled();
        Collection<Descriptor> descriptors = shareMeta ? (Collection<Descriptor>)this.visitFury(f -> f.getClassResolver().getClassDef(beanClass, true).getDescriptors(this.classResolver, beanClass)) : fury.getClassResolver().getAllDescriptorsMap(beanClass, true).values();
        this.classVersionHash = new Expression.Literal(ObjectSerializer.computeVersionHash(descriptors), TypeUtils.PRIMITIVE_INT_TYPE);
        DescriptorGrouper grouper = DescriptorGrouper.createDescriptorGrouper(fury.getClassResolver()::isMonomorphic, descriptors, false, fury.compressInt(), fury.compressLong());
        this.objectCodecOptimizer = new ObjectCodecOptimizer(beanClass, grouper, !fury.isBasicTypesRefIgnored(), this.ctx);
        if (this.isRecord) {
            if (!this.recordCtrAccessible) {
                this.buildRecordComponentDefaultValues();
            }
            this.recordReversedMapping = RecordUtils.buildFieldToComponentMapping(beanClass);
        }
    }

    protected ObjectCodecBuilder(TypeRef<?> beanType, Fury fury, Class<?> superSerializerClass) {
        super(beanType, fury, superSerializerClass);
        this.classVersionHash = null;
        if (this.isRecord) {
            if (!this.recordCtrAccessible) {
                this.buildRecordComponentDefaultValues();
            }
            this.recordReversedMapping = RecordUtils.buildFieldToComponentMapping(this.beanClass);
        }
    }

    @Override
    protected String codecSuffix() {
        return "";
    }

    @Override
    protected void addCommonImports() {
        super.addCommonImports();
        this.ctx.addImport(Generated.GeneratedObjectSerializer.class);
    }

    @Override
    protected boolean isMonomorphic(Class<?> clz) {
        return this.visitFury(f -> f.getClassResolver().isMonomorphic(clz));
    }

    @Override
    public Expression buildEncodeExpression() {
        Expression.Reference inputObject = new Expression.Reference("obj", TypeUtils.OBJECT_TYPE, false);
        Expression.Reference buffer = new Expression.Reference(BUFFER_NAME, bufferTypeRef, false);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression bean = this.tryCastIfPublic((Expression)inputObject, this.beanType, this.ctx.newName(this.beanClass));
        expressions.add(bean);
        if (this.fury.checkClassVersion()) {
            expressions.add(new Expression.Invoke((Expression)buffer, "writeInt32", this.classVersionHash));
        }
        expressions.addAll(this.serializePrimitives(bean, buffer, this.objectCodecOptimizer.primitiveGroups));
        int numGroups = this.getNumGroups(this.objectCodecOptimizer);
        this.addGroupExpressions(this.objectCodecOptimizer.boxedWriteGroups, numGroups, expressions, bean, buffer);
        this.addGroupExpressions(this.objectCodecOptimizer.finalWriteGroups, numGroups, expressions, bean, buffer);
        this.addGroupExpressions(this.objectCodecOptimizer.otherWriteGroups, numGroups, expressions, bean, buffer);
        for (Descriptor descriptor : this.objectCodecOptimizer.descriptorGrouper.getCollectionDescriptors()) {
            expressions.add(this.serializeGroup(Collections.singletonList(descriptor), bean, buffer, false));
        }
        for (Descriptor d : this.objectCodecOptimizer.descriptorGrouper.getMapDescriptors()) {
            expressions.add(this.serializeGroup(Collections.singletonList(d), bean, buffer, false));
        }
        return expressions;
    }

    private void addGroupExpressions(List<List<Descriptor>> writeGroup, int numGroups, Expression.ListExpression expressions, Expression bean, Expression.Reference buffer) {
        for (List<Descriptor> group : writeGroup) {
            if (group.isEmpty()) continue;
            boolean inline = group.size() == 1 && numGroups < 10;
            expressions.add(this.serializeGroup(group, bean, buffer, inline));
        }
    }

    private int getNumGroups(ObjectCodecOptimizer objectCodecOptimizer) {
        return objectCodecOptimizer.boxedWriteGroups.size() + objectCodecOptimizer.finalWriteGroups.size() + objectCodecOptimizer.otherWriteGroups.size() + objectCodecOptimizer.descriptorGrouper.getCollectionDescriptors().size() + objectCodecOptimizer.descriptorGrouper.getMapDescriptors().size();
    }

    private Expression serializeGroup(List<Descriptor> group, Expression bean, Expression buffer, boolean inline) {
        SerializableSupplier expressionSupplier = () -> {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor d : group) {
                Expression fieldValue = this.getFieldValue(bean, d);
                this.walkPath.add(d.getDeclaringClass() + d.getName());
                Expression fieldExpr = this.serializeFor(fieldValue, buffer, d.getTypeRef());
                this.walkPath.removeLast();
                groupExpressions.add(fieldExpr);
            }
            return groupExpressions;
        };
        if (inline) {
            return (Expression)expressionSupplier.get();
        }
        return this.objectCodecOptimizer.invokeGenerated(expressionSupplier, "writeFields");
    }

    private List<Expression> serializePrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups) {
        int totalSize = this.getTotalSizeOfPrimitives(primitiveGroups);
        if (totalSize == 0) {
            return new ArrayList<Expression>();
        }
        if (this.fury.compressInt() || this.fury.compressLong()) {
            return this.serializePrimitivesCompressed(bean, buffer, primitiveGroups, totalSize);
        }
        return this.serializePrimitivesUnCompressed(bean, buffer, primitiveGroups, totalSize);
    }

    protected int getNumPrimitiveFields(List<List<Descriptor>> primitiveGroups) {
        return primitiveGroups.stream().mapToInt(List::size).sum();
    }

    private List<Expression> serializePrimitivesUnCompressed(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups, int totalSize) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        Expression.Literal totalSizeLiteral = new Expression.Literal(totalSize, TypeUtils.PRIMITIVE_INT_TYPE);
        expressions.add(new Expression.Invoke(buffer, "grow", totalSizeLiteral));
        Expression.Invoke base = new Expression.Invoke(buffer, "getHeapMemory", "base", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        Expression.Invoke writerAddr = new Expression.Invoke(buffer, "_unsafeWriterAddress", "writerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
        expressions.add(base);
        expressions.add(writerAddr);
        int acc = 0;
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor descriptor : group) {
                Class<?> clz = descriptor.getRawType();
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                Expression fieldValue = this.getFieldValue(bean, descriptor);
                if (fieldValue instanceof Expression.Inlineable) {
                    ((Expression.Inlineable)fieldValue).inline();
                }
                if (clz == Byte.TYPE) {
                    groupExpressions.add(this.unsafePut(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Boolean.TYPE) {
                    groupExpressions.add(this.unsafePutBoolean(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Character.TYPE) {
                    groupExpressions.add(this.unsafePutChar(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Short.TYPE) {
                    groupExpressions.add(this.unsafePutShort(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Integer.TYPE) {
                    groupExpressions.add(this.unsafePutInt(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 4;
                    continue;
                }
                if (clz == Long.TYPE) {
                    groupExpressions.add(this.unsafePutLong(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 8;
                    continue;
                }
                if (clz == Float.TYPE) {
                    groupExpressions.add(this.unsafePutFloat(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 4;
                    continue;
                }
                if (clz == Double.TYPE) {
                    groupExpressions.add(this.unsafePutDouble(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 8;
                    continue;
                }
                throw new IllegalStateException("impossible");
            }
            if (numPrimitiveFields < 4) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(bean, base, writerAddr), groupExpressions, "writeFields"));
        }
        Expression.Invoke increaseWriterIndex = new Expression.Invoke(buffer, "_increaseWriterIndexUnsafe", new Expression.Literal(totalSizeLiteral, TypeUtils.PRIMITIVE_INT_TYPE));
        expressions.add(increaseWriterIndex);
        return expressions;
    }

    private List<Expression> serializePrimitivesCompressed(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups, int totalSize) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int extraSize = 0;
        for (List<Descriptor> group : primitiveGroups) {
            for (Descriptor d : group) {
                if (d.getRawType() == Integer.TYPE) {
                    extraSize += 4;
                    continue;
                }
                if (d.getRawType() != Long.TYPE) continue;
                ++extraSize;
            }
        }
        int growSize = totalSize + extraSize;
        expressions.add(new Expression.Invoke(buffer, "grow", Expression.Literal.ofInt(growSize)));
        Expression.Invoke base = new Expression.Invoke(buffer, "getHeapMemory", "base", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        expressions.add(base);
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            Expression.Invoke writerAddr = new Expression.Invoke(buffer, "_unsafeWriterAddress", "writerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
            int acc = 0;
            boolean compressStarted = false;
            for (Descriptor descriptor : group) {
                Class<?> clz = descriptor.getRawType();
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                Expression fieldValue = this.getFieldValue(bean, descriptor);
                if (fieldValue instanceof Expression.Inlineable) {
                    ((Expression.Inlineable)fieldValue).inline();
                }
                if (clz == Byte.TYPE) {
                    groupExpressions.add(this.unsafePut(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Boolean.TYPE) {
                    groupExpressions.add(this.unsafePutBoolean(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Character.TYPE) {
                    groupExpressions.add(this.unsafePutChar(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Short.TYPE) {
                    groupExpressions.add(this.unsafePutShort(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Float.TYPE) {
                    groupExpressions.add(this.unsafePutFloat(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 4;
                    continue;
                }
                if (clz == Double.TYPE) {
                    groupExpressions.add(this.unsafePutDouble(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 8;
                    continue;
                }
                if (clz == Integer.TYPE) {
                    if (!this.fury.compressInt()) {
                        groupExpressions.add(this.unsafePutInt(base, this.getWriterPos(writerAddr, acc), fieldValue));
                        acc += 4;
                        continue;
                    }
                    if (!compressStarted) {
                        this.addIncWriterIndexExpr(groupExpressions, buffer, acc);
                        compressStarted = true;
                    }
                    groupExpressions.add(new Expression.Invoke(buffer, "_unsafeWriteVarInt32", fieldValue));
                    acc += 0;
                    continue;
                }
                if (clz == Long.TYPE) {
                    if (!this.fury.compressLong()) {
                        groupExpressions.add(this.unsafePutLong(base, this.getWriterPos(writerAddr, acc), fieldValue));
                        acc += 8;
                        continue;
                    }
                    if (!compressStarted) {
                        this.addIncWriterIndexExpr(groupExpressions, buffer, acc);
                        compressStarted = true;
                    }
                    groupExpressions.add(PrimitiveSerializers.LongSerializer.writeInt64(buffer, fieldValue, this.fury.longEncoding(), false));
                    continue;
                }
                throw new IllegalStateException("impossible");
            }
            if (!compressStarted) {
                this.addIncWriterIndexExpr(groupExpressions, buffer, acc);
            }
            if (numPrimitiveFields < 4) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(bean, buffer, base), groupExpressions, "writeFields"));
        }
        return expressions;
    }

    private void addIncWriterIndexExpr(Expression.ListExpression expressions, Expression buffer, int diff) {
        if (diff != 0) {
            expressions.add(new Expression.Invoke(buffer, "_increaseWriterIndexUnsafe", Expression.Literal.ofInt(diff)));
        }
    }

    private int getTotalSizeOfPrimitives(List<List<Descriptor>> primitiveGroups) {
        return primitiveGroups.stream().flatMap(Collection::stream).mapToInt(d -> TypeUtils.getSizeOfPrimitiveType(d.getRawType())).sum();
    }

    private Expression getWriterPos(Expression writerPos, long acc) {
        if (acc == 0L) {
            return writerPos;
        }
        return ExpressionUtils.add(writerPos, Expression.Literal.ofLong(acc));
    }

    @Override
    public Expression buildDecodeExpression() {
        Expression bean;
        Expression.Reference buffer = new Expression.Reference(BUFFER_NAME, bufferTypeRef, false);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        if (this.fury.checkClassVersion()) {
            expressions.add(this.checkClassVersion(buffer));
        }
        if (!this.isRecord) {
            bean = this.newBean();
            Expression.Invoke referenceObject = new Expression.Invoke((Expression)this.refResolverRef, "reference", TypeUtils.PRIMITIVE_VOID_TYPE, bean);
            expressions.add(bean);
            expressions.add(referenceObject);
        } else {
            bean = this.recordCtrAccessible ? new FieldsCollector() : this.buildComponentsArray();
        }
        expressions.addAll(this.deserializePrimitives(bean, buffer, this.objectCodecOptimizer.primitiveGroups));
        int numGroups = this.getNumGroups(this.objectCodecOptimizer);
        this.deserializeReadGroup(this.objectCodecOptimizer.boxedReadGroups, numGroups, expressions, bean, buffer);
        this.deserializeReadGroup(this.objectCodecOptimizer.finalReadGroups, numGroups, expressions, bean, buffer);
        this.deserializeReadGroup(this.objectCodecOptimizer.otherReadGroups, numGroups, expressions, bean, buffer);
        for (Descriptor d : this.objectCodecOptimizer.descriptorGrouper.getCollectionDescriptors()) {
            expressions.add(this.deserializeGroup(Collections.singletonList(d), bean, buffer, false));
        }
        for (Descriptor d : this.objectCodecOptimizer.descriptorGrouper.getMapDescriptors()) {
            expressions.add(this.deserializeGroup(Collections.singletonList(d), bean, buffer, false));
        }
        if (this.isRecord) {
            if (this.recordCtrAccessible) {
                assert (bean instanceof FieldsCollector);
                FieldsCollector collector = (FieldsCollector)bean;
                bean = this.createRecord(collector.recordValuesMap);
            } else {
                bean = new Expression.StaticInvoke(RecordUtils.class, "invokeRecordCtrHandle", TypeUtils.OBJECT_TYPE, this.getRecordCtrHandle(), bean);
            }
        }
        expressions.add(new Expression.Return(bean));
        return expressions;
    }

    private void deserializeReadGroup(List<List<Descriptor>> readGroups, int numGroups, Expression.ListExpression expressions, Expression bean, Expression.Reference buffer) {
        for (List<Descriptor> group : readGroups) {
            if (group.isEmpty()) continue;
            boolean inline = group.size() == 1 && numGroups < 10;
            expressions.add(this.deserializeGroup(group, bean, buffer, inline));
        }
    }

    protected Expression buildComponentsArray() {
        return new Expression.StaticInvoke(Platform.class, "copyObjectArray", TypeUtils.OBJECT_ARRAY_TYPE, recordComponentDefaultValues);
    }

    protected Expression createRecord(SortedMap<Integer, Expression> recordComponents) {
        Expression[] params = recordComponents.values().toArray(new Expression[0]);
        return new Expression.NewInstance(this.beanType, params);
    }

    @Override
    protected Expression setFieldValue(Expression bean, Descriptor d, Expression value) {
        if (this.isRecord) {
            if (this.recordCtrAccessible) {
                if (value instanceof Expression.Inlineable) {
                    ((Expression.Inlineable)value).inline(false);
                }
                int index = this.recordReversedMapping.get(d.getName());
                FieldsCollector collector = (FieldsCollector)bean;
                collector.recordValuesMap.put(index, value);
                return value;
            }
            int index = this.recordReversedMapping.get(d.getName());
            return new Expression.AssignArrayElem(bean, value, Expression.Literal.ofInt(index));
        }
        return super.setFieldValue(bean, d, value);
    }

    protected Expression deserializeGroup(List<Descriptor> group, Expression bean, Expression buffer, boolean inline) {
        if (this.isRecord) {
            return this.deserializeGroupForRecord(group, bean, buffer);
        }
        SerializableSupplier exprSupplier = () -> {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor d : group) {
                ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of("bean", bean);
                this.walkPath.add(d.getDeclaringClass() + d.getName());
                Expression action = this.deserializeFor(buffer, d.getTypeRef(), expr -> this.setFieldValue(exprHolder.get("bean"), d, this.tryInlineCast((Expression)expr, d.getTypeRef())));
                this.walkPath.removeLast();
                groupExpressions.add(action);
            }
            return groupExpressions;
        };
        if (inline) {
            return (Expression)exprSupplier.get();
        }
        return this.objectCodecOptimizer.invokeGenerated(exprSupplier, "readFields");
    }

    protected Expression deserializeGroupForRecord(List<Descriptor> group, Expression bean, Expression buffer) {
        Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
        for (Descriptor d : group) {
            Expression v = this.deserializeFor(buffer, d.getTypeRef(), expr -> expr);
            Expression action = this.setFieldValue(bean, d, this.tryInlineCast(v, d.getTypeRef()));
            groupExpressions.add(action);
        }
        return groupExpressions;
    }

    private Expression checkClassVersion(Expression buffer) {
        return new Expression.StaticInvoke(ObjectSerializer.class, "checkClassVersion", TypeUtils.PRIMITIVE_VOID_TYPE, false, this.furyRef, Expression.Invoke.inlineInvoke(buffer, ObjectCodecBuilder.readIntFunc(), TypeUtils.PRIMITIVE_INT_TYPE, new Expression[0]), Objects.requireNonNull(this.classVersionHash));
    }

    private List<Expression> deserializePrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups) {
        int totalSize = this.getTotalSizeOfPrimitives(primitiveGroups);
        if (totalSize == 0) {
            return new ArrayList<Expression>();
        }
        if (this.fury.compressInt() || this.fury.compressLong()) {
            return this.deserializeCompressedPrimitives(bean, buffer, primitiveGroups);
        }
        return this.deserializeUnCompressedPrimitives(bean, buffer, primitiveGroups, totalSize);
    }

    private List<Expression> deserializeUnCompressedPrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups, int totalSize) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        Expression.Literal totalSizeLiteral = Expression.Literal.ofInt(totalSize);
        expressions.add(new Expression.Invoke(buffer, "checkReadableBytes", totalSizeLiteral));
        Expression.Invoke heapBuffer = new Expression.Invoke(buffer, "getHeapMemory", "heapBuffer", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        Expression.Invoke readerAddr = new Expression.Invoke(buffer, "getUnsafeReaderAddress", "readerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
        expressions.add(heapBuffer);
        expressions.add(readerAddr);
        int acc = 0;
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor descriptor : group) {
                Expression fieldValue;
                TypeRef<?> type = descriptor.getTypeRef();
                Class<?> clz = TypeUtils.getRawType(type);
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                if (clz == Byte.TYPE) {
                    fieldValue = this.unsafeGet(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Boolean.TYPE) {
                    fieldValue = this.unsafeGetBoolean(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Character.TYPE) {
                    fieldValue = this.unsafeGetChar(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Short.TYPE) {
                    fieldValue = this.unsafeGetShort(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Integer.TYPE) {
                    fieldValue = this.unsafeGetInt(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 4;
                } else if (clz == Long.TYPE) {
                    fieldValue = this.unsafeGetLong(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 8;
                } else if (clz == Float.TYPE) {
                    fieldValue = this.unsafeGetFloat(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 4;
                } else if (clz == Double.TYPE) {
                    fieldValue = this.unsafeGetDouble(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 8;
                } else {
                    throw new IllegalStateException("impossible");
                }
                groupExpressions.add(this.setFieldValue(bean, descriptor, fieldValue));
            }
            if (numPrimitiveFields < 4 || this.isRecord) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(bean, heapBuffer, readerAddr), groupExpressions, "readFields"));
        }
        Expression.Invoke increaseReaderIndex = new Expression.Invoke(buffer, "increaseReaderIndex", new Expression.Literal(totalSizeLiteral, TypeUtils.PRIMITIVE_INT_TYPE));
        expressions.add(increaseReaderIndex);
        return expressions;
    }

    private List<Expression> deserializeCompressedPrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ReplaceStub checkReadableBytesStub = new Expression.ReplaceStub();
            expressions.add(checkReadableBytesStub);
            Expression.Invoke heapBuffer = new Expression.Invoke(buffer, "getHeapMemory", "heapBuffer", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
            expressions.add(heapBuffer);
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            Expression.Invoke readerAddr = new Expression.Invoke(buffer, "getUnsafeReaderAddress", "readerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
            int acc = 0;
            boolean compressStarted = false;
            for (Descriptor descriptor : group) {
                Expression fieldValue;
                TypeRef<?> type = descriptor.getTypeRef();
                Class<?> clz = TypeUtils.getRawType(type);
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                if (clz == Byte.TYPE) {
                    fieldValue = this.unsafeGet(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Boolean.TYPE) {
                    fieldValue = this.unsafeGetBoolean(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Character.TYPE) {
                    fieldValue = this.unsafeGetChar(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Short.TYPE) {
                    fieldValue = this.unsafeGetShort(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Float.TYPE) {
                    fieldValue = this.unsafeGetFloat(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 4;
                } else if (clz == Double.TYPE) {
                    fieldValue = this.unsafeGetDouble(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 8;
                } else if (clz == Integer.TYPE) {
                    if (!this.fury.compressInt()) {
                        fieldValue = this.unsafeGetInt(heapBuffer, this.getReaderAddress(readerAddr, acc));
                        acc += 4;
                    } else {
                        if (!compressStarted) {
                            compressStarted = true;
                            this.addIncReaderIndexExpr(groupExpressions, buffer, acc);
                        }
                        fieldValue = this.readVarInt32(buffer);
                    }
                } else if (clz == Long.TYPE) {
                    if (!this.fury.compressLong()) {
                        fieldValue = this.unsafeGetLong(heapBuffer, this.getReaderAddress(readerAddr, acc));
                        acc += 8;
                    } else {
                        if (!compressStarted) {
                            compressStarted = true;
                            this.addIncReaderIndexExpr(groupExpressions, buffer, acc);
                        }
                        fieldValue = PrimitiveSerializers.LongSerializer.readInt64(buffer, this.fury.longEncoding());
                    }
                } else {
                    throw new IllegalStateException("impossible");
                }
                groupExpressions.add(this.setFieldValue(bean, descriptor, fieldValue));
            }
            if (acc != 0) {
                checkReadableBytesStub.setTargetObject(new Expression.Invoke(buffer, "checkReadableBytes", Expression.Literal.ofInt(acc)));
            }
            if (!compressStarted) {
                this.addIncReaderIndexExpr(groupExpressions, buffer, acc);
            }
            if (numPrimitiveFields < 4 || this.isRecord) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(bean, buffer, heapBuffer), groupExpressions, "readFields"));
        }
        return expressions;
    }

    private void addIncReaderIndexExpr(Expression.ListExpression expressions, Expression buffer, int diff) {
        if (diff != 0) {
            expressions.add(new Expression.Invoke(buffer, "increaseReaderIndex", Expression.Literal.ofInt(diff)));
        }
    }

    private Expression getReaderAddress(Expression readerPos, long acc) {
        if (acc == 0L) {
            return readerPos;
        }
        return ExpressionUtils.add(readerPos, new Expression.Literal(acc, TypeUtils.PRIMITIVE_LONG_TYPE));
    }

    private class FieldsCollector
    extends Expression.AbstractExpression {
        private final TreeMap<Integer, Expression> recordValuesMap;

        protected FieldsCollector() {
            super(new Expression[0]);
            this.recordValuesMap = new TreeMap();
        }

        @Override
        public TypeRef<?> type() {
            return ObjectCodecBuilder.this.beanType;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            return new Code.ExprCode(Code.LiteralValue.FalseLiteral, Code.variable(TypeUtils.getRawType(ObjectCodecBuilder.this.beanType), "null"));
        }
    }
}

