/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.codegen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.CodegenContext;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.Expression;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.ExpressionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.codegen.ExpressionVisitor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.TypeUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.function.SerializableSupplier;

public class ExpressionOptimizer {
    public static Expression invokeGenerated(CodegenContext ctx, SerializableSupplier<Expression> groupExpressionsGenerator, String methodPrefix) {
        List<Expression> cutPoint = ExpressionUtils.extractCapturedExpressions(groupExpressionsGenerator);
        return ExpressionOptimizer.invokeGenerated(ctx, new HashSet<Expression>(cutPoint), (Expression)groupExpressionsGenerator.get(), methodPrefix, false);
    }

    public static Expression invokeGenerated(CodegenContext ctx, SerializableSupplier<Expression> groupExpressionsGenerator, String methodPrefix, boolean inlineInvoke) {
        List<Expression> cutPoint = ExpressionUtils.extractCapturedExpressions(groupExpressionsGenerator);
        return ExpressionOptimizer.invokeGenerated(ctx, new HashSet<Expression>(cutPoint), (Expression)groupExpressionsGenerator.get(), methodPrefix, inlineInvoke);
    }

    public static Expression invokeGenerated(CodegenContext ctx, Set<Expression> cutPoint, Expression groupExpressions, String methodPrefix, boolean inlineInvoke) {
        return ExpressionOptimizer.invokeGenerated(ctx, new LinkedHashSet<Expression>(cutPoint), groupExpressions, "private", methodPrefix, inlineInvoke);
    }

    public static Expression invokeGenerated(CodegenContext ctx, LinkedHashSet<Expression> cutPoint, Expression groupExpressions, String modifier, String methodPrefix, boolean inlineInvoke) {
        LinkedHashMap<Expression, Expression.Reference> cutExprMap = new LinkedHashMap<Expression, Expression.Reference>();
        for (Expression expression : cutPoint) {
            if (expression == null) continue;
            Preconditions.checkArgument(expression.type() != TypeUtils.PRIMITIVE_VOID_TYPE, "Cut on block is not supported currently.");
            String param = ctx.newName(TypeUtils.getRawType(expression.type()));
            cutExprMap.put(expression, new Expression.Reference(param, expression.type()));
        }
        new ExpressionVisitor().traverseExpression(groupExpressions, exprSite -> {
            if (cutPoint.contains(exprSite.current)) {
                Expression.Reference newExpr = (Expression.Reference)cutExprMap.get(exprSite.current);
                if (exprSite.current != newExpr) {
                    exprSite.update(newExpr);
                }
                return false;
            }
            return true;
        });
        CodegenContext codegenContext = new CodegenContext(ctx.getPackage(), ctx.getValNames(), ctx.getImports());
        for (Expression.Reference reference : cutExprMap.values()) {
            Preconditions.checkArgument(codegenContext.containName(reference.name()));
        }
        String string = ctx.newName(methodPrefix);
        String code = groupExpressions.genCode(codegenContext).code();
        code = codegenContext.optimizeMethodCode(code);
        ArrayList<Object> formalParams = new ArrayList<Object>();
        ArrayList<Expression> actualParams = new ArrayList<Expression>();
        for (Map.Entry entry : cutExprMap.entrySet()) {
            Expression expr = (Expression)entry.getKey();
            Expression.Reference ref = (Expression.Reference)entry.getValue();
            formalParams.add(TypeUtils.getRawType(ref.type()));
            formalParams.add(ref.name());
            actualParams.add(expr);
        }
        ctx.addMethod(modifier, string, code, TypeUtils.getRawType(groupExpressions.type()), formalParams.toArray());
        if (inlineInvoke) {
            return Expression.Invoke.inlineInvoke((Expression)new Expression.Reference("this"), string, groupExpressions.type(), false, actualParams.toArray(new Expression[0]));
        }
        return new Expression.Invoke((Expression)new Expression.Reference("this"), string, "", groupExpressions.type(), false, false, actualParams.toArray(new Expression[0]));
    }
}

