/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.MapEntry;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public class LazyMap<K, V>
implements Map<K, V> {
    private List<Map.Entry<? extends K, ? extends V>> entries;
    private Map<K, V> map;

    public LazyMap() {
        this.entries = new ArrayList<Map.Entry<? extends K, ? extends V>>();
    }

    public LazyMap(int size) {
        this.entries = new ArrayList<Map.Entry<? extends K, ? extends V>>(size);
    }

    public LazyMap(List<Map.Entry<? extends K, ? extends V>> entries) {
        this.entries = entries;
    }

    public Map<K, V> delegate() {
        Map<K, V> m4 = this.map;
        if (m4 == null) {
            List<Map.Entry<K, V>> e = this.entries;
            m4 = new HashMap(e.size());
            for (Map.Entry<K, V> entry : e) {
                m4.put(entry.getKey(), entry.getValue());
            }
            this.map = m4;
        }
        return m4;
    }

    public void setEntries(List<Map.Entry<? extends K, ? extends V>> entries) {
        Preconditions.checkArgument(this.map == null);
        this.entries = entries;
    }

    @Override
    public V put(K key, V value) {
        Map<K, V> m4 = this.map;
        if (m4 == null) {
            this.entries.add(new MapEntry<K, V>(key, value));
            return null;
        }
        return m4.put(key, value);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.delegate().getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Map<? super K, ? super V> m4 = this.map;
        if (m4 == null) {
            for (Map.Entry<K, V> entry : this.entries) {
                action.accept(entry.getKey(), entry.getValue());
            }
        } else {
            m4.forEach(action);
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.delegate().replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.delegate().putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate().remove(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate().remove(key);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.delegate().replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.delegate().replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.delegate().computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.delegate().computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.delegate().compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.delegate().merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public int size() {
        Map<K, V> m4 = this.map;
        return m4 == null ? this.entries.size() : m4.size();
    }

    @Override
    public boolean isEmpty() {
        Map<K, V> m4 = this.map;
        return m4 == null ? this.entries.isEmpty() : m4.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate().get(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        Map<? extends K, ? extends V> map = this.map;
        if (map == null) {
            this.entries.addAll(m4.entrySet());
        } else {
            map.putAll(m4);
        }
    }

    @Override
    public void clear() {
        Map<K, V> m4 = this.map;
        if (m4 == null) {
            this.entries.clear();
        } else {
            m4.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.delegate().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate().entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        Map<K, V> m4 = this.map;
        if (m4 != null) {
            return m4.equals(obj);
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        List<Map.Entry<K, V>> entries = this.entries;
        if (map.size() != entries.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : entries) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? map.get(key) != null || !map.containsKey(key) : !value.equals(map.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        Map<K, V> m4 = this.map;
        if (m4 != null) {
            return m4.hashCode();
        }
        int h2 = 0;
        for (Map.Entry<K, V> entry : this.entries) {
            h2 += entry.hashCode();
        }
        return h2;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entries.iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

