/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.collection;

import me.mrnavastar.protoweaver.libs.org.apache.fury.annotation.Internal;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.FuryObjectMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

@Internal
public final class LongLongMap<V> {
    public int size;
    LongLongKey[] keyTable;
    V[] valueTable;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;

    public LongLongMap(int initialCapacity, float loadFactor) {
        Preconditions.checkArgument(0.0f <= loadFactor && loadFactor <= 1.0f, "loadFactor %s must be > 0 and < 1", Float.valueOf(loadFactor), new Object[0]);
        this.loadFactor = loadFactor;
        int tableSize = FuryObjectMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new LongLongKey[tableSize];
        this.valueTable = new Object[tableSize];
    }

    private int place(long k1, long k2) {
        return (int)((k1 * 31L + k2) * -7046029254386353131L >>> this.shift);
    }

    private int locateKey(long k1, long k2) {
        LongLongKey[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(k1, k2);
        LongLongKey other;
        while ((other = keyTable[i]) != null) {
            if (other.k1 == k1 && other.k2 == k2) {
                return i;
            }
            i = i + 1 & mask;
        }
        return -(i + 1);
    }

    public V put(long k1, long k2, V value) {
        int i = this.locateKey(k1, k2);
        if (i >= 0) {
            V[] valueTable = this.valueTable;
            V oldValue = valueTable[i];
            valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = new LongLongKey(k1, k2);
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    public V get(long k1, long k2) {
        LongLongKey[] keyTable = this.keyTable;
        int i = this.place(k1, k2);
        LongLongKey other;
        while ((other = keyTable[i]) != null) {
            if (other.k1 == k1 && other.k2 == k2) {
                return this.valueTable[i];
            }
            i = i + 1 & this.mask;
        }
        return null;
    }

    private void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        LongLongKey[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new LongLongKey[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            block0: for (int i = 0; i < oldCapacity; ++i) {
                LongLongKey key = oldKeyTable[i];
                if (key == null) continue;
                int j = this.place(key.k1, key.k2);
                while (true) {
                    if (this.keyTable[j] == null) {
                        this.keyTable[j] = new LongLongKey(key.k1, key.k2);
                        this.valueTable[j] = oldValueTable[i];
                        continue block0;
                    }
                    j = j + 1 & this.mask;
                }
            }
        }
    }

    private static final class LongLongKey {
        private final long k1;
        private final long k2;

        public LongLongKey(long k1, long k2) {
            this.k1 = k1;
            this.k2 = k2;
        }

        public String toString() {
            return "LongLongKey{k1=" + this.k1 + ", k2=" + this.k2 + '}';
        }
    }
}

