/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.collection;

import java.util.Arrays;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.FuryObjectMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.ObjectArray;

public class LongMap<V> {
    public int size;
    long[] keyTable;
    V[] valueTable;
    V zeroValue;
    boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    protected int shift;
    protected int mask;

    public LongMap() {
        this(51, 0.5f);
    }

    public LongMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public LongMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = FuryObjectMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[tableSize];
        this.valueTable = new Object[tableSize];
    }

    public LongMap(LongMap<? extends V> map) {
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size = map.size;
        this.zeroValue = map.zeroValue;
        this.hasZeroValue = map.hasZeroValue;
    }

    protected int place(long item) {
        return (int)(item * -7046029254386353131L >>> this.shift);
    }

    private int locateKey(long key) {
        long[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return i;
            }
            i = i + 1 & mask;
        }
        return -(i + 1);
    }

    public V put(long key, V value) {
        if (key == 0L) {
            V oldValue = this.zeroValue;
            this.zeroValue = value;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            V[] valueTable = this.valueTable;
            V oldValue = valueTable[i];
            valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    private void putResize(long key, V value) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0L) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public V get(long key) {
        if (key == 0L) {
            return this.hasZeroValue ? (V)this.zeroValue : null;
        }
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & this.mask;
        }
        return null;
    }

    public V get(long key, V defaultValue) {
        if (key == 0L) {
            return this.hasZeroValue ? (V)this.zeroValue : null;
        }
        long[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & mask;
        }
        return defaultValue;
    }

    public V remove(long key) {
        if (key == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V oldValue = this.zeroValue;
            this.zeroValue = null;
            --this.size;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != 0L) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0L;
        --this.size;
        return oldValue;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear(int maximumCapacity) {
        int tableSize = FuryObjectMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.hasZeroValue = false;
        this.zeroValue = null;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0L);
        ObjectArray.clearObjectArray(this.valueTable, 0, this.valueTable.length);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsKey(int key) {
        if (key == 0) {
            return this.hasZeroValue;
        }
        return this.locateKey(key) >= 0;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = FuryObjectMap.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    private void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        long[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new long[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                long key = oldKeyTable[i];
                if (key == 0L) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public String toString() {
        long key;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0L) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i]);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0L) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

