/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.meta;

import java.util.ArrayList;
import java.util.List;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.ClassDef;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.ClassSpec;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.Encoders;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.MetaString;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.MetaStringDecoder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

class ClassDefDecoder {
    ClassDefDecoder() {
    }

    public static ClassDef decodeClassDef(ClassResolver classResolver, MemoryBuffer buffer, long id) {
        int size;
        boolean sizeTwoBytes = (id & 0x20L) != 0L;
        MemoryBuffer encoded = MemoryBuffer.newHeapBuffer(32);
        encoded.writeInt64(id);
        if (sizeTwoBytes) {
            size = buffer.readInt16() & 0xFFFF;
            encoded.writeInt16((short)size);
        } else {
            size = buffer.readByte() & 0xFF;
            encoded.writeByte(size);
        }
        byte[] encodedClassDef = buffer.readBytes(size);
        encoded.writeBytes(encodedClassDef);
        if ((id & 0x80L) != 0L) {
            encodedClassDef = classResolver.getFury().getConfig().getMetaCompressor().decompress(encodedClassDef, 0, size);
        }
        MemoryBuffer classDefBuf = MemoryBuffer.fromByteArray(encodedClassDef);
        long header = id & 0xFFL;
        int numClasses = (int)(header & 0xFL);
        if (numClasses == 15) {
            numClasses += classDefBuf.readVarUint32Small7();
        }
        ++numClasses;
        ArrayList<ClassDef.FieldInfo> classFields = new ArrayList<ClassDef.FieldInfo>();
        ClassSpec classSpec = null;
        for (int i = 0; i < numClasses; ++i) {
            String className;
            int currentClassHeader = classDefBuf.readVarUint32Small7();
            boolean isRegistered = (currentClassHeader & 1) != 0;
            int numFields = currentClassHeader >>> 1;
            if (isRegistered) {
                int registeredId = classDefBuf.readVarUint32Small7();
                Class<?> cls = classResolver.getClassInfo((short)registeredId).getCls();
                className = cls.getName();
                classSpec = new ClassSpec(cls);
            } else {
                String pkg = ClassDefDecoder.readPkgName(classDefBuf);
                String typeName = ClassDefDecoder.readTypeName(classDefBuf);
                classSpec = Encoders.decodePkgAndClass(pkg, typeName);
                className = classSpec.entireClassName;
            }
            List<ClassDef.FieldInfo> fieldInfos = ClassDefDecoder.readFieldsInfo(classDefBuf, className, numFields);
            classFields.addAll(fieldInfos);
        }
        Preconditions.checkNotNull(classSpec);
        boolean isObjectType = (header & 0x40L) != 0L;
        return new ClassDef(classSpec, classFields, isObjectType, id, encoded.getBytes(0, encoded.writerIndex()));
    }

    private static List<ClassDef.FieldInfo> readFieldsInfo(MemoryBuffer buffer, String className, int numFields) {
        ArrayList<ClassDef.FieldInfo> fieldInfos = new ArrayList<ClassDef.FieldInfo>(numFields);
        for (int i = 0; i < numFields; ++i) {
            int header = buffer.readByte() & 0xFF;
            int encodingFlags = header >>> 3 & 3;
            boolean useTagID = encodingFlags == 3;
            Preconditions.checkArgument(!useTagID, "Type tag not supported currently, parsed fieldInfos %s", fieldInfos, new Object[0]);
            int size = header >>> 5;
            if (size == 7) {
                size += buffer.readVarUint32Small7();
            }
            MetaString.Encoding encoding = Encoders.fieldNameEncodings[encodingFlags];
            String fieldName = Encoders.FIELD_NAME_DECODER.decode(buffer.readBytes(++size), encoding);
            boolean isMonomorphic = (header & 4) != 0;
            boolean trackingRef = (header & 1) != 0;
            int typeId = buffer.readVarUint32Small14();
            ClassDef.FieldType fieldType = ClassDef.FieldType.read(buffer, isMonomorphic, trackingRef, typeId);
            fieldInfos.add(new ClassDef.FieldInfo(className, fieldName, fieldType));
        }
        return fieldInfos;
    }

    private static String readPkgName(MemoryBuffer buffer) {
        return ClassDefDecoder.readName(Encoders.PACKAGE_DECODER, buffer, Encoders.pkgEncodings);
    }

    private static String readTypeName(MemoryBuffer buffer) {
        return ClassDefDecoder.readName(Encoders.TYPE_NAME_DECODER, buffer, Encoders.typeNameEncodings);
    }

    private static String readName(MetaStringDecoder decoder, MemoryBuffer buffer, MetaString.Encoding[] encodings) {
        int header = buffer.readByte() & 0xFF;
        int encodingFlags = header & 3;
        MetaString.Encoding encoding = encodings[encodingFlags];
        int size = header >> 2;
        if (size == 63) {
            size = buffer.readVarUint32Small7() + 63;
        }
        return decoder.decode(buffer.readBytes(size), encoding);
    }
}

