/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.meta;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple2;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.ClassSpec;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.MetaString;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.MetaStringDecoder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.MetaStringEncoder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.TypeUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.StringUtils;

public class Encoders {
    public static final MetaStringEncoder GENERIC_ENCODER = new MetaStringEncoder('.', '_');
    public static final MetaStringDecoder GENERIC_DECODER = new MetaStringDecoder('.', '_');
    public static final MetaStringEncoder PACKAGE_ENCODER = GENERIC_ENCODER;
    public static final MetaStringDecoder PACKAGE_DECODER = GENERIC_DECODER;
    public static final MetaStringEncoder TYPE_NAME_ENCODER = new MetaStringEncoder('$', '_');
    public static final MetaStringDecoder TYPE_NAME_DECODER = new MetaStringDecoder('$', '_');
    public static final String ARRAY_PREFIX = "1";
    public static final String ENUM_PREFIX = "2";
    static final MetaStringEncoder FIELD_NAME_ENCODER = new MetaStringEncoder('$', '_');
    static final MetaStringDecoder FIELD_NAME_DECODER = new MetaStringDecoder('$', '_');
    private static final ConcurrentMap<String, MetaString> pgkMetaStringCache = new ConcurrentHashMap<String, MetaString>();
    private static final ConcurrentMap<String, MetaString> typeMetaStringCache = new ConcurrentHashMap<String, MetaString>();
    private static final ConcurrentMap<String, MetaString> fieldMetaStringCache = new ConcurrentHashMap<String, MetaString>();
    static final MetaString.Encoding[] pkgEncodings = new MetaString.Encoding[]{MetaString.Encoding.UTF_8, MetaString.Encoding.ALL_TO_LOWER_SPECIAL, MetaString.Encoding.LOWER_UPPER_DIGIT_SPECIAL};
    static final List<MetaString.Encoding> pkgEncodingsList = Arrays.asList(pkgEncodings);
    static final MetaString.Encoding[] typeNameEncodings = new MetaString.Encoding[]{MetaString.Encoding.UTF_8, MetaString.Encoding.LOWER_UPPER_DIGIT_SPECIAL, MetaString.Encoding.FIRST_TO_LOWER_SPECIAL, MetaString.Encoding.ALL_TO_LOWER_SPECIAL};
    static final List<MetaString.Encoding> typeNameEncodingsList = Arrays.asList(typeNameEncodings);
    static final MetaString.Encoding[] fieldNameEncodings = new MetaString.Encoding[]{MetaString.Encoding.UTF_8, MetaString.Encoding.LOWER_UPPER_DIGIT_SPECIAL, MetaString.Encoding.ALL_TO_LOWER_SPECIAL};
    static final List<MetaString.Encoding> fieldNameEncodingsList = Arrays.asList(fieldNameEncodings);

    public static MetaString encodePackage(String pkg) {
        return pgkMetaStringCache.computeIfAbsent(pkg, k -> PACKAGE_ENCODER.encode(pkg, pkgEncodings));
    }

    public static MetaString encodeTypeName(String typeName) {
        return typeMetaStringCache.computeIfAbsent(typeName, k -> TYPE_NAME_ENCODER.encode(typeName, typeNameEncodings));
    }

    public static Tuple2<String, String> encodePkgAndClass(Class<?> cls) {
        String packageName = ReflectionUtils.getPackage(cls);
        String className = ReflectionUtils.getClassNameWithoutPackage(cls);
        if (cls.isArray()) {
            Tuple2<Class<?>, Integer> componentInfo = TypeUtils.getArrayComponentInfo(cls);
            Class ctype = (Class)componentInfo.f0;
            if (!ctype.isPrimitive()) {
                String componentName = ctype.getName();
                packageName = ReflectionUtils.getPackage(componentName);
                String componentSimpleName = ReflectionUtils.getClassNameWithoutPackage(componentName);
                String prefix = StringUtils.repeat(ARRAY_PREFIX, (Integer)componentInfo.f1);
                className = ctype.isEnum() ? prefix + ENUM_PREFIX + componentSimpleName : prefix + componentSimpleName;
            }
        } else if (cls.isEnum()) {
            className = ENUM_PREFIX + className;
        }
        return Tuple2.of(packageName, className);
    }

    public static ClassSpec buildClassSpec(Class<?> cls) {
        if (cls.isArray()) {
            Tuple2<Class<?>, Integer> info = TypeUtils.getArrayComponentInfo(cls);
            return new ClassSpec(cls.getName(), ((Class)info.f0).isEnum(), true, (Integer)info.f1);
        }
        return new ClassSpec(cls.getName(), cls.isEnum(), false, 0);
    }

    public static ClassSpec decodePkgAndClass(String packageName, String className) {
        boolean isEnum;
        String rawPkg = packageName;
        boolean isArray = className.startsWith(ARRAY_PREFIX);
        int dimension = 0;
        if (isArray) {
            while (className.charAt(dimension) == ARRAY_PREFIX.charAt(0)) {
                ++dimension;
            }
            packageName = StringUtils.repeat("[", dimension) + "L" + packageName;
            className = className.substring(dimension) + ";";
        }
        if (isEnum = className.startsWith(ENUM_PREFIX)) {
            className = className.substring(1);
        }
        String entireClassName = StringUtils.isBlank(rawPkg) ? (isArray ? packageName + className : className) : packageName + "." + className;
        return new ClassSpec(entireClassName, isEnum, isArray, dimension);
    }

    public static MetaString encodeFieldName(String fieldName) {
        return fieldMetaStringCache.computeIfAbsent(fieldName, k -> FIELD_NAME_ENCODER.encode(fieldName, fieldNameEncodings));
    }
}

