/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.pool;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import me.mrnavastar.protoweaver.libs.com.google.common.cache.Cache;
import me.mrnavastar.protoweaver.libs.com.google.common.cache.CacheBuilder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.Logger;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.LoggerFactory;
import me.mrnavastar.protoweaver.libs.org.apache.fury.pool.ClassLoaderFuryPooled;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.LoaderBinding;

public class FuryPooledObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FuryPooledObjectFactory.class);
    private final Function<ClassLoader, Fury> furyFactory;
    final Cache<ClassLoader, ClassLoaderFuryPooled> classLoaderFuryPooledCache;
    private volatile ClassLoader classLoader = null;
    private final ThreadLocal<ClassLoader> classLoaderLocal = ThreadLocal.withInitial(() -> {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = Fury.class.getClassLoader();
        }
        return loader;
    });
    private final int minPoolSize;
    private final int maxPoolSize;
    private final Consumer<Fury> factoryCallback;

    public FuryPooledObjectFactory(Function<ClassLoader, Fury> furyFactory, int minPoolSize, int maxPoolSize, long expireTime, TimeUnit timeUnit, Consumer<Fury> factoryCallback) {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.furyFactory = furyFactory;
        this.factoryCallback = factoryCallback;
        this.classLoaderFuryPooledCache = CacheBuilder.newBuilder().expireAfterAccess(expireTime, timeUnit).build();
    }

    public ClassLoaderFuryPooled getPooledCache() {
        try {
            ClassLoader classLoader = this.classLoaderLocal.get();
            assert (classLoader != null);
            ClassLoaderFuryPooled classLoaderFuryPooled = this.classLoaderFuryPooledCache.getIfPresent(classLoader);
            if (classLoaderFuryPooled == null) {
                return this.getOrAddCache(classLoader);
            }
            return classLoaderFuryPooled;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public void setClassLoader(ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
        if (classLoader == null) {
            classLoader = Fury.class.getClassLoader();
        }
        this.classLoader = classLoader;
        this.classLoaderLocal.set(classLoader);
        this.getOrAddCache(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderLocal.get();
    }

    public void clearClassLoader(ClassLoader loader) {
        this.classLoaderFuryPooledCache.invalidate(loader);
        this.classLoaderLocal.remove();
    }

    private synchronized ClassLoaderFuryPooled getOrAddCache(ClassLoader classLoader) {
        ClassLoaderFuryPooled classLoaderFuryPooled = this.classLoaderFuryPooledCache.getIfPresent(classLoader);
        if (classLoaderFuryPooled == null) {
            classLoaderFuryPooled = new ClassLoaderFuryPooled(classLoader, this.furyFactory, this.minPoolSize, this.maxPoolSize);
            classLoaderFuryPooled.setFactoryCallback(this.factoryCallback);
            this.classLoaderFuryPooledCache.put(classLoader, classLoaderFuryPooled);
        }
        return classLoaderFuryPooled;
    }
}

